/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.replay;

import com.sap.ide.webdynpro.ecatt.EcattPlugin;
import com.sap.ide.webdynpro.ecatt.exceptions.EcattException;
import com.sap.ide.webdynpro.ecatt.exceptions.ReplayException;
import com.sap.ide.webdynpro.ecatt.general.TextPool;
import com.sap.ide.webdynpro.ecatt.general.UtilityClass;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScriptParser {
    private IFile script = null;
    private Document scriptDoc = null;
    private TextPool mTextPool = TextPool.getInstance();
    private UtilityClass mUtilityClass = UtilityClass.getInstance();
    private String applicationUrl = null;
    private final String ampersandEscapeString = "&amp;";

    public ScriptParser(IFile script) {
        this.script = script;
    }

    public String execute() throws ReplayException {
        try {
            this.scriptDoc = this.getDOM();
            if (!this.isTestScript()) {
                throw new ReplayException(this.mTextPool.getText(11003));
            }
            this.removeLastPageTag();
            this.removeScreenTags();
            this.removeUrlTags();
            this.removePageAttributes();
            this.removeXmlSchemaAttributes();
            this.addComments();
            this.extractApplicationUrl();
            this.removeElementsInNextAppTags();
            return this.mUtilityClass.domToString(this.scriptDoc);
        }
        catch (EcattException e) {
            throw new ReplayException(this.mTextPool.getText(301) + e.getMessage());
        }
    }

    private Document getDOM() throws ReplayException {
        try {
            File scriptFile = new File(this.script.getLocation().toOSString());
            return this.mUtilityClass.FileToDom(scriptFile);
        }
        catch (Exception e) {
            throw new ReplayException(this.mTextPool.getText(92) + this.mTextPool.getText(23) + e.getMessage());
        }
    }

    private void removeScreenTags() {
        try {
            NodeList screenTags = this.scriptDoc.getElementsByTagName("Screen");
            int i = 0;
            while (i < screenTags.getLength()) {
                Node screenNode = screenTags.item(i);
                screenNode.getParentNode().removeChild(screenNode);
                ++i;
            }
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "removeScreenTags", e.getMessage(), e, true);
        }
    }

    private void removeUrlTags() {
        try {
            NodeList pageNodes = this.scriptDoc.getElementsByTagName("Page");
            int i = 0;
            while (i < pageNodes.getLength()) {
                Node pageNode = pageNodes.item(i);
                NodeList children = pageNode.getChildNodes();
                int j = 0;
                while (j < children.getLength()) {
                    Node child = children.item(j);
                    if (child.getNodeName().equals("Url")) {
                        pageNode.removeChild(child);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "removeUrlTags", e.getMessage(), e, true);
        }
    }

    private void removeLastPageTag() {
        try {
            NodeList pageNodes = this.scriptDoc.getElementsByTagName("Page");
            Node lastPageNode = pageNodes.item(pageNodes.getLength() - 1);
            Node parent = lastPageNode.getParentNode();
            Node removedNode = parent.removeChild(lastPageNode);
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "removeLastPageTag", e.getMessage(), e, true);
        }
    }

    private void removePageAttributes() {
        try {
            NodeList pageNodes = this.scriptDoc.getElementsByTagName("Page");
            int i = 0;
            while (i < pageNodes.getLength()) {
                Node pageNode = pageNodes.item(i);
                if (this.attrExists(pageNode, "sessionID")) {
                    ((Element)pageNode).removeAttribute("sessionID");
                }
                if (this.attrExists(pageNode, "applicationID")) {
                    ((Element)pageNode).removeAttribute("applicationID");
                }
                if (this.attrExists(pageNode, "windowID")) {
                    ((Element)pageNode).removeAttribute("windowID");
                }
                if (this.attrExists(pageNode, "applicationName")) {
                    ((Element)pageNode).removeAttribute("applicationName");
                }
                ++i;
            }
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "removeSessionIDAttributes", e.getMessage(), e, true);
        }
    }

    private void removeElementsInNextAppTags() {
        try {
            NodeList nextAppNodes = this.scriptDoc.getElementsByTagName("Next_application");
            int i = 0;
            while (i < nextAppNodes.getLength()) {
                Node nextAppNode = nextAppNodes.item(i);
                if (this.attrExists(nextAppNode, "sessionID")) {
                    ((Element)nextAppNode).removeAttribute("sessionID");
                }
                if (this.attrExists(nextAppNode, "applicationID")) {
                    ((Element)nextAppNode).removeAttribute("applicationID");
                }
                if (this.attrExists(nextAppNode, "windowID")) {
                    ((Element)nextAppNode).removeAttribute("windowID");
                }
                this.removeTypeValueTags(nextAppNode);
                ++i;
            }
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "removeNextApplicationTags", e.getMessage(), e, true);
        }
    }

    private void removeTypeValueTags(Node nextAppNode) {
        NodeList children = nextAppNode.getChildNodes();
        Node urlNode = null;
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i).getNodeName().equals("Url")) {
                urlNode = children.item(i);
                break;
            }
            ++i;
        }
        if (urlNode == null) {
            return;
        }
        children = urlNode.getChildNodes();
        int i2 = 0;
        while (i2 < children.getLength()) {
            Node child = children.item(i2);
            if (child.getNodeName().equals("Value") || child.getNodeName().equals("Type")) {
                Node removedNode = child.getParentNode().removeChild(child);
            }
            ++i2;
        }
    }

    private void removeXmlSchemaAttributes() {
    }

    private void addComments() {
        try {
            Comment generalInfoComment = this.scriptDoc.createComment(this.mTextPool.getText(11005));
            NodeList list = this.scriptDoc.getElementsByTagName("Generalinfo");
            Node generalInfoNode = list.item(0);
            generalInfoNode.getParentNode().insertBefore(generalInfoComment, generalInfoNode);
            Comment pageComment = this.scriptDoc.createComment(this.mTextPool.getText(11006));
            list = this.scriptDoc.getElementsByTagName("Page");
            Node firstPageNode = list.item(0);
            if (firstPageNode == null) {
                return;
            }
            firstPageNode.getParentNode().insertBefore(pageComment, firstPageNode);
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "addComments", e.getMessage(), e, true);
        }
    }

    private boolean attrExists(Node node, String attributeName) {
        try {
            NamedNodeMap map = node.getAttributes();
            if (map == null) {
                return false;
            }
            int i = 0;
            while (i < map.getLength()) {
                Attr attr = (Attr)map.item(i);
                if (attr.getName().equals(attributeName)) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "attrExists", e.getMessage(), e, true);
        }
        return false;
    }

    private boolean screenTagsExist() {
        NodeList screenTags = this.scriptDoc.getElementsByTagName("Screen");
        return screenTags.getLength() != 0;
    }

    private boolean pageTagsExist() {
        NodeList pageTags = this.scriptDoc.getElementsByTagName("Page");
        return pageTags.getLength() != 0;
    }

    private boolean isTestScript() {
        return this.screenTagsExist() && this.pageTagsExist();
    }

    private void extractApplicationUrl() {
        Element root = this.scriptDoc.getDocumentElement();
        String temp = root.getAttribute("applicationURL");
        this.applicationUrl = temp == null ? "" : temp;
        int index = 0;
        while ((index = this.applicationUrl.indexOf("&amp;", index)) != -1) {
            temp = this.applicationUrl.substring(index, index + 5);
            if (temp.equals("&amp;")) {
                this.applicationUrl = this.applicationUrl.substring(0, index) + "&" + this.applicationUrl.substring(index + 5);
            }
            ++index;
        }
    }

    public String getApplicationUrl() {
        return this.applicationUrl;
    }
}

