/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.replay;

import com.sap.ide.webdynpro.ecatt.exceptions.EcattException;
import com.sap.ide.webdynpro.ecatt.exceptions.ReplayException;
import com.sap.ide.webdynpro.ecatt.general.TextPool;
import com.sap.ide.webdynpro.ecatt.general.UtilityClass;
import com.sap.ide.webdynpro.ecatt.replay.execute.ReplayHelper;
import com.sap.ide.webdynpro.ecatt.replay.util.NextAppEntity;
import com.sap.ide.webdynpro.ecatt.replay.util.ReplayEntity;
import com.sap.ide.webdynpro.ecatt.replay.util.ReplayEntityCollection;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ReplayXMLHandler {
    private String script = null;
    private ReplayEntityCollection mReplayCollection = null;
    private Document scriptDoc = null;
    private DocumentBuilder builder = null;
    private TransformerFactory tfactory = null;
    private TextPool mTextPool = TextPool.getInstance();
    private String mReplayUrl = null;
    private HashMap mXmlnsAttrs = null;
    private ReplayHelper mReplayHelper = null;

    public ReplayXMLHandler(ReplayHelper replayHelper) {
        this.script = replayHelper.getScript();
        this.mReplayCollection = new ReplayEntityCollection();
        this.mReplayUrl = replayHelper.getReplayUrl();
        this.mXmlnsAttrs = replayHelper.getXmlnsAttrs();
        this.mReplayHelper = replayHelper;
    }

    public ReplayEntityCollection execute() throws ReplayException {
        try {
            DocumentBuilderFactory factory;
            ClassLoader _savedClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                this.tfactory = TransformerFactory.newInstance();
                Object var4_4 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
                throw throwable;
            }
            this.builder = factory.newDocumentBuilder();
            this.scriptDoc = this.builder.parse(new ByteArrayInputStream(this.script.getBytes("UTF-8")));
            NodeList pageNodes = this.scriptDoc.getElementsByTagName("Page");
            if (pageNodes != null && pageNodes.getLength() != 0) {
                int i = 0;
                while (i < pageNodes.getLength()) {
                    Node pageNode = pageNodes.item(i);
                    this.executeIndividualCalls(pageNode);
                    ++i;
                }
            }
            this.mReplayCollection.trim();
            return this.mReplayCollection;
        }
        catch (Exception e) {
            throw new ReplayException(e.getMessage());
        }
    }

    private void executeIndividualCalls(Node pageNode) throws ReplayException {
        NextAppEntity nextAppEntity = null;
        String pageName = this.getPageName((Element)pageNode);
        String replaySnippet = this.getReplaySnippet(pageNode);
        nextAppEntity = this.getNextAppEntity(pageNode);
        ReplayEntity replayEntity = new ReplayEntity(pageName, replaySnippet, nextAppEntity, this.mReplayUrl);
        this.mReplayCollection.addReplayEntity(replayEntity);
    }

    private NextAppEntity getNextAppEntity(Node pageNode) throws ReplayException {
        NextAppEntity nextAppEntity = new NextAppEntity();
        Element pageElement = (Element)pageNode;
        NodeList list = pageElement.getElementsByTagName("Next_application");
        if (list == null || list.getLength() == 0) {
            return null;
        }
        list = pageElement.getElementsByTagName("Base_url");
        if (list == null || list.getLength() == 0) {
            throw new ReplayException(this.mTextPool.getText(11024));
        }
        if (!list.item(0).hasChildNodes()) {
            throw new ReplayException(this.mTextPool.getText(11027));
        }
        nextAppEntity.setBaseUrl(((Text)list.item(0).getFirstChild()).getData());
        NodeList paramsList = pageElement.getElementsByTagName("Params");
        if (paramsList == null || paramsList.getLength() == 0) {
            return nextAppEntity;
        }
        Element paramsElement = (Element)paramsList.item(0);
        NodeList paramList = paramsElement.getElementsByTagName("Param");
        if (paramList == null || paramList.getLength() == 0) {
            return nextAppEntity;
        }
        int i = 0;
        while (i < paramList.getLength()) {
            Node paramNode = paramList.item(i);
            NodeList children = paramNode.getChildNodes();
            String key = null;
            String value = null;
            int j = 0;
            while (j < children.getLength()) {
                Node child = children.item(j);
                if (child.getNodeName().equals("Key")) {
                    if (child.hasChildNodes()) {
                        key = ((Text)child.getFirstChild()).getData();
                    } else {
                        throw new ReplayException(this.mTextPool.getText(11028));
                    }
                }
                if (child.getNodeName().equals("Value")) {
                    if (child.hasChildNodes()) {
                        value = ((Text)child.getFirstChild()).getData();
                    } else {
                        throw new ReplayException(this.mTextPool.getText(11029));
                    }
                }
                ++j;
            }
            if (key == null || value == null) {
                throw new ReplayException(this.mTextPool.getText(11025));
            }
            nextAppEntity.addParameter(key, value);
            ++i;
        }
        return nextAppEntity;
    }

    private String getReplaySnippet(Node pageNode) throws ReplayException {
        String replaySnippet = null;
        Document responseDoc = this.builder.newDocument();
        Element root = responseDoc.createElement("SCXML");
        root.setAttribute("version", this.mReplayHelper.getScXmlVersion());
        if (this.mXmlnsAttrs != null && !this.mXmlnsAttrs.isEmpty()) {
            Iterator keys = this.mXmlnsAttrs.keySet().iterator();
            while (keys.hasNext()) {
                String attrName = (String)keys.next();
                String attrValue = (String)this.mXmlnsAttrs.get(attrName);
                root.setAttributeNS("http://www.w3.org/2000/xmlns/", attrName, attrValue);
            }
        }
        Element headerElement = responseDoc.createElement("Header");
        root.appendChild(headerElement);
        Element viewsElement = responseDoc.createElement("Views");
        root.appendChild(viewsElement);
        root.appendChild(responseDoc.importNode(this.getAutomationNode(pageNode), true));
        root.appendChild(responseDoc.importNode(this.getDataNode(pageNode), true));
        responseDoc.appendChild(root);
        try {
            replaySnippet = UtilityClass.getInstance().domToString(responseDoc);
        }
        catch (EcattException ex) {
            throw new ReplayException(this.mTextPool.getText(26) + this.mTextPool.getText(23) + ex.getMessage());
        }
        return replaySnippet;
    }

    private Node getAutomationNode(Node pageNode) throws ReplayException {
        Element pageElement = (Element)pageNode;
        NodeList list = pageElement.getElementsByTagName("Automation");
        if (list == null || list.getLength() == 0) {
            throw new ReplayException(this.mTextPool.getText(11051) + this.mTextPool.getText(11111));
        }
        return list.item(0);
    }

    private Node getDataNode(Node pageNode) throws ReplayException {
        NodeList list = ((Element)pageNode).getElementsByTagName("Data");
        if (list == null || list.getLength() == 0) {
            throw new ReplayException(this.mTextPool.getText(11047));
        }
        return list.item(0);
    }

    private Node getNodeByName(Node rootNode, String name) {
        NodeList nodes = rootNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals(name)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    private String getPageName(Element pageNode) {
        String pageName = null;
        NamedNodeMap attribs = pageNode.getAttributes();
        pageName = pageNode.getAttribute("pageName");
        if (pageName == null) {
            pageName = "";
        }
        return pageName;
    }
}

