/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.replay;

import com.sap.ide.webdynpro.ecatt.EcattPlugin;
import com.sap.ide.webdynpro.ecatt.exceptions.ReplayException;
import com.sap.ide.webdynpro.ecatt.general.TextPool;
import com.sap.ide.webdynpro.ecatt.general.UtilityClass;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.InputSource;

public class ReplayResultXMLGenerator {
    private String result;
    private String applicationURL;
    private Vector pageNames;
    private Document doc;
    private DocumentBuilder builder;
    private Element root;
    private TextPool mTextPool = TextPool.getInstance();
    private HashMap mXmlnsAttrs = null;

    public ReplayResultXMLGenerator(String result, String applicationURL, Vector pageNames) throws ReplayException {
        this.result = result;
        this.applicationURL = applicationURL;
        this.pageNames = pageNames;
        this.mXmlnsAttrs = new HashMap();
        try {
            DocumentBuilderFactory factory;
            ClassLoader _savedClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                Object var7_7 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
                throw throwable;
            }
            this.builder = factory.newDocumentBuilder();
            this.doc = this.builder.newDocument();
            this.root = this.doc.createElement("ResultScript");
            this.root.setAttribute("applicationURL", applicationURL);
            this.doc.appendChild(this.root);
        }
        catch (Exception e) {
            throw new ReplayException(this.mTextPool.getText(25));
        }
    }

    public Document generateXMLDocument() throws ReplayException {
        Vector snippets = this.getSnippets();
        if (snippets.size() == 0) {
            throw new ReplayException(this.mTextPool.getText(51) + this.mTextPool.getText(47));
        }
        int i = 0;
        while (i < snippets.size()) {
            String snippet = (String)snippets.get(i);
            String pageName = "";
            try {
                pageName = (String)this.pageNames.get(i);
            }
            catch (Exception ex) {
                EcattPlugin.internalError(this.getClass(), "generateXMLDocument()", ex.getMessage(), null, true);
            }
            Element responseElement = this.doc.createElement("Response");
            responseElement.setAttribute("Page", pageName);
            this.appendScxmlTag(responseElement, snippet);
            this.root.appendChild(responseElement);
            ++i;
        }
        if (this.mXmlnsAttrs != null && !this.mXmlnsAttrs.isEmpty()) {
            Iterator keys = this.mXmlnsAttrs.keySet().iterator();
            while (keys.hasNext()) {
                String attrName = (String)keys.next();
                String attrValue = (String)this.mXmlnsAttrs.get(attrName);
                this.doc.getDocumentElement().setAttributeNS("http://www.w3.org/2000/xmlns/", attrName, attrValue);
            }
        }
        return this.doc;
    }

    private void appendScxmlTag(Element responseElement, String snippet) throws ReplayException {
        try {
            Document scxmlDoc = this.builder.parse(new InputSource(new StringReader(snippet)));
            NamedNodeMap map = scxmlDoc.getDocumentElement().getAttributes();
            int i = 0;
            while (i < map.getLength()) {
                Attr attr = (Attr)map.item(i);
                if (attr.getName().startsWith("xmlns")) {
                    this.mXmlnsAttrs.put(attr.getName(), attr.getValue());
                }
                ++i;
            }
            responseElement.appendChild(this.doc.importNode(UtilityClass.getInstance().getNodeByName(scxmlDoc, "SCXML"), true));
        }
        catch (Exception e) {
            throw new ReplayException(e.getMessage());
        }
    }

    private Vector getSnippets() throws ReplayException {
        Vector<String> snippets = new Vector<String>(1, 1);
        try {
            int startIndex = this.result.indexOf("<SCXML");
            if (startIndex == -1) {
                return snippets;
            }
            int endIndex = this.result.indexOf("</SCXML>", startIndex) + 8;
            snippets.add(this.result.substring(startIndex, endIndex));
            while ((startIndex = this.result.indexOf("<SCXML", endIndex)) != -1) {
                endIndex = this.result.indexOf("</SCXML>", startIndex) + 8;
                snippets.add(this.result.substring(startIndex, endIndex));
            }
        }
        catch (Exception e) {
            throw new ReplayException(this.mTextPool.getText(11053) + this.mTextPool.getText(23) + e.getMessage());
        }
        return snippets;
    }
}

