/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.replay;

import com.sap.ide.webdynpro.ecatt.exceptions.ReplayException;
import com.sap.ide.webdynpro.ecatt.general.AuthenticationObject;
import com.sap.ide.webdynpro.ecatt.general.TextPool;
import com.sap.ide.webdynpro.ecatt.replay.ReplayXMLHandler;
import com.sap.ide.webdynpro.ecatt.replay.execute.ReplayExecutor;
import com.sap.ide.webdynpro.ecatt.replay.execute.ReplayHelper;
import com.sap.ide.webdynpro.ecatt.replay.util.ReplayEntity;
import com.sap.ide.webdynpro.ecatt.replay.util.ReplayEntityCollection;
import com.sap.ide.webdynpro.ecatt.views.ReplayView;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.widgets.Display;

public class ReplayManager
extends Thread {
    private ReplayView mReplayView = null;
    private Display mDisplay = null;
    private TextPool mTextPool = TextPool.getInstance();
    private Vector mPageNamesOfApplication = null;
    private ReplayHelper mReplayHelper = null;

    public ReplayManager(ReplayView replayView, String replayUrl, AuthenticationObject authObject, String script) {
        this.mReplayView = replayView;
        this.mDisplay = replayView.getDisplay();
        this.mReplayHelper = new ReplayHelper(replayUrl, script, authObject);
    }

    public void run() {
        ReplayExecutor mReplayExecutor = new ReplayExecutor(this, this.mReplayHelper);
        ReplayEntityCollection collection = null;
        try {
            try {
                mReplayExecutor.executeInitialCall();
                if (!this.mReplayHelper.isStopReplay()) {
                    ReplayXMLHandler handler = new ReplayXMLHandler(this.mReplayHelper);
                    collection = handler.execute();
                    if (collection.isEmpty()) {
                        this.appendMessage(this.mTextPool.getText(11010) + this.mTextPool.getText(11011), false);
                    } else {
                        Iterator it = collection.iterator();
                        while (it.hasNext()) {
                            ReplayEntity replayEntity = (ReplayEntity)it.next();
                            if (this.mReplayHelper.isStopReplay()) continue;
                            if (replayEntity.containsNextApplication()) {
                                mReplayExecutor.executeNextApplicationCall(collection, replayEntity);
                                continue;
                            }
                            mReplayExecutor.executeCall(replayEntity);
                        }
                    }
                }
                this.appendMessage("\n" + this.mTextPool.getText(43), false);
                this.appendMessage(this.mTextPool.getText(24), false);
            }
            catch (ReplayException e) {
                this.appendMessage(e.getMessage(), true);
                Object var7_8 = null;
                mReplayExecutor.closeSession(this.mReplayHelper.getAuthenticationObject());
                if (collection == null) {
                    this.setPageNamesOfApplication(null);
                } else {
                    this.setPageNamesOfApplication(collection.getPageNames());
                }
                this.showSaveResultButton();
                this.showReplayButton();
            }
            Object var7_7 = null;
            mReplayExecutor.closeSession(this.mReplayHelper.getAuthenticationObject());
            if (collection == null) {
                this.setPageNamesOfApplication(null);
            } else {
                this.setPageNamesOfApplication(collection.getPageNames());
            }
            this.showSaveResultButton();
            this.showReplayButton();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            mReplayExecutor.closeSession(this.mReplayHelper.getAuthenticationObject());
            if (collection == null) {
                this.setPageNamesOfApplication(null);
            } else {
                this.setPageNamesOfApplication(collection.getPageNames());
            }
            this.showSaveResultButton();
            this.showReplayButton();
            throw throwable;
        }
    }

    public void appendMessage(String message, boolean isError) {
        final String temp = message;
        final boolean isErrorMessage = isError;
        this.mDisplay.asyncExec(new Runnable(){

            public void run() {
                if (isErrorMessage) {
                    ReplayManager.this.mReplayView.reportErrorMessage(temp);
                } else {
                    ReplayManager.this.mReplayView.appendMessage(temp);
                }
            }
        });
    }

    public void appendXML(String xml, String pageName, boolean intialXml) {
        final String temp = xml;
        final String page = pageName;
        final boolean initXml = intialXml;
        this.mDisplay.asyncExec(new Runnable(){

            public void run() {
                if (!initXml) {
                    ((ReplayManager)ReplayManager.this).mReplayView.resultField.append("\n\n" + ReplayManager.this.mTextPool.getText(24));
                } else {
                    ((ReplayManager)ReplayManager.this).mReplayView.resultField.append(ReplayManager.this.mTextPool.getText(24));
                }
                ((ReplayManager)ReplayManager.this).mReplayView.resultField.append("\n" + ReplayManager.this.mTextPool.getText(48) + page + "\n\n");
                ((ReplayManager)ReplayManager.this).mReplayView.resultField.append("\n" + temp);
                ((ReplayManager)ReplayManager.this).mReplayView.resultField.append("\n" + ReplayManager.this.mTextPool.getText(24));
                ((ReplayManager)ReplayManager.this).mReplayView.resultField.setSelection(0);
            }
        });
    }

    private void showSaveResultButton() {
        this.mDisplay.asyncExec(new Runnable(){

            public void run() {
                ReplayManager.this.mReplayView.setPageNames(ReplayManager.this.mPageNamesOfApplication);
                ReplayManager.this.mReplayView.showSaveResultButton(true);
            }
        });
    }

    private void setPageNamesOfApplication(Vector pageNames) {
        this.mPageNamesOfApplication = new Vector(1, 1);
        if (pageNames != null && pageNames.size() != 0) {
            this.mPageNamesOfApplication.addAll(pageNames);
        }
        this.mPageNamesOfApplication.add(0, this.mTextPool.getText(41));
    }

    private void showReplayButton() {
        this.mDisplay.asyncExec(new Runnable(){

            public void run() {
                ((ReplayManager)ReplayManager.this).mReplayView.replayButton.setEnabled(true);
            }
        });
    }
}

