/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.record;

import com.sap.ide.webdynpro.ecatt.EcattPlugin;
import com.sap.ide.webdynpro.ecatt.exceptions.EcattException;
import com.sap.ide.webdynpro.ecatt.general.TextPool;
import com.sap.ide.webdynpro.ecatt.general.UtilityClass;
import com.sap.ide.webdynpro.ecatt.views.RecordingView;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class RecordingXMLGenerator {
    private Document doc = null;
    private Element root;
    private DocumentBuilder builder;
    private int counter = 1;
    private Element pageElement;
    private RecordingView recordingView;
    private final String ampersandEscapeString = "&amp;";
    private TextPool mTextPool = TextPool.getInstance();
    private UtilityClass mUtilityClass = UtilityClass.getInstance();

    public RecordingXMLGenerator(String applicationURL, RecordingView recordingView) {
        this.recordingView = recordingView;
        try {
            DocumentBuilderFactory factory;
            ClassLoader _savedClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                Object var6_6 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
                throw throwable;
            }
            this.builder = factory.newDocumentBuilder();
            this.doc = this.builder.newDocument();
            this.root = this.doc.createElement("Ui_application");
            this.root.setAttribute("applicationURL", this.getEscapedUrl(applicationURL));
            this.doc.appendChild(this.root);
        }
        catch (Exception e) {
            this.appendMessageToView(this.mTextPool.getText(22) + this.mTextPool.getText(23) + e.getMessage(), true);
        }
    }

    public void append(String xml) throws EcattException {
        Document receivedDoc = null;
        try {
            receivedDoc = this.builder.parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception e) {
            throw new EcattException(this.mTextPool.getText(11041) + this.mTextPool.getText(23) + e.getMessage());
        }
        if (this.isEcattInternalError(receivedDoc)) {
            throw new EcattException(this.mTextPool.getText(11046) + "\nMessage: " + this.getEcattInternalMessage(receivedDoc) + "\nStacktrace: " + this.getEcattInternalStackTrace(receivedDoc));
        }
        if (this.isApplicationTerminated(receivedDoc)) {
            throw new EcattException("-->" + this.getAppTerminatedMessage(receivedDoc));
        }
        if (this.isNextApplication(receivedDoc)) {
            if (this.getNextApplicationType(receivedDoc).equals("webdynpro")) {
                this.pageElement.appendChild(this.doc.importNode(receivedDoc.getDocumentElement(), true));
                return;
            }
            String nextUrl = this.getNextApplicationUrl(receivedDoc);
            this.showAppTerminatedDialog(this.mTextPool.getText(11019) + nextUrl);
            throw new EcattException("-->" + this.mTextPool.getText(11020) + nextUrl);
        }
        if (this.counter % 2 != 0) {
            if (this.counter == 1) {
                try {
                    this.addXmlnsAttributes(receivedDoc.getDocumentElement());
                    this.root.appendChild(this.doc.importNode(this.mUtilityClass.getNodeByName(receivedDoc, "Generalinfo"), true));
                }
                catch (Exception e) {
                    throw new EcattException(this.mTextPool.getText(11041) + this.mTextPool.getText(11042) + this.mTextPool.getText(23) + e.getMessage());
                }
            }
            try {
                this.pageElement = this.doc.createElement("Page");
            }
            catch (Exception e) {
                throw new EcattException(this.mTextPool.getText(11043) + this.mTextPool.getText(23) + e.getMessage());
            }
            Element rootElement = receivedDoc.getDocumentElement();
            String pageName = rootElement.getAttribute("pageName");
            String applicationName = rootElement.getAttribute("applicationName");
            String sessionID = rootElement.getAttribute("sessionID");
            String app_ID = rootElement.getAttribute("applicationID");
            String windowID = rootElement.getAttribute("windowID");
            this.pageElement.setAttribute("pageName", pageName);
            this.pageElement.setAttribute("pageName", pageName);
            this.pageElement.setAttribute("applicationName", applicationName);
            this.pageElement.setAttribute("sessionID", sessionID);
            this.pageElement.setAttribute("applicationID", app_ID);
            this.pageElement.setAttribute("windowID", windowID);
            if (this.isUrlTag(receivedDoc)) {
                try {
                    this.pageElement.appendChild(this.doc.importNode(this.mUtilityClass.getNodeByName(receivedDoc, "Url"), true));
                }
                catch (Exception e) {
                    EcattPlugin.internalError(this.getClass(), "append", e.getMessage(), e, true);
                }
            }
            try {
                this.pageElement.appendChild(this.doc.importNode(this.mUtilityClass.getNodeByName(receivedDoc, "Screen"), true));
            }
            catch (Exception e) {
                throw new EcattException(this.mTextPool.getText(11041) + this.mTextPool.getText(11044) + this.mTextPool.getText(23) + e.getMessage());
            }
            this.root.appendChild(this.pageElement);
        } else {
            try {
                this.pageElement.appendChild(this.doc.importNode(this.mUtilityClass.getNodeByName(receivedDoc, "Datachanges"), true));
            }
            catch (Exception e) {
                throw new EcattException(this.mTextPool.getText(11041) + this.mTextPool.getText(11045) + this.mTextPool.getText(23) + e.getMessage());
            }
            try {
                this.pageElement.appendChild(this.doc.importNode(this.mUtilityClass.getNodeByName(receivedDoc, "Actions"), true));
            }
            catch (Exception e) {
                throw new EcattException(this.mTextPool.getText(11041) + this.mTextPool.getText(11045) + this.mTextPool.getText(23) + e.getMessage());
            }
        }
        ++this.counter;
    }

    public Document getDOM() {
        return this.doc;
    }

    private void appendMessageToView(String message, boolean isError) {
        final String temp = message;
        final boolean isErrorMessage = isError;
        this.recordingView.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (isErrorMessage) {
                    RecordingXMLGenerator.this.recordingView.reportErrorMessage(temp);
                } else {
                    RecordingXMLGenerator.this.recordingView.appendMessage(temp);
                }
            }
        });
    }

    private boolean isApplicationTerminated(Document doc) {
        try {
            Element root = doc.getDocumentElement();
            return root.getNodeName().equals("app-terminated");
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isNextApplication(Document doc) {
        try {
            Element root = doc.getDocumentElement();
            return root.getNodeName().equals("Next_application");
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isEcattInternalError(Document doc) {
        try {
            Element root = doc.getDocumentElement();
            return root.getNodeName().equals("eCATTInternal");
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getNextApplicationUrl(Document doc) {
        try {
            NodeList list = doc.getElementsByTagName("Value");
            Element valueElement = (Element)list.item(0);
            Text value = (Text)valueElement.getFirstChild();
            return value.getData();
        }
        catch (Exception e) {
            return "";
        }
    }

    private String getNextApplicationType(Document doc) {
        try {
            NodeList list = doc.getElementsByTagName("Type");
            Element typeElement = (Element)list.item(0);
            Text type = (Text)typeElement.getFirstChild();
            return type.getData();
        }
        catch (Exception e) {
            return "http";
        }
    }

    private String getAppTerminatedMessage(Document doc) {
        try {
            Element root = doc.getDocumentElement();
            Text text = (Text)root.getFirstChild();
            return text.getData();
        }
        catch (Exception e) {
            return "Application has been Terminated";
        }
    }

    private void executeStopRecordingSteps() {
        this.recordingView.getDisplay().asyncExec(new Runnable(){

            public void run() {
                RecordingXMLGenerator.this.recordingView.executeStopRecordingSteps();
            }
        });
    }

    private String getEscapedUrl(String applicationUrl) {
        int index = 0;
        while ((index = applicationUrl.indexOf("&", index)) != -1) {
            String temp = applicationUrl.substring(index, index + 5);
            if (!temp.equals("&amp;")) {
                applicationUrl = applicationUrl.substring(0, index) + "&amp;" + applicationUrl.substring(index + 1);
            }
            index += 2;
        }
        return applicationUrl;
    }

    private void showAppTerminatedDialog(String message) {
        final String temp = message;
        this.recordingView.getDisplay().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)RecordingXMLGenerator.this.mTextPool.getText(11021), (String)temp);
            }
        });
    }

    private boolean isUrlTag(Document doc) {
        try {
            NodeList nodes = doc.getElementsByTagName("Url");
            return nodes != null && nodes.getLength() != 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getEcattInternalMessage(Document doc) {
        try {
            Node messageNode = this.mUtilityClass.getNodeByName(doc, "message");
            Text text = (Text)messageNode.getFirstChild();
            return text.getData();
        }
        catch (Exception e) {
            return "No message supplied";
        }
    }

    private String getEcattInternalStackTrace(Document doc) {
        try {
            Node stacktraceNode = this.mUtilityClass.getNodeByName(doc, "stacktrace");
            Text text = (Text)stacktraceNode.getFirstChild();
            return text.getData();
        }
        catch (Exception e) {
            return "No stacktrace supplied";
        }
    }

    private void addXmlnsAttributes(Element rootOfReceivedDocument) {
        NamedNodeMap map = rootOfReceivedDocument.getAttributes();
        int i = 0;
        while (i < map.getLength()) {
            Attr attr = (Attr)map.item(i);
            if (attr.getName().startsWith("xmlns")) {
                this.root.setAttributeNS("http://www.w3.org/2000/xmlns/", attr.getName(), attr.getValue());
            }
            ++i;
        }
    }
}

