/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.record;

import com.sap.ide.webdynpro.ecatt.EcattPlugin;
import com.sap.ide.webdynpro.ecatt.exceptions.EcattException;
import com.sap.ide.webdynpro.ecatt.general.TextPool;
import com.sap.ide.webdynpro.ecatt.record.RecordingXMLGenerator;
import com.sap.ide.webdynpro.ecatt.views.RecordingView;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.eclipse.swt.SWTException;

public class EcattServer
extends Thread {
    private int port;
    private ServerSocket serverSocket;
    private Socket socket;
    private String applicationURL;
    private RecordingView recordingView;
    private RecordingXMLGenerator xmlGenerator;
    private TextPool mTextPool = TextPool.getInstance();

    public EcattServer(int port, String applicationURL, RecordingView recordingView) {
        this.port = port;
        this.recordingView = recordingView;
        this.applicationURL = applicationURL;
        try {
            this.serverSocket = new ServerSocket(port);
            recordingView.appendMessage(this.mTextPool.getText(21));
            recordingView.appendMessage(this.mTextPool.getText(31) + TextPool.getInstance().getText(32) + port);
        }
        catch (IOException e) {
            recordingView.reportErrorMessage(this.mTextPool.getText(22) + this.mTextPool.getText(33) + this.mTextPool.getText(32) + port);
        }
        this.xmlGenerator = new RecordingXMLGenerator(applicationURL, recordingView);
    }

    public void run() {
        BufferedInputStream in = null;
        try {
            try {
                while (true) {
                    this.socket = this.serverSocket.accept();
                    this.appendMessageToView(this.mTextPool.getText(34), false);
                    in = new BufferedInputStream(this.socket.getInputStream());
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    baos.reset();
                    byte[] buffer = new byte[1024];
                    int length = 0;
                    while ((length = in.read(buffer)) != -1) {
                        baos.write(buffer, 0, length);
                    }
                    String request = baos.toString("UTF-8");
                    baos.close();
                    this.appendMessageToView(this.mTextPool.getText(35) + "\n", false);
                    this.xmlGenerator.append(this.getXML(request));
                    this.enableStopRecordButton();
                    in.close();
                }
            }
            catch (SocketException e) {
                Object var7_10 = null;
                try {
                    this.socket.close();
                }
                catch (IOException e2) {
                    EcattPlugin.internalError(this.getClass(), "run()", e2.getMessage(), e2, true);
                }
                try {
                    this.serverSocket.close();
                }
                catch (IOException e2) {
                    EcattPlugin.internalError(this.getClass(), "run()", e2.getMessage(), e2, true);
                }
                return;
            }
            catch (EcattException ex) {
                if (ex.getMessage().startsWith("-->")) {
                    this.appendMessageToView(ex.getMessage(), false);
                } else {
                    this.appendMessageToView(ex.getMessage(), true);
                }
                this.executeStopRecordingSteps();
                Object var7_11 = null;
                try {
                    this.socket.close();
                }
                catch (IOException e2) {
                    EcattPlugin.internalError(this.getClass(), "run()", e2.getMessage(), e2, true);
                }
                try {
                    this.serverSocket.close();
                }
                catch (IOException e2) {
                    EcattPlugin.internalError(this.getClass(), "run()", e2.getMessage(), e2, true);
                }
            }
            catch (SWTException exception) {
                EcattPlugin.internalError(this.getClass(), "run", exception.getMessage(), exception, true);
                Object var7_12 = null;
                try {
                    this.socket.close();
                }
                catch (IOException e2) {
                    EcattPlugin.internalError(this.getClass(), "run()", e2.getMessage(), e2, true);
                }
                try {
                    this.serverSocket.close();
                }
                catch (IOException e2) {
                    EcattPlugin.internalError(this.getClass(), "run()", e2.getMessage(), e2, true);
                }
            }
            catch (Exception exc) {
                this.appendMessageToView(this.mTextPool.getText(22) + this.mTextPool.getText(23) + exc.getMessage(), true);
                this.executeStopRecordingSteps();
                Object var7_13 = null;
                try {
                    this.socket.close();
                }
                catch (IOException e2) {
                    EcattPlugin.internalError(this.getClass(), "run()", e2.getMessage(), e2, true);
                }
                try {
                    this.serverSocket.close();
                }
                catch (IOException e2) {
                    EcattPlugin.internalError(this.getClass(), "run()", e2.getMessage(), e2, true);
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_14 = null;
            try {
                this.socket.close();
            }
            catch (IOException e2) {
                EcattPlugin.internalError(this.getClass(), "run()", e2.getMessage(), e2, true);
            }
            try {
                this.serverSocket.close();
            }
            catch (IOException e2) {
                EcattPlugin.internalError(this.getClass(), "run()", e2.getMessage(), e2, true);
            }
            throw throwable;
        }
    }

    public void destroy() {
        try {
            this.recordingView.setDOM(this.xmlGenerator.getDOM());
            this.recordingView.serverRunning = false;
            this.socket.close();
            this.serverSocket.close();
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "destroy", e.getMessage(), e, true);
        }
    }

    private String getXML(String request) {
        int startIndex = request.indexOf("<");
        return request.substring(startIndex);
    }

    private void appendMessageToView(String message, boolean isError) {
        final String temp = message;
        final boolean isErrorMessage = isError;
        this.recordingView.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (isErrorMessage) {
                    EcattServer.this.recordingView.reportErrorMessage(temp);
                } else {
                    EcattServer.this.recordingView.appendMessage(temp);
                }
            }
        });
    }

    private void enableStopRecordButton() {
        this.recordingView.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!((EcattServer)EcattServer.this).recordingView.stopRecordButton.isEnabled()) {
                    ((EcattServer)EcattServer.this).recordingView.stopRecordButton.setEnabled(true);
                }
            }
        });
    }

    private void executeStopRecordingSteps() {
        this.recordingView.getDisplay().asyncExec(new Runnable(){

            public void run() {
                EcattServer.this.recordingView.setDOM(EcattServer.this.xmlGenerator.getDOM());
                EcattServer.this.recordingView.executeStopRecordingSteps();
            }
        });
    }
}

