/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.provider;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.webdynpro.ecatt.EcattPlugin;
import com.sap.ide.webdynpro.ecatt.general.TextPool;
import com.sap.ide.webdynpro.ecatt.general.UtilityClass;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;

public class TestScriptResultNodeProvider
implements EntityExistenceProvider,
ChildrenProvider,
ParentProvider {
    private TextPool mTextPool = TextPool.getInstance();

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        return false;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        return null;
    }

    public boolean exists(UniqueName uniqueName) {
        return true;
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return true;
    }

    public UniqueNameEnumeration children(Entity parent) {
        IFolder testScriptResultFolder;
        IFolder resultsFolder;
        IFolder appFolder;
        ArrayList<UniqueName> list = new ArrayList<UniqueName>();
        String projectName = parent.getModel().getUniqueName().getName();
        Entity applicationEntity = parent.getParent();
        DevelopmentObject developmentObject = DataSourceManager.getDataSourceManager((String)projectName).getDevelopmentObject(applicationEntity.getUniqueName());
        Application application = (Application)developmentObject;
        String qualifiedNameOfApplication = application.getQualifiedName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        String scriptName = this.getFileName(parent.getUniqueName().toString());
        IFolder testsFolder = project.getFolder(this.mTextPool.getText(501));
        if (testsFolder.exists() && (appFolder = testsFolder.getFolder(qualifiedNameOfApplication)).exists() && (resultsFolder = appFolder.getFolder(this.mTextPool.getText(502))).exists() && (testScriptResultFolder = resultsFolder.getFolder(qualifiedNameOfApplication + "_" + scriptName)).exists()) {
            Vector resultScripts = this.getResultScripts(testScriptResultFolder);
            int i = 0;
            while (i < resultScripts.size()) {
                IFile resultScript = (IFile)resultScripts.get(i);
                UniqueName uniqueName = ModelAccess.createUniqueName((String)"EcattWebDynpro", (String)"TestScriptResult", (String)(qualifiedNameOfApplication + "_" + scriptName), (String)resultScript.getName(), null);
                list.add(uniqueName);
                ++i;
            }
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(list));
    }

    public boolean isDeleteProviderApplicable(Element element) {
        if (element instanceof Entity) {
            return this.exists(element.getUniqueName());
        }
        return false;
    }

    public boolean canDelete(Element element) {
        return false;
    }

    public void delete(Element element) {
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }

    /*
     * WARNING - void declaration
     */
    public String getFileName(String uniqueName) {
        try {
            int startIndex;
            int endIndex = 0;
            while ((startIndex = uniqueName.indexOf(":", endIndex)) != -1) {
                void var2_3;
                endIndex = var2_3 + true;
            }
            return uniqueName.substring(endIndex);
        }
        catch (Exception e) {
            UtilityClass.showErrorDialog(this.mTextPool.getText(1), this.mTextPool.getText(71));
            return null;
        }
    }

    public Vector getResultScripts(IFolder source) {
        Vector<IFile> result = new Vector<IFile>(1, 1);
        try {
            IResource[] resources = source.members();
            int i = 0;
            while (i < resources.length) {
                IFile file;
                IResource resource = resources[i];
                if (resource.getType() == 1 && (file = (IFile)resource).getFileExtension().equals("testresult")) {
                    result.add(file);
                }
                ++i;
            }
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "getResultScripts", e.getMessage(), e, true);
        }
        return result;
    }

    public UniqueName getParentUniqueName(Element element) {
        String uniqueNameOfScriptResult = element.getUniqueName().toString();
        String complexName = this.extractComplexName(uniqueNameOfScriptResult);
        String qualifiedNameOfApplication = this.extractQualifiedNameOfApplication(complexName);
        String scriptName = this.extractScriptName(complexName);
        return this.createTestScriptUniqueName(qualifiedNameOfApplication, scriptName);
    }

    public UniqueName createTestScriptUniqueName(String qualifiedNameOfApplication, String scriptName) {
        UniqueName uniqueName = ModelAccess.createUniqueName((String)"EcattWebDynpro", (String)"TestScript", (String)qualifiedNameOfApplication, (String)scriptName, null);
        return uniqueName;
    }

    public String extractComplexName(String uniqueNameOfScriptResult) {
        int tempIndex = uniqueNameOfScriptResult.indexOf(":");
        int startIndex = uniqueNameOfScriptResult.indexOf(":", tempIndex + 1) + 1;
        int endIndex = uniqueNameOfScriptResult.indexOf(":", startIndex);
        return uniqueNameOfScriptResult.substring(startIndex, endIndex);
    }

    public String extractQualifiedNameOfApplication(String complexName) {
        int index = complexName.indexOf("_");
        return complexName.substring(0, index);
    }

    public String extractScriptName(String complexName) {
        int index = complexName.indexOf("_");
        return complexName.substring(index + 1);
    }
}

