/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.provider;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.webdynpro.ecatt.EcattPlugin;
import com.sap.ide.webdynpro.ecatt.general.TextPool;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.extension.PropertySetProvider;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestScriptPropertyProvider
implements PropertyGetProvider,
PropertySetProvider {
    private static String description = null;
    private TextPool mTextPool = TextPool.getInstance();

    public Property getProperty(Element element, String propertyName) {
        return null;
    }

    public String getPropertyValue(Element element, String propertyName) {
        if (propertyName.equals("$metaclass")) {
            return "ECTestScript";
        }
        if (propertyName.equals("$name")) {
            return element.getUniqueName().getName();
        }
        if (propertyName.equals("description")) {
            return this.getDescription(element);
        }
        return null;
    }

    public boolean hasProperty(Element element, String propertyName) {
        return false;
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        return null;
    }

    public PropertyEnumeration properties(Element element) {
        return null;
    }

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return true;
    }

    public Property addProperty(Element arg0, String arg1, String arg2) {
        return null;
    }

    public boolean canAddProperty(Element arg0, String arg1, String arg2) {
        return false;
    }

    public boolean canSetPropertyValue(Element arg0, String arg1, String arg2) {
        return true;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        if (!propertyName.equals("description")) {
            return;
        }
        Entity entity = (Entity)element;
        String projectName = entity.getModel().getUniqueName().getName();
        DevelopmentObject developmentObject = DataSourceManager.getDataSourceManager((String)projectName).getDevelopmentObject(entity.getParent().getUniqueName());
        Application application = (Application)developmentObject;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        String projectLocation = project.getLocation().toOSString();
        try {
            File projectDir = new File(projectLocation);
            File testsDir = new File(projectDir, this.mTextPool.getText(501));
            File scriptsDir = new File(testsDir, application.getQualifiedName());
            File script = new File(scriptsDir, this.getFileName(entity.getUniqueName().toString()));
            this.setDescriptionInScript(script, propertyValue);
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "setPropertyValue", e.getMessage(), e, true);
        }
        try {
            IFolder testsFolder = project.getFolder(this.mTextPool.getText(501));
            IFolder scriptsFolder = project.getFolder(application.getQualifiedName());
            IFile script = scriptsFolder.getFile(this.getFileName(entity.getUniqueName().toString()));
            script.refreshLocal(1, null);
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "setPropertyValue", e.getMessage(), e, true);
        }
    }

    public String getDescription(Element element) {
        TestScriptPropertyProvider.setDescription("");
        Entity entity = (Entity)element;
        String projectName = entity.getModel().getUniqueName().getName();
        Entity applicationEntity = entity.getParent();
        DevelopmentObject developmentObject = DataSourceManager.getDataSourceManager((String)projectName).getDevelopmentObject(applicationEntity.getUniqueName());
        Application application = (Application)developmentObject;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        String projectLocation = project.getLocation().toOSString();
        try {
            File projectDir = new File(projectLocation);
            File testsDir = new File(projectDir, this.mTextPool.getText(501));
            File scriptsDir = new File(testsDir, application.getQualifiedName());
            File script = new File(scriptsDir, this.getFileName(entity.getUniqueName().toString()));
            TestScriptHandler handler = new TestScriptHandler();
            this.parseXmlFile(script.getAbsolutePath(), handler, false);
            return description;
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "getDescription", e.getMessage(), e, true);
            return description;
        }
    }

    public void setDescriptionInScript(File script, String value) {
        try {
            DocumentBuilderFactory factory;
            ClassLoader _savedClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                factory = DocumentBuilderFactory.newInstance();
                Object var6_6 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
                throw throwable;
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(script);
            Node descriptionNode = this.getNodeByName(doc, "description");
            NodeList nl = descriptionNode.getChildNodes();
            Node node = nl.item(0);
            if (node == null) {
                descriptionNode.appendChild(doc.createTextNode(value));
            } else {
                node.setNodeValue(value);
            }
            this.writeXmlToFile(doc, script);
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "setDescriptionInScript", e.getMessage(), e, true);
        }
    }

    public Node getNodeByName(Document document, String name) {
        NodeList nodes = document.getElementsByTagName(name);
        return nodes.item(0);
    }

    /*
     * WARNING - void declaration
     */
    public String getFileName(String uniqueName) {
        try {
            int startIndex;
            int endIndex = 0;
            while ((startIndex = uniqueName.indexOf(":", endIndex)) != -1) {
                void var2_3;
                endIndex = var2_3 + true;
            }
            return uniqueName.substring(endIndex);
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "getFileName", e.getMessage(), e, true);
            return null;
        }
    }

    public void writeXmlToFile(Document doc, File file) {
        try {
            TransformerFactory tfactory;
            ClassLoader _savedClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                tfactory = TransformerFactory.newInstance();
                Object var6_6 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
                throw throwable;
            }
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(file);
            Transformer xformer = tfactory.newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.transform(source, result);
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "writeXmlToFile", e.getMessage(), e, true);
        }
    }

    public static void setDescription(String desc) {
        description = desc;
    }

    public void parseXmlFile(String filename, DefaultHandler handler, boolean validating) {
        try {
            SAXParserFactory factory;
            ClassLoader _savedClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                factory = SAXParserFactory.newInstance();
                Object var7_8 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
                throw throwable;
            }
            factory.setValidating(validating);
            factory.newSAXParser().parse(new File(filename), handler);
        }
        catch (SAXException e) {
            EcattPlugin.internalError(this.getClass(), "parseXmlFile", e.getMessage(), e, true);
        }
        catch (ParserConfigurationException ex) {
            EcattPlugin.internalError(this.getClass(), "parseXmlFile", ex.getMessage(), ex, true);
        }
        catch (IOException exc) {
            EcattPlugin.internalError(this.getClass(), "parseXmlFile", exc.getMessage(), exc, true);
        }
    }

    private static class TestScriptHandler
    extends DefaultHandler {
        private boolean isDescriptionTag = false;

        private TestScriptHandler() {
        }

        public void startElement(String namespaceURI, String elementName, String qName, Attributes attrs) {
            if (elementName.equals("description")) {
                this.isDescriptionTag = true;
            }
        }

        public void endElement(String namespaceURI, String sName, String qName) {
            if (this.isDescriptionTag) {
                this.isDescriptionTag = false;
            }
        }

        public void characters(char[] buf, int offset, int len) {
            if (this.isDescriptionTag) {
                String s = new String(buf, offset, len);
                TestScriptPropertyProvider.setDescription(s);
                return;
            }
        }
    }
}

