/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.provider;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectKey;
import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.exception.InvalidKeyException;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.metamodel.webdynpro.WebDynproMDOEnum;
import com.sap.ide.webdynpro.ecatt.EcattPlugin;
import com.sap.ide.webdynpro.ecatt.general.TextPool;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;

public class TestScriptNodeProvider
implements EntityExistenceProvider,
ChildrenProvider,
ParentProvider {
    private TextPool mTextPool = TextPool.getInstance();

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        return false;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        return null;
    }

    public boolean exists(UniqueName uniqueName) {
        return true;
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return true;
    }

    public UniqueNameEnumeration children(Entity parent) {
        Object path = null;
        ArrayList<UniqueName> list = new ArrayList<UniqueName>();
        String projectName = parent.getModel().getUniqueName().getName();
        DevelopmentObject developmentObject = DataSourceManager.getDataSourceManager((String)projectName).getDevelopmentObject(parent.getUniqueName());
        Application application = (Application)developmentObject;
        String qualifiedNameOfApplication = application.getQualifiedName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IFolder testsFolder = project.getFolder(this.mTextPool.getText(501));
        if (testsFolder.exists()) {
            Vector scripts = this.getTestScriptsForApplication(testsFolder, qualifiedNameOfApplication);
            int i = 0;
            while (i < scripts.size()) {
                IFile script = (IFile)scripts.get(i);
                UniqueName uniqueName = ModelAccess.createUniqueName((String)"EcattWebDynpro", (String)"TestScript", (String)qualifiedNameOfApplication, (String)script.getName(), null);
                list.add(uniqueName);
                ++i;
            }
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(list));
    }

    public boolean isDeleteProviderApplicable(Element element) {
        if (element instanceof Entity) {
            return this.exists(element.getUniqueName());
        }
        return false;
    }

    public boolean canDelete(Element element) {
        return false;
    }

    public void delete(Element element) {
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }

    public Vector getTestScriptsForApplication(IFolder testsFolder, String qualifiedNameOfApplication) {
        Vector<IFile> result = new Vector<IFile>(1, 1);
        try {
            IResource[] resources = testsFolder.members();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (resource.getName().equals(qualifiedNameOfApplication)) {
                    IFolder scriptsFolder = testsFolder.getFolder(qualifiedNameOfApplication);
                    IResource[] scripts = scriptsFolder.members();
                    int j = 0;
                    while (j < scripts.length) {
                        IFile file;
                        IResource script = scripts[j];
                        if (script.getType() == 1 && (file = (IFile)script).getFileExtension().equals("testscript")) {
                            result.add(file);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "getTestScriptsForApplication", e.getMessage(), e, true);
        }
        return result;
    }

    public UniqueName getParentUniqueName(Element element) {
        String projectName = element.getModel().getUniqueName().getName();
        String uniqueNameOfScript = element.getUniqueName().toString();
        String qualifiedNameOfApplication = this.getQualifiedNameOfApplication(uniqueNameOfScript);
        String packageName = this.extractPackageName(qualifiedNameOfApplication);
        String applicationName = this.extractApplicationName(qualifiedNameOfApplication);
        return TestScriptNodeProvider.createApplicationUniqueName(projectName, packageName, applicationName);
    }

    public static UniqueName createApplicationUniqueName(String projectName, String packageName, String name) {
        Metamodel metamodel = Metamodel.getInstance((String)projectName);
        DevelopmentObjectKey key = null;
        try {
            key = metamodel.createDevelopmentObjectKey(packageName, name, (MDOEnum)WebDynproMDOEnum.APPLICATION);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        UniqueName uniqueName = null;
        if (key != null) {
            uniqueName = DataSourceManager.createUniqueName((DevelopmentObjectKey)key, (String)"Application");
        }
        return uniqueName;
    }

    public String getQualifiedNameOfApplication(String uniqueName) {
        int tempIndex = uniqueName.indexOf(":");
        int startIndex = uniqueName.indexOf(":", tempIndex + 1) + 1;
        int endIndex = uniqueName.indexOf(":", startIndex);
        return uniqueName.substring(startIndex, endIndex);
    }

    /*
     * WARNING - void declaration
     */
    public String extractPackageName(String qualifiedNameOfApplication) {
        int startIndex;
        int endIndex = 0;
        while ((startIndex = qualifiedNameOfApplication.indexOf(".", endIndex)) != -1) {
            void var2_3;
            endIndex = var2_3 + true;
        }
        return qualifiedNameOfApplication.substring(0, endIndex - 1);
    }

    /*
     * WARNING - void declaration
     */
    public String extractApplicationName(String qualifiedNameOfApplication) {
        int startIndex;
        int endIndex = 0;
        while ((startIndex = qualifiedNameOfApplication.indexOf(".", endIndex)) != -1) {
            void var2_3;
            endIndex = var2_3 + true;
        }
        return qualifiedNameOfApplication.substring(endIndex);
    }
}

