/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.provider;

import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.DeltaTreeProvider;
import com.tssap.selena.model.extension.ModelAware;
import com.tssap.selena.model.util.delta.DefaultModelDeltaNode;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.util.delta.RootModelDeltaNode;
import com.tssap.selena.model.util.delta.TreeModelDeltaNode;
import java.util.HashMap;

public class HierarchyDeltaProvider
implements ModelAware,
DeltaTreeProvider {
    private static HashMap mInstanceMap = new HashMap();
    private String mProjectName;
    private Model mModel;
    private RootModelDeltaNode mRootUpdateNode;

    public void registered(Model model) {
        this.mModel = model;
        this.mProjectName = model.getUniqueName().getName();
        mInstanceMap.put(this.mProjectName, this);
        this.mRootUpdateNode = new RootModelDeltaNode(this.mModel);
    }

    public void unregistered(Model model) {
        if (this.mModel == null || model == null) {
            return;
        }
        if (model != this.mModel) {
            return;
        }
        mInstanceMap.remove(this.mProjectName);
        this.mModel = null;
        this.mProjectName = null;
    }

    public ModelDeltaNode getModelChanges() {
        RootModelDeltaNode updateNode = this.mRootUpdateNode;
        this.mRootUpdateNode = new RootModelDeltaNode(this.mModel);
        return updateNode;
    }

    public void totalUpdate() {
        String message = "HierarchyDeltaProvider: totalUpdate for project: " + this.mModel.getUniqueName().getName();
        System.out.println(message);
        this.mRootUpdateNode.makeTotallyChanged();
    }

    public static HierarchyDeltaProvider getHierarchyDeltaProvider(String projectName) {
        HierarchyDeltaProvider hierarchyDeltaProvider = (HierarchyDeltaProvider)mInstanceMap.get(projectName);
        if (hierarchyDeltaProvider == null) {
            String message = "could not find HierarchyDeltaProvider for project " + projectName;
            System.out.println(message);
        }
        return hierarchyDeltaProvider;
    }

    public void update(UniqueName objectUIN, ModelDeltaNodeKind kindOfUpdate) {
        this.mRootUpdateNode.addDeltaNode((TreeModelDeltaNode)new DefaultModelDeltaNode(this.mModel, objectUIN, kindOfUpdate));
    }

    public void markChanged(UniqueName uniqueName) {
        this.update(uniqueName, ModelDeltaNodeKind.CHANGED);
    }

    public void commitUpdate() {
        this.mModel.getExtensionManager().modelContentsChanged();
    }
}

