/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.provider;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.webdynpro.ecatt.EcattPlugin;
import com.sap.ide.webdynpro.ecatt.general.TextPool;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.tsmodel.application.provider.GenericModelAware;
import com.tssap.dii.dtri.DtriCheckedObjects;
import com.tssap.dii.dtri.DtriRelevantObjects;
import com.tssap.dii.dtri.DtriUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.extension.ObjectPropertyProvider;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

public class EcattDtrInfoProvider
extends GenericModelAware
implements ObjectPropertyProvider {
    private TextPool mTextPool = TextPool.getInstance();

    public Object getObjectPropertyValue(Element element, String propertyName) {
        DtriRelevantObjects result = null;
        Entity entity = (Entity)element;
        if (propertyName.equals("ObjectPropertyName_DtrRelevantObjects")) {
            DtriCheckedObjects dtrCheckedObjects;
            String projectName = element.getModel().getUniqueName().getName();
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project == null) {
                return null;
            }
            ArrayList<IFile> files = new ArrayList<IFile>();
            try {
                IFolder testsFolder = project.getFolder(this.mTextPool.getText(501));
                IFolder scriptsFolder = testsFolder.getFolder(this.getApplication(entity).getQualifiedName());
                if (element.getUniqueName().getSubDomain().equals("TestScript")) {
                    String scriptName = this.getFileName(entity.getUniqueName().toString());
                    IFile script = scriptsFolder.getFile(scriptName);
                    files.add(script);
                } else {
                    IFolder resultsFolder = scriptsFolder.getFolder(this.mTextPool.getText(502));
                    String testScriptResultName = this.getFileName(entity.getUniqueName().toString());
                    String testScriptName = this.getFileName(entity.getParent().getUniqueName().toString());
                    IFolder resultFolder = resultsFolder.getFolder(this.getApplication(entity.getParent()).getQualifiedName() + "_" + testScriptName);
                    IFile testScriptResult = resultFolder.getFile(testScriptResultName);
                    files.add(testScriptResult);
                }
            }
            catch (Exception e) {
                EcattPlugin.internalError(((Object)((Object)this)).getClass(), "getObjectPropertyValue", e.getMessage(), e, true);
            }
            if (!files.isEmpty() && (dtrCheckedObjects = DtriUtil.getDtrCheckedObjects(files)).hasDtrRelevantObjects()) {
                result = new DtriRelevantObjects(dtrCheckedObjects.getDtrRelevantObjectList());
            }
        }
        return result;
    }

    public Enumeration objectPropertyValues(Element element, String propertyName) {
        return null;
    }

    public boolean canSetObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
        return false;
    }

    public void setObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
    }

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return true;
    }

    private Application getApplication(Entity entity) {
        DevelopmentObject developmentObject = DataSourceManager.getDataSourceManager((String)this.getProjectName(entity)).getDevelopmentObject(entity.getParent().getUniqueName());
        return (Application)developmentObject;
    }

    /*
     * WARNING - void declaration
     */
    private String getFileName(String uniqueName) {
        try {
            int startIndex;
            int endIndex = 0;
            while ((startIndex = uniqueName.indexOf(":", endIndex)) != -1) {
                void var2_3;
                endIndex = var2_3 + true;
            }
            return uniqueName.substring(endIndex);
        }
        catch (Exception e) {
            EcattPlugin.internalError(((Object)((Object)this)).getClass(), "getFileName", e.getMessage(), e, true);
            return null;
        }
    }

    private String getProjectName(Entity entity) {
        return entity.getModel().getUniqueName().getName();
    }
}

