/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.general;

import com.sap.ide.webdynpro.ecatt.EcattPlugin;
import com.sap.ide.webdynpro.ecatt.exceptions.EcattException;
import com.sap.ide.webdynpro.ecatt.general.TextPool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class UtilityClass {
    private static UtilityClass mUtilityClass;

    public static final UtilityClass getInstance() {
        if (mUtilityClass == null) {
            mUtilityClass = new UtilityClass();
        }
        return mUtilityClass;
    }

    public static void showErrorDialog(String title, String message) {
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
    }

    public byte[] domToByteArray(Document doc) throws EcattException {
        try {
            TransformerFactory tfactory;
            ClassLoader _savedClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                tfactory = TransformerFactory.newInstance();
                Object var5_5 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
                throw throwable;
            }
            DOMSource source = new DOMSource(doc);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(bout);
            Transformer transformer = tfactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
            return bout.toByteArray();
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "domToByteArray", e.getMessage(), e, true);
            throw new EcattException(TextPool.getInstance().getText(28) + TextPool.getInstance().getText(23) + e.getMessage());
        }
    }

    public Node getNodeByName(Document document, String name) throws EcattException {
        try {
            NodeList nodes = document.getElementsByTagName(name);
            return nodes.item(0);
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "getNodeByName", e.getMessage(), e, true);
            throw new EcattException(e.getMessage());
        }
    }

    public String domToString(Document doc) throws EcattException {
        try {
            TransformerFactory tfactory;
            ClassLoader _savedClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                tfactory = TransformerFactory.newInstance();
                Object var5_5 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
                throw throwable;
            }
            DOMSource source = new DOMSource(doc);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(bout);
            Transformer transformer = tfactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
            String xml = bout.toString("UTF-8");
            return xml;
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "domToString", e.getMessage(), e, true);
            throw new EcattException(e.getMessage());
        }
    }

    public Document stringToDOM(String xml) throws EcattException {
        try {
            DocumentBuilderFactory factory;
            ClassLoader _savedClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                Object var5_5 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
                throw throwable;
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "stringToDOM", e.getMessage(), e, true);
            throw new EcattException(e.getMessage());
        }
    }

    public synchronized String indentXML(String xml) {
        try {
            TransformerFactory tfactory;
            DocumentBuilderFactory factory;
            ClassLoader _savedClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                tfactory = TransformerFactory.newInstance();
                Object var6_6 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
                throw throwable;
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xml)));
            DOMSource source = new DOMSource(doc);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(bout);
            Transformer transformer = tfactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
            return bout.toString("UTF-8");
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "indentXML", e.getMessage(), e, true);
            return xml;
        }
    }

    public synchronized String indentXML(byte[] bytes) {
        try {
            TransformerFactory tfactory;
            DocumentBuilderFactory factory;
            ClassLoader _savedClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                tfactory = TransformerFactory.newInstance();
                Object var6_6 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
                throw throwable;
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
            Document doc = builder.parse(bin);
            DOMSource source = new DOMSource(doc);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(bout);
            Transformer transformer = tfactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
            return bout.toString("UTF-8");
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "indentXML", e.getMessage(), e, true);
            return null;
        }
    }

    public Document FileToDom(File file) throws EcattException {
        if (!file.exists()) {
            throw new EcattException(TextPool.getInstance().getText(11009));
        }
        try {
            DocumentBuilderFactory factory;
            ClassLoader _savedClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                Object var5_5 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
                throw throwable;
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(file);
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "FileToDom", e.getMessage(), e, true);
            throw new EcattException(e.getMessage());
        }
    }

    public Document ByteArrayToDom(byte[] bytes) throws EcattException {
        try {
            DocumentBuilderFactory factory;
            ClassLoader _savedClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                Object var5_5 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
                throw throwable;
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
            return builder.parse(bin);
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "ByteArrayToDom", e.getMessage(), e, true);
            throw new EcattException(e.getMessage());
        }
    }
}

