/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.compare;

import com.sap.ide.webdynpro.ecatt.EcattPlugin;
import com.sap.ide.webdynpro.ecatt.general.UtilityClass;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestScriptResultCompareInput {
    private IFile mTestScriptResult = null;
    private IFile mTempTestScriptResult = null;
    private final String mTempFolderName = "temp";
    private Document mGeneratedDocument = null;
    private Document mTestScriptResultDocument = null;

    public TestScriptResultCompareInput(IFile mTestScriptResult) {
        this.mTestScriptResult = mTestScriptResult;
        this.mTestScriptResultDocument = this.getDOM();
        try {
            DocumentBuilderFactory factory;
            ClassLoader _savedClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                factory = DocumentBuilderFactory.newInstance();
                Object var5_5 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
                throw throwable;
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.mGeneratedDocument = builder.newDocument();
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "TestScriptResultCompareInput", e.getMessage(), e, true);
        }
    }

    public IFile getUIInput() {
        Element root = this.mGeneratedDocument.createElement("ui_diff");
        this.mGeneratedDocument.appendChild(root);
        if (this.mTestScriptResultDocument == null) {
            return null;
        }
        NodeList infoobjectNodeList = this.mTestScriptResultDocument.getElementsByTagName("SCXML");
        if (infoobjectNodeList.getLength() == 0) {
            return null;
        }
        int i = 0;
        while (i < infoobjectNodeList.getLength()) {
            this.searchInfoobjectNode((Element)infoobjectNodeList.item(i), "ui");
            ++i;
        }
        if (this.performFileOperation()) {
            return this.mTempTestScriptResult;
        }
        return null;
    }

    public IFile getContextInput() {
        Element root = this.mGeneratedDocument.createElement("context_diff");
        this.mGeneratedDocument.appendChild(root);
        if (this.mTestScriptResultDocument == null) {
            return null;
        }
        NodeList infoobjectNodeList = this.mTestScriptResultDocument.getElementsByTagName("SCXML");
        if (infoobjectNodeList.getLength() == 0) {
            return null;
        }
        int i = 0;
        while (i < infoobjectNodeList.getLength()) {
            this.searchInfoobjectNode((Element)infoobjectNodeList.item(i), "Data");
            ++i;
        }
        if (this.performFileOperation()) {
            return this.mTempTestScriptResult;
        }
        return null;
    }

    private void searchInfoobjectNode(Element infoobjectElement, String searchNodeName) {
        NodeList nodeList = infoobjectElement.getElementsByTagName(searchNodeName);
        if (nodeList.getLength() == 0) {
            NodeList temp = infoobjectElement.getElementsByTagName("stacktrace");
            if (temp.getLength() != 0) {
                this.appendPageNode(temp.item(0));
            }
        } else {
            this.appendPageNode(nodeList.item(0));
        }
    }

    private void appendPageNode(Node node) {
        Element root = this.mGeneratedDocument.getDocumentElement();
        Element pageElement = this.mGeneratedDocument.createElement("Page");
        pageElement.appendChild(this.mGeneratedDocument.importNode(node, true));
        root.appendChild(pageElement);
    }

    private Document getDOM() {
        try {
            File testScriptResultFile = new File(this.mTestScriptResult.getLocation().toOSString());
            return UtilityClass.getInstance().FileToDom(testScriptResultFile);
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "getDOM", e.getMessage(), e, true);
            return null;
        }
    }

    private boolean performFileOperation() {
        if (this.mGeneratedDocument == null) {
            return false;
        }
        String tempTestScriptResult = "temp.testresult";
        try {
            IFolder testsFolder = (IFolder)this.mTestScriptResult.getParent().getParent().getParent().getParent();
            IFolder tempFolder = testsFolder.getFolder("temp");
            if (!tempFolder.exists()) {
                tempFolder.create(false, true, null);
            }
            this.mTempTestScriptResult = tempFolder.getFile(tempTestScriptResult);
            if (this.mTempTestScriptResult.exists()) {
                this.mTempTestScriptResult.delete(true, null);
            }
            byte[] bytes = UtilityClass.getInstance().domToByteArray(this.mGeneratedDocument);
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            this.mTempTestScriptResult.create((InputStream)in, true, null);
            ((InputStream)in).close();
            return true;
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "performFileOperation", e.getMessage(), e, true);
            return false;
        }
    }
}

