/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.compare;

import com.sap.ide.webdynpro.ecatt.EcattPlugin;
import com.sap.ide.webdynpro.ecatt.general.UtilityClass;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestScriptCompareInput {
    private IFile mTestScript = null;
    private IFile mTempTestScript = null;
    private final String mTempFolderName = "temp";
    private Document mGeneratedDocument = null;
    private Document mTestScriptDocument = null;

    public TestScriptCompareInput(IFile mTestScript) {
        this.mTestScript = mTestScript;
        this.mTestScriptDocument = this.getDOM();
        try {
            DocumentBuilderFactory factory;
            ClassLoader _savedClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                factory = DocumentBuilderFactory.newInstance();
                Object var5_5 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
                throw throwable;
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.mGeneratedDocument = builder.newDocument();
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "TestScriptCompareInput", e.getMessage(), e, true);
        }
    }

    public IFile getUIInput() {
        Element root = this.mGeneratedDocument.createElement("ui_diff");
        this.mGeneratedDocument.appendChild(root);
        if (this.mTestScriptDocument == null) {
            return null;
        }
        NodeList nodeList = this.mTestScriptDocument.getElementsByTagName("ui");
        if (nodeList.getLength() == 0) {
            return null;
        }
        Node completeUI = null;
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.hasChildNodes()) {
                completeUI = node;
                this.appendPageNode(node);
            } else {
                if (completeUI == null) {
                    return null;
                }
                this.appendPageNode(completeUI);
            }
            ++i;
        }
        if (this.performFileOperation()) {
            return this.mTempTestScript;
        }
        return null;
    }

    public IFile getContextInput() {
        Element root = this.mGeneratedDocument.createElement("context_diff");
        this.mGeneratedDocument.appendChild(root);
        if (this.mTestScriptDocument == null) {
            return null;
        }
        NodeList screenNodeList = this.mTestScriptDocument.getElementsByTagName("Screen");
        if (screenNodeList.getLength() == 0) {
            return null;
        }
        int i = 0;
        while (i < screenNodeList.getLength()) {
            Element screenElement = (Element)screenNodeList.item(i);
            NodeList children = screenElement.getElementsByTagName("Data");
            if (children.getLength() != 0) {
                this.appendPageNode(children.item(0));
            }
            ++i;
        }
        if (this.performFileOperation()) {
            return this.mTempTestScript;
        }
        return null;
    }

    private void appendPageNode(Node node) {
        Element root = this.mGeneratedDocument.getDocumentElement();
        Element pageElement = this.mGeneratedDocument.createElement("Page");
        pageElement.appendChild(this.mGeneratedDocument.importNode(node, true));
        root.appendChild(pageElement);
    }

    private Document getDOM() {
        try {
            File scriptFile = new File(this.mTestScript.getLocation().toOSString());
            return UtilityClass.getInstance().FileToDom(scriptFile);
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "getDOM", e.getMessage(), e, true);
            return null;
        }
    }

    private boolean performFileOperation() {
        if (this.mGeneratedDocument == null) {
            return false;
        }
        String tempTestScript = "temp.testscript";
        try {
            IFolder testsFolder = (IFolder)this.mTestScript.getParent().getParent();
            IFolder tempFolder = testsFolder.getFolder("temp");
            if (!tempFolder.exists()) {
                tempFolder.create(false, true, null);
            }
            this.mTempTestScript = tempFolder.getFile(tempTestScript);
            if (this.mTempTestScript.exists()) {
                this.mTempTestScript.delete(true, null);
            }
            byte[] bytes = UtilityClass.getInstance().domToByteArray(this.mGeneratedDocument);
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            this.mTempTestScript.create((InputStream)in, true, null);
            ((InputStream)in).close();
            return true;
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "performFileOperation", e.getMessage(), e, true);
            return false;
        }
    }
}

