/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.compare;

import com.sap.ide.webdynpro.ecatt.compare.EcattBufferedResourceNode;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ZipFileStructureCreator;
import org.eclipse.compare.internal.BufferedResourceNode;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;

public class EcattResourceCompareInput
extends CompareEditorInput {
    private static final boolean NORMALIZE_CASE = true;
    private boolean fThreeWay = false;
    private Object fRoot;
    private IStructureComparator fAncestor;
    private IStructureComparator fLeft;
    private IStructureComparator fRight;
    private IResource fAncestorResource;
    private IResource fLeftResource;
    private IResource fRightResource;
    private DiffTreeViewer fDiffViewer;
    private IAction fOpenAction;

    public EcattResourceCompareInput(CompareConfiguration config) {
        super(config);
    }

    public Viewer createDiffViewer(Composite parent) {
        this.fDiffViewer = new DiffTreeViewer(parent, this.getCompareConfiguration()){

            protected void fillContextMenu(IMenuManager manager) {
                IStructuredSelection ss;
                if (EcattResourceCompareInput.this.fOpenAction == null) {
                    EcattResourceCompareInput.this.fOpenAction = (IAction)new Action(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            1.access$201(this.this$1, null);
                        }
                    };
                    Utilities.initAction((IAction)EcattResourceCompareInput.this.fOpenAction, (ResourceBundle)this.getBundle(), (String)"action.CompareContents.");
                }
                boolean enable = false;
                ISelection selection = this.getSelection();
                if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
                    Object element = ss.getFirstElement();
                    if (element instanceof MyDiffNode) {
                        ITypedElement te = ((MyDiffNode)((Object)element)).getId();
                        if (te != null) {
                            enable = !"FOLDER".equals(te.getType());
                        }
                    } else {
                        enable = true;
                    }
                }
                EcattResourceCompareInput.this.fOpenAction.setEnabled(enable);
                manager.add(EcattResourceCompareInput.this.fOpenAction);
                super.fillContextMenu(manager);
            }

            static /* synthetic */ void access$201(1 x0, SelectionEvent x1) {
                super.handleOpen(x1);
            }
        };
        return this.fDiffViewer;
    }

    public boolean setSelection(ISelection s) {
        IResource[] selection = Utilities.getResources((ISelection)s);
        if (selection.length < 2 || selection.length > 3) {
            return false;
        }
        this.fThreeWay = selection.length == 3;
        this.fLeftResource = selection[0];
        this.fRightResource = selection[1];
        if (this.fThreeWay) {
            this.fLeftResource = selection[1];
            this.fRightResource = selection[2];
        }
        this.fAncestor = null;
        this.fLeft = this.getStructure(this.fLeftResource);
        this.fRight = this.getStructure(this.fRightResource);
        if (this.incomparable(this.fLeft, this.fRight)) {
            return false;
        }
        if (this.fThreeWay) {
            this.fAncestorResource = selection[0];
            this.fAncestor = this.getStructure(this.fAncestorResource);
            if (this.incomparable(this.fAncestor, this.fRight)) {
                return false;
            }
        }
        return true;
    }

    void initializeCompareConfiguration() {
        CompareConfiguration cc = this.getCompareConfiguration();
        if (this.fLeftResource != null) {
            cc.setLeftLabel(this.buildLabel(this.fLeftResource));
            cc.setLeftImage(CompareUIPlugin.getImage((IAdaptable)this.fLeftResource));
        }
        if (this.fRightResource != null) {
            cc.setRightLabel(this.buildLabel(this.fRightResource));
            cc.setRightImage(CompareUIPlugin.getImage((IAdaptable)this.fRightResource));
        }
        if (this.fThreeWay && this.fAncestorResource != null) {
            cc.setAncestorLabel(this.buildLabel(this.fAncestorResource));
            cc.setAncestorImage(CompareUIPlugin.getImage((IAdaptable)this.fAncestorResource));
        }
    }

    private boolean incomparable(IStructureComparator c1, IStructureComparator c2) {
        if (c1 == null || c2 == null) {
            return true;
        }
        return this.isLeaf(c1) != this.isLeaf(c2);
    }

    private boolean isLeaf(IStructureComparator c) {
        if (c instanceof ITypedElement) {
            ITypedElement te = (ITypedElement)c;
            return !"FOLDER".equals(te.getType());
        }
        return false;
    }

    private IStructureComparator getStructure(IResource input) {
        if (input instanceof IContainer) {
            return new BufferedResourceNode(input);
        }
        if (input instanceof IFile) {
            EcattBufferedResourceNode rn = new EcattBufferedResourceNode(input);
            IFile file = (IFile)input;
            String type = EcattResourceCompareInput.normalizeCase(file.getFileExtension());
            if ("JAR".equals(type) || "ZIP".equals(type)) {
                return new ZipFileStructureCreator().getStructure((Object)rn);
            }
            return rn;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object prepareInput(IProgressMonitor pm) throws InvocationTargetException {
        Object object;
        try {
            try {
                String title;
                String format;
                this.fLeftResource.refreshLocal(2, pm);
                this.fRightResource.refreshLocal(2, pm);
                if (this.fThreeWay && this.fAncestorResource != null) {
                    this.fAncestorResource.refreshLocal(2, pm);
                }
                pm.beginTask(Utilities.getString((String)"ResourceCompare.taskName"), -1);
                String leftLabel = this.fLeftResource.getName();
                String rightLabel = this.fRightResource.getName();
                if (this.fThreeWay) {
                    format = Utilities.getString((String)"ResourceCompare.threeWay.title");
                    String ancestorLabel = this.fAncestorResource.getName();
                    title = MessageFormat.format(format, ancestorLabel, leftLabel, rightLabel);
                } else {
                    format = Utilities.getString((String)"ResourceCompare.twoWay.title");
                    title = MessageFormat.format(format, leftLabel, rightLabel);
                }
                this.setTitle(title);
                Differencer d = new Differencer(){

                    protected Object visit(Object parent, int description, Object ancestor, Object left, Object right) {
                        return new MyDiffNode((IDiffContainer)parent, description, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
                    }
                };
                object = this.fRoot = d.findDifferences(this.fThreeWay, pm, null, (Object)this.fAncestor, (Object)this.fLeft, (Object)this.fRight);
                Object var8_8 = null;
            }
            catch (CoreException ex) {
                throw new InvocationTargetException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return object;
    }

    public String getToolTipText() {
        if (this.fLeftResource != null && this.fRightResource != null) {
            String leftLabel = this.fLeftResource.getFullPath().makeRelative().toString();
            String rightLabel = this.fRightResource.getFullPath().makeRelative().toString();
            if (this.fThreeWay) {
                String format = Utilities.getString((String)"ResourceCompare.threeWay.tooltip");
                String ancestorLabel = this.fAncestorResource.getFullPath().makeRelative().toString();
                return MessageFormat.format(format, ancestorLabel, leftLabel, rightLabel);
            }
            String format = Utilities.getString((String)"ResourceCompare.twoWay.tooltip");
            return MessageFormat.format(format, leftLabel, rightLabel);
        }
        return super.getToolTipText();
    }

    private String buildLabel(IResource r) {
        String n = r.getFullPath().toString();
        if (n.charAt(0) == '/') {
            return n.substring(1);
        }
        return n;
    }

    public void saveChanges(IProgressMonitor pm) throws CoreException {
        super.saveChanges(pm);
        if (this.fRoot instanceof DiffNode) {
            block4: {
                try {
                    EcattResourceCompareInput.commit(pm, (DiffNode)this.fRoot);
                    Object var3_2 = null;
                    if (this.fDiffViewer == null) break block4;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (this.fDiffViewer != null) {
                        this.fDiffViewer.refresh();
                    }
                    this.setDirty(false);
                    throw throwable;
                }
                this.fDiffViewer.refresh();
            }
            this.setDirty(false);
            {
            }
        }
    }

    private static void commit(IProgressMonitor pm, DiffNode node) throws CoreException {
        IDiffElement[] children;
        ITypedElement right;
        ITypedElement left;
        if (node instanceof MyDiffNode) {
            ((MyDiffNode)node).clearDirty();
        }
        if ((left = node.getLeft()) instanceof BufferedResourceNode) {
            ((BufferedResourceNode)left).commit(pm);
        }
        if ((right = node.getRight()) instanceof BufferedResourceNode) {
            ((BufferedResourceNode)right).commit(pm);
        }
        if ((children = node.getChildren()) != null) {
            int i = 0;
            while (i < children.length) {
                IDiffElement element = children[i];
                if (element instanceof DiffNode) {
                    EcattResourceCompareInput.commit(pm, (DiffNode)element);
                }
                ++i;
            }
        }
    }

    private static String normalizeCase(String s) {
        if (s != null) {
            return s.toUpperCase();
        }
        return s;
    }

    private class MyDiffNode
    extends DiffNode {
        private boolean fDirty = false;
        private ITypedElement fLastId;
        private String fLastName;

        public MyDiffNode(IDiffContainer parent, int description, ITypedElement ancestor, ITypedElement left, ITypedElement right) {
            super(parent, description, ancestor, left, right);
        }

        public void fireChange() {
            super.fireChange();
            EcattResourceCompareInput.this.setDirty(true);
            this.fDirty = true;
            if (EcattResourceCompareInput.this.fDiffViewer != null) {
                EcattResourceCompareInput.this.fDiffViewer.refresh((Object)this);
            }
        }

        void clearDirty() {
            this.fDirty = false;
        }

        public String getName() {
            if (this.fLastName == null) {
                this.fLastName = super.getName();
            }
            if (this.fDirty) {
                return '<' + this.fLastName + '>';
            }
            return this.fLastName;
        }

        public ITypedElement getId() {
            ITypedElement id = super.getId();
            if (id == null) {
                return this.fLastId;
            }
            this.fLastId = id;
            return id;
        }
    }
}

