/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.actions;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.webdynpro.ecatt.actions.ActionCategories;
import com.sap.ide.webdynpro.ecatt.exceptions.ReplayException;
import com.sap.ide.webdynpro.ecatt.general.TextPool;
import com.sap.ide.webdynpro.ecatt.general.UtilityClass;
import com.sap.ide.webdynpro.ecatt.replay.ScriptParser;
import com.sap.ide.webdynpro.ecatt.views.ReplayView;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ReplayAction
implements IElementSingleAction {
    private final String NAME;
    private final String INFO;
    private final String DESCRIPTION;
    private final Image IMAGE;
    private final ICategory CATEGORY;
    private final String REPLAY_VIEW = "com.sap.ide.webdynpro.ecatt.views.replayView";
    private TextPool mTextPool;

    public ReplayAction() {
        this.INFO = this.NAME = TextPool.getInstance().getText(15);
        this.DESCRIPTION = TextPool.getInstance().getText(16);
        this.IMAGE = SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_REPLAY);
        this.CATEGORY = Category.createDisplayableCategory((ICategory)ActionCategories.getMainProjectCategory(), (String)this.DESCRIPTION, (String)this.NAME, (String)this.INFO, (Image)this.IMAGE);
        this.REPLAY_VIEW = "com.sap.ide.webdynpro.ecatt.views.replayView";
        this.mTextPool = TextPool.getInstance();
    }

    public ICategory getCategory() {
        return this.CATEGORY;
    }

    public boolean isEnabled(Element element) {
        return this.isAvailable(element);
    }

    public boolean isAvailable(Element element) {
        if (element == null) {
            return false;
        }
        UniqueName uniqueName = element.getUniqueName();
        boolean available = uniqueName.getDomain().equals("EcattWebDynpro") && uniqueName.getSubDomain().equals("TestScript");
        return available;
    }

    public void run(Element element) {
        IFile script = null;
        if (!(element instanceof Entity)) {
            return;
        }
        Entity entity = (Entity)element;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        String projectName = entity.getModel().getUniqueName().getName();
        DevelopmentObject developmentObject = DataSourceManager.getDataSourceManager((String)projectName).getDevelopmentObject(entity.getParent().getUniqueName());
        Application application = (Application)developmentObject;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        try {
            IFolder testsFolder = project.getFolder(this.mTextPool.getText(501));
            IFolder scriptsFolder = testsFolder.getFolder(application.getQualifiedName());
            script = scriptsFolder.getFile(this.getFileName(entity.getUniqueName().toString()));
        }
        catch (Exception e) {
            UtilityClass.showErrorDialog(this.mTextPool.getText(1), this.mTextPool.getText(11) + this.mTextPool.getText(23) + e.getMessage());
            return;
        }
        try {
            ScriptParser scriptParser = new ScriptParser(script);
            String replayScript = scriptParser.execute();
            IViewPart view = page.showView("com.sap.ide.webdynpro.ecatt.views.replayView");
            ((ReplayView)view).setScript(replayScript);
            ((ReplayView)view).setEntity(entity);
            ((ReplayView)view).resultField.setText("");
            ((ReplayView)view).messageField.setText("");
            ((ReplayView)view).setApplicationUrl(scriptParser.getApplicationUrl());
        }
        catch (PartInitException e) {
            UtilityClass.showErrorDialog(this.mTextPool.getText(1), this.mTextPool.getText(12));
        }
        catch (ReplayException ex) {
            UtilityClass.showErrorDialog(this.mTextPool.getText(1), ex.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getFileName(String uniqueName) {
        try {
            int startIndex;
            int endIndex = 0;
            while ((startIndex = uniqueName.indexOf(":", endIndex)) != -1) {
                void var2_3;
                endIndex = var2_3 + true;
            }
            return uniqueName.substring(endIndex);
        }
        catch (Exception e) {
            UtilityClass.showErrorDialog(this.mTextPool.getText(1), this.mTextPool.getText(13));
            return null;
        }
    }
}

