/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.actions;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.webdynpro.archivebuilder.ActionTestApplication;
import com.sap.ide.webdynpro.ecatt.EcattPlugin;
import com.sap.ide.webdynpro.ecatt.actions.ActionCategories;
import com.sap.ide.webdynpro.ecatt.general.TextPool;
import com.sap.ide.webdynpro.ecatt.general.UtilityClass;
import com.sap.ide.webdynpro.ecatt.views.RecordingView;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class RecordAction
implements IElementSingleAction {
    private final String NAME;
    private final String INFO;
    private final String DESCRIPTION;
    private final Image IMAGE;
    private final ICategory CATEGORY;
    private int freePort;
    private String applicationURL;
    private ActionTestApplication actionTestApplication;
    private IViewPart view;
    private final String RECORDING_VIEW = "com.sap.ide.webdynpro.ecatt.views.recordingView";
    private TextPool mTextPool;

    public RecordAction() {
        this.INFO = this.NAME = TextPool.getInstance().getText(4);
        this.DESCRIPTION = TextPool.getInstance().getText(5);
        this.IMAGE = SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_RECORD);
        this.CATEGORY = Category.createDisplayableCategory((ICategory)ActionCategories.getMainProjectCategory(), (String)this.DESCRIPTION, (String)this.NAME, (String)this.INFO, (Image)this.IMAGE);
        this.RECORDING_VIEW = "com.sap.ide.webdynpro.ecatt.views.recordingView";
        this.mTextPool = TextPool.getInstance();
    }

    public ICategory getCategory() {
        return this.CATEGORY;
    }

    public boolean isEnabled(Element element) {
        return this.isAvailable(element);
    }

    public boolean isAvailable(Element element) {
        if (element == null) {
            return false;
        }
        UniqueName uniqueName = element.getUniqueName();
        boolean available = uniqueName.getDomain().equals("WebDynpro") && uniqueName.getSubDomain().equals("Application");
        return available;
    }

    public void run(Element element) {
        this.freePort = this.getFreePort();
        if (!(element instanceof Entity)) {
            return;
        }
        Entity entity = (Entity)element;
        String projectName = entity.getModel().getUniqueName().getName();
        DevelopmentObject developmentObject = DataSourceManager.getDataSourceManager((String)projectName).getDevelopmentObject(entity.getUniqueName());
        Application application = (Application)developmentObject;
        this.setApplicationURL(application);
        boolean viewOpened = this.openView(entity);
        if (viewOpened) {
            boolean browserOpened = this.openBrowser(application);
            if (!browserOpened) {
                UtilityClass.showErrorDialog(this.mTextPool.getText(1), this.mTextPool.getText(2));
            } else {
                ((RecordingView)this.view).startServer(this.freePort, this.applicationURL);
            }
        } else {
            UtilityClass.showErrorDialog(this.mTextPool.getText(1), this.mTextPool.getText(3));
        }
    }

    private boolean openView(Entity entity) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            this.view = page.showView("com.sap.ide.webdynpro.ecatt.views.recordingView");
            ((RecordingView)this.view).setEntity(entity);
        }
        catch (PartInitException e) {
            EcattPlugin.internalError(this.getClass(), "openView", e.getMessage(), e, true);
            return false;
        }
        return true;
    }

    private boolean openBrowser(Application application) {
        this.actionTestApplication.run();
        return true;
    }

    private void setApplicationURL(Application application) {
        this.actionTestApplication = new ActionTestApplication(application);
        this.actionTestApplication.addAdditionalParameter("sap.session.plugin=ecatt_v2");
        this.actionTestApplication.addAdditionalParameter("sap.session.plugin_param=eclipse://" + this.getLocalIPAddress() + ":" + this.freePort);
        this.applicationURL = this.actionTestApplication.getApplicationUrl();
    }

    private String getLocalIPAddress() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostAddress();
        }
        catch (Exception e) {
            return "localhost";
        }
    }

    /*
     * Unable to fully structure code
     */
    private int getFreePort() {
        try {
            s = new ServerSocket(12000);
            s.close();
            return 12000;
        }
        catch (Exception e) {
            EcattPlugin.internalError(this.getClass(), "getFreePort()", "Port 12000 is not free", null, true);
            i = 12001;
            ** while (i < 64000)
        }
lbl-1000:
        // 1 sources

        {
            try {
                s = new ServerSocket(i);
                s.close();
                return i;
            }
            catch (Exception e) {
                EcattPlugin.internalError(this.getClass(), "getFreePort()", "Port " + i + " is not free", null, true);
                ++i;
            }
            continue;
        }
lbl17:
        // 1 sources

        return 0;
    }
}

