/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.actions;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.webdynpro.ecatt.actions.ActionCategories;
import com.sap.ide.webdynpro.ecatt.general.TextPool;
import com.sap.ide.webdynpro.ecatt.general.UtilityClass;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class EditAction
implements IElementSingleAction {
    private final String NAME;
    private final String INFO;
    private final String DESCRIPTION;
    private final Image IMAGE;
    private final ICategory CATEGORY;
    private TextPool mTextPool;

    public EditAction() {
        this.INFO = this.NAME = TextPool.getInstance().getText(411);
        this.DESCRIPTION = TextPool.getInstance().getText(412);
        this.IMAGE = SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_ECATT_EDIT);
        this.CATEGORY = Category.createDisplayableCategory((ICategory)ActionCategories.getMainProjectCategory(), (String)this.DESCRIPTION, (String)this.NAME, (String)this.INFO, (Image)this.IMAGE);
        this.mTextPool = TextPool.getInstance();
    }

    public boolean isEnabled(Element element) {
        return this.isAvailable(element);
    }

    public boolean isAvailable(Element element) {
        if (element == null) {
            return false;
        }
        UniqueName uniqueName = element.getUniqueName();
        if (uniqueName.getDomain().equals("EcattWebDynpro")) {
            if (uniqueName.getSubDomain().equals("TestScriptResult")) {
                return true;
            }
            if (uniqueName.getSubDomain().equals("TestScript")) {
                return true;
            }
        }
        return false;
    }

    public void run(Element element) {
        String subDomain = element.getUniqueName().getSubDomain();
        Entity entity = (Entity)element;
        if (subDomain.equals("TestScript")) {
            this.editTestScript(entity);
        } else if (subDomain.equals("TestScriptResult")) {
            this.editTestScriptResult(entity);
        }
    }

    public ICategory getCategory() {
        return this.CATEGORY;
    }

    private void editTestScript(Entity entity) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName(entity));
        try {
            IFolder testsFolder = project.getFolder(this.mTextPool.getText(501));
            IFolder scriptsFolder = testsFolder.getFolder(this.getApplication(entity).getQualifiedName());
            String scriptName = this.getFileName(entity.getUniqueName().toString());
            IFile script = scriptsFolder.getFile(scriptName);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(script);
        }
        catch (Exception e) {
            UtilityClass.showErrorDialog(this.mTextPool.getText(27), this.mTextPool.getText(413));
        }
    }

    private void editTestScriptResult(Entity entity) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName(entity));
        try {
            IFolder testsFolder = project.getFolder(this.mTextPool.getText(501));
            IFolder scriptsFolder = testsFolder.getFolder(this.getApplication(entity.getParent()).getQualifiedName());
            IFolder resultsFolder = scriptsFolder.getFolder(this.mTextPool.getText(502));
            String testScriptResultName = this.getFileName(entity.getUniqueName().toString());
            String testScriptName = this.getFileName(entity.getParent().getUniqueName().toString());
            IFolder resultFolder = resultsFolder.getFolder(this.getApplication(entity.getParent()).getQualifiedName() + "_" + testScriptName);
            IFile testScriptResult = resultFolder.getFile(testScriptResultName);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(testScriptResult);
        }
        catch (Exception e) {
            UtilityClass.showErrorDialog(this.mTextPool.getText(27), this.mTextPool.getText(414));
        }
    }

    private String getProjectName(Entity entity) {
        return entity.getModel().getUniqueName().getName();
    }

    private Application getApplication(Entity entity) {
        DevelopmentObject developmentObject = DataSourceManager.getDataSourceManager((String)this.getProjectName(entity)).getDevelopmentObject(entity.getParent().getUniqueName());
        return (Application)developmentObject;
    }

    /*
     * WARNING - void declaration
     */
    private String getFileName(String uniqueName) {
        try {
            int startIndex;
            int endIndex = 0;
            while ((startIndex = uniqueName.indexOf(":", endIndex)) != -1) {
                void var2_3;
                endIndex = var2_3 + true;
            }
            return uniqueName.substring(endIndex);
        }
        catch (Exception e) {
            UtilityClass.showErrorDialog(this.mTextPool.getText(27), this.mTextPool.getText(71));
            return null;
        }
    }
}

