/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.actions;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.webdynpro.ecatt.EcattPlugin;
import com.sap.ide.webdynpro.ecatt.actions.ActionCategories;
import com.sap.ide.webdynpro.ecatt.general.TextPool;
import com.sap.ide.webdynpro.ecatt.general.UtilityClass;
import com.sap.ide.webdynpro.ecatt.provider.HierarchyDeltaProvider;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DeleteAction
implements IElementSingleAction {
    private final String NAME;
    private final String INFO;
    private final String DESCRIPTION;
    private final Image IMAGE;
    private final ICategory CATEGORY;
    private TextPool mTextPool;

    public DeleteAction() {
        this.INFO = this.NAME = TextPool.getInstance().getText(401);
        this.DESCRIPTION = TextPool.getInstance().getText(402);
        this.IMAGE = SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_ECATT_DELETE);
        this.CATEGORY = Category.createDisplayableCategory((ICategory)ActionCategories.getMainProjectCategory(), (String)this.DESCRIPTION, (String)this.NAME, (String)this.INFO, (Image)this.IMAGE);
        this.mTextPool = TextPool.getInstance();
    }

    public boolean isEnabled(Element element) {
        return this.isAvailable(element);
    }

    public boolean isAvailable(Element element) {
        if (element == null) {
            return false;
        }
        UniqueName uniqueName = element.getUniqueName();
        if (uniqueName.getDomain().equals("EcattWebDynpro")) {
            if (uniqueName.getSubDomain().equals("TestScriptResult")) {
                return true;
            }
            if (uniqueName.getSubDomain().equals("TestScript")) {
                return true;
            }
        }
        return false;
    }

    public void run(Element element) {
        String subDomain = element.getUniqueName().getSubDomain();
        Entity entity = (Entity)element;
        if (subDomain.equals("TestScript")) {
            Vector testResults = this.getAllTestResults(entity);
            if (testResults == null || testResults.size() == 0) {
                if (MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)this.mTextPool.getText(401), (String)this.mTextPool.getText(602))) {
                    this.deleteTestScript(entity);
                    this.updateSelenaModelForTestScript(entity);
                }
            } else if (MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)this.mTextPool.getText(401), (String)this.mTextPool.getText(603))) {
                this.deleteAllTestScriptResults(testResults);
                this.deleteTestScript(entity);
                this.updateSelenaModelForTestScript(entity);
            }
        } else if (subDomain.equals("TestScriptResult") && MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)this.mTextPool.getText(401), (String)this.mTextPool.getText(602))) {
            this.deleteTestScriptResult(entity);
            this.updateSelenaModelForTestScriptResult(entity);
        }
    }

    public ICategory getCategory() {
        return this.CATEGORY;
    }

    private String getProjectName(Entity entity) {
        return entity.getModel().getUniqueName().getName();
    }

    private void updateSelenaModelForTestScript(Entity entity) {
        HierarchyDeltaProvider hierarchyDeltaProvider = HierarchyDeltaProvider.getHierarchyDeltaProvider(this.getProjectName(entity));
        UniqueName applicationUIN = entity.getParent().getUniqueName();
        hierarchyDeltaProvider.markChanged(applicationUIN);
        hierarchyDeltaProvider.commitUpdate();
    }

    private void updateSelenaModelForTestScriptResult(Entity entity) {
        HierarchyDeltaProvider hierarchyDeltaProvider = HierarchyDeltaProvider.getHierarchyDeltaProvider(this.getProjectName(entity));
        UniqueName applicationUIN = entity.getParent().getParent().getUniqueName();
        hierarchyDeltaProvider.markChanged(applicationUIN);
        hierarchyDeltaProvider.commitUpdate();
    }

    private void deleteAllTestScriptResults(Vector testResults) {
        Enumeration enumeration = testResults.elements();
        IFile file = null;
        IFolder resultFolder = null;
        while (enumeration.hasMoreElements()) {
            file = (IFile)enumeration.nextElement();
            resultFolder = (IFolder)file.getParent();
            try {
                file.delete(true, false, null);
            }
            catch (CoreException e) {
                UtilityClass.showErrorDialog(this.mTextPool.getText(27), this.mTextPool.getText(203) + file.getName());
            }
        }
        try {
            resultFolder.delete(true, false, null);
        }
        catch (CoreException e) {
            EcattPlugin.internalError(this.getClass(), "deleteAllTestScriptResults", e.getMessage(), e, true);
        }
    }

    private void deleteTestScript(Entity entity) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName(entity));
        try {
            IFolder testsFolder = project.getFolder(this.mTextPool.getText(501));
            IFolder scriptsFolder = testsFolder.getFolder(this.getApplication(entity).getQualifiedName());
            String scriptName = this.getFileName(entity.getUniqueName().toString());
            IFile script = scriptsFolder.getFile(scriptName);
            script.delete(true, false, null);
        }
        catch (Exception e) {
            UtilityClass.showErrorDialog(this.mTextPool.getText(27), this.mTextPool.getText(201));
        }
    }

    private void deleteTestScriptResult(Entity entity) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName(entity));
        try {
            IFolder testsFolder = project.getFolder(this.mTextPool.getText(501));
            IFolder scriptsFolder = testsFolder.getFolder(this.getApplication(entity.getParent()).getQualifiedName());
            IFolder resultsFolder = scriptsFolder.getFolder(this.mTextPool.getText(502));
            String testScriptResultName = this.getFileName(entity.getUniqueName().toString());
            String testScriptName = this.getFileName(entity.getParent().getUniqueName().toString());
            IFolder resultFolder = resultsFolder.getFolder(this.getApplication(entity.getParent()).getQualifiedName() + "_" + testScriptName);
            if (this.isOnlyOneTestScriptResult(resultFolder)) {
                resultFolder.delete(true, false, null);
            } else {
                IFile testScriptResult = resultFolder.getFile(testScriptResultName);
                testScriptResult.delete(true, false, null);
            }
        }
        catch (Exception e) {
            UtilityClass.showErrorDialog(this.mTextPool.getText(27), this.mTextPool.getText(202));
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getFileName(String uniqueName) {
        try {
            int startIndex;
            int endIndex = 0;
            while ((startIndex = uniqueName.indexOf(":", endIndex)) != -1) {
                void var2_3;
                endIndex = var2_3 + true;
            }
            return uniqueName.substring(endIndex);
        }
        catch (Exception e) {
            UtilityClass.showErrorDialog(this.mTextPool.getText(27), this.mTextPool.getText(71));
            return null;
        }
    }

    private Application getApplication(Entity entity) {
        DevelopmentObject developmentObject = DataSourceManager.getDataSourceManager((String)this.getProjectName(entity)).getDevelopmentObject(entity.getParent().getUniqueName());
        return (Application)developmentObject;
    }

    private boolean isOnlyOneTestScriptResult(IFolder resultFolder) {
        Vector v = this.getAllTestResults(resultFolder);
        return v.size() == 1;
    }

    private Vector getAllTestResults(IFolder resultFolder) {
        Vector<IFile> result = new Vector<IFile>(1, 1);
        try {
            IResource[] resources = resultFolder.members();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (resource.getFileExtension().equals("testresult")) {
                    result.add((IFile)resource);
                }
                ++i;
            }
        }
        catch (Exception e) {
            return null;
        }
        return result;
    }

    private Vector getAllTestResults(Entity testScriptEntity) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName(testScriptEntity));
        try {
            IFolder testsFolder = project.getFolder(this.mTextPool.getText(501));
            IFolder scriptsFolder = testsFolder.getFolder(this.getApplication(testScriptEntity).getQualifiedName());
            IFolder resultsFolder = scriptsFolder.getFolder(this.mTextPool.getText(502));
            String testScriptName = this.getFileName(testScriptEntity.getUniqueName().toString());
            IFolder resultFolder = resultsFolder.getFolder(this.getApplication(testScriptEntity).getQualifiedName() + "_" + testScriptName);
            return this.getAllTestResults(resultFolder);
        }
        catch (Exception e) {
            UtilityClass.showErrorDialog(this.mTextPool.getText(27), e.getMessage());
            return null;
        }
    }
}

