/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.actions;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.webdynpro.ecatt.actions.ActionCategories;
import com.sap.ide.webdynpro.ecatt.compare.EcattResourceCompareInput;
import com.sap.ide.webdynpro.ecatt.general.TextPool;
import com.sap.ide.webdynpro.ecatt.general.UtilityClass;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;

public class CompareWithAction
implements IElementMultiAction {
    private final String NAME;
    private final String INFO;
    private final String DESCRIPTION;
    private final Image IMAGE;
    private final ICategory CATEGORY;
    private TextPool mTextPool;

    public CompareWithAction() {
        this.INFO = this.NAME = TextPool.getInstance().getText(801);
        this.DESCRIPTION = TextPool.getInstance().getText(802);
        this.IMAGE = SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_COMPARE_WITH);
        this.CATEGORY = Category.createDisplayableCategory((ICategory)ActionCategories.getMainProjectCategory(), (String)this.DESCRIPTION, (String)this.NAME, (String)this.INFO, (Image)this.IMAGE);
        this.mTextPool = TextPool.getInstance();
    }

    public boolean isEnabled(Element[] elements) {
        return this.isAvailable(elements);
    }

    public boolean isAvailable(Element[] elements) {
        if (elements.length != 2) {
            return false;
        }
        Element element1 = elements[0];
        Element element2 = elements[1];
        UniqueName uniqueName1 = element1.getUniqueName();
        UniqueName uniqueName2 = element2.getUniqueName();
        String domain1 = uniqueName1.getDomain();
        String domain2 = uniqueName2.getDomain();
        String subDomain1 = uniqueName1.getSubDomain();
        String subDomain2 = uniqueName2.getSubDomain();
        if (domain1.equals("EcattWebDynpro") && domain2.equals("EcattWebDynpro")) {
            if (subDomain1.equals("TestScript") || subDomain1.equals("TestScriptResult")) {
                return subDomain2.equals("TestScript") || subDomain2.equals("TestScriptResult");
            }
            return false;
        }
        return false;
    }

    public void run(Element[] elements) {
        IFile firstInputResource = null;
        IFile secondInputResource = null;
        String firstInputType = null;
        String secondInputType = null;
        Entity entity1 = (Entity)elements[0];
        Entity entity2 = (Entity)elements[1];
        if (entity1.getUniqueName().getSubDomain().equals("TestScript")) {
            firstInputResource = this.getTestScript(entity1);
            firstInputType = "TestScript";
        } else if (entity1.getUniqueName().getSubDomain().equals("TestScriptResult")) {
            firstInputResource = this.getTestScriptResult(entity1);
            firstInputType = "TestScriptResult";
        }
        if (entity2.getUniqueName().getSubDomain().equals("TestScript")) {
            secondInputResource = this.getTestScript(entity2);
            secondInputType = "TestScript";
        } else if (entity2.getUniqueName().getSubDomain().equals("TestScriptResult")) {
            secondInputResource = this.getTestScriptResult(entity2);
            secondInputType = "TestScriptResult";
        }
        if (firstInputResource == null || secondInputResource == null) {
            return;
        }
        CompareConfiguration config = new CompareConfiguration();
        config.setLeftEditable(true);
        config.setRightEditable(true);
        config.setProperty("IGNORE_WHITESPACE", (Object)"true");
        if (firstInputType.equals("TestScript")) {
            config.setLeftLabel(this.getFileName(entity1.getUniqueName().toString()) + " - " + this.mTextPool.getText(805));
            config.setLeftImage(SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_TESTSCRIPT));
        } else if (firstInputType.equals("TestScriptResult")) {
            config.setLeftLabel(this.getFileName(entity1.getUniqueName().toString()) + " - " + this.mTextPool.getText(806));
            config.setLeftImage(SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_TESTSCRIPTRESULT));
        } else {
            config.setLeftLabel("NULL");
        }
        if (secondInputType.equals("TestScript")) {
            config.setRightLabel(this.getFileName(entity2.getUniqueName().toString()) + " - " + this.mTextPool.getText(805));
            config.setRightImage(SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_TESTSCRIPT));
        } else if (secondInputType.equals("TestScriptResult")) {
            config.setRightLabel(this.getFileName(entity2.getUniqueName().toString()) + " - " + this.mTextPool.getText(806));
            config.setRightImage(SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_TESTSCRIPTRESULT));
        } else {
            config.setRightLabel("NULL");
        }
        EcattResourceCompareInput input = new EcattResourceCompareInput(config);
        Object[] resources = new IResource[]{firstInputResource, secondInputResource};
        input.setSelection((ISelection)new StructuredSelection(resources));
        CompareUI.openCompareEditor((CompareEditorInput)input);
    }

    public ICategory getCategory() {
        return this.CATEGORY;
    }

    private IFile getTestScript(Entity entity) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName(entity));
        try {
            IFolder testsFolder = project.getFolder(this.mTextPool.getText(501));
            IFolder scriptsFolder = testsFolder.getFolder(this.getApplication(entity).getQualifiedName());
            String scriptName = this.getFileName(entity.getUniqueName().toString());
            IFile script = scriptsFolder.getFile(scriptName);
            return script;
        }
        catch (Exception e) {
            UtilityClass.showErrorDialog(this.mTextPool.getText(27), TextPool.getInstance().getText(803));
            return null;
        }
    }

    private IFile getTestScriptResult(Entity entity) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName(entity));
        try {
            IFolder testsFolder = project.getFolder(this.mTextPool.getText(501));
            IFolder scriptsFolder = testsFolder.getFolder(this.getApplication(entity.getParent()).getQualifiedName());
            IFolder resultsFolder = scriptsFolder.getFolder(this.mTextPool.getText(502));
            String testScriptResultName = this.getFileName(entity.getUniqueName().toString());
            String testScriptName = this.getFileName(entity.getParent().getUniqueName().toString());
            IFolder resultFolder = resultsFolder.getFolder(this.getApplication(entity.getParent()).getQualifiedName() + "_" + testScriptName);
            IFile testScriptResult = resultFolder.getFile(testScriptResultName);
            return testScriptResult;
        }
        catch (Exception e) {
            UtilityClass.showErrorDialog(this.mTextPool.getText(27), this.mTextPool.getText(804));
            return null;
        }
    }

    private String getProjectName(Entity entity) {
        return entity.getModel().getUniqueName().getName();
    }

    private Application getApplication(Entity entity) {
        DevelopmentObject developmentObject = DataSourceManager.getDataSourceManager((String)this.getProjectName(entity)).getDevelopmentObject(entity.getParent().getUniqueName());
        return (Application)developmentObject;
    }

    /*
     * WARNING - void declaration
     */
    private String getFileName(String uniqueName) {
        try {
            int startIndex;
            int endIndex = 0;
            while ((startIndex = uniqueName.indexOf(":", endIndex)) != -1) {
                void var2_3;
                endIndex = var2_3 + true;
            }
            return uniqueName.substring(endIndex);
        }
        catch (Exception e) {
            UtilityClass.showErrorDialog(this.mTextPool.getText(27), this.mTextPool.getText(71));
            return null;
        }
    }
}

