/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.actions;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.webdynpro.ecatt.actions.ActionCategories;
import com.sap.ide.webdynpro.ecatt.compare.EcattResourceCompareInput;
import com.sap.ide.webdynpro.ecatt.compare.TestScriptCompareInput;
import com.sap.ide.webdynpro.ecatt.compare.TestScriptResultCompareInput;
import com.sap.ide.webdynpro.ecatt.general.TextPool;
import com.sap.ide.webdynpro.ecatt.general.UtilityClass;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;

public class CompareContextAction
implements IElementMultiAction {
    private final String NAME;
    private final String INFO;
    private final String DESCRIPTION;
    private final Image IMAGE;
    private final ICategory CATEGORY;
    private TextPool mTextPool;

    public CompareContextAction() {
        this.INFO = this.NAME = TextPool.getInstance().getText(11014);
        this.DESCRIPTION = TextPool.getInstance().getText(11023);
        this.IMAGE = SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_COMPARE_CONTEXT);
        this.CATEGORY = Category.createDisplayableCategory((ICategory)ActionCategories.getMainProjectCategory(), (String)this.DESCRIPTION, (String)this.NAME, (String)this.INFO, (Image)this.IMAGE);
        this.mTextPool = TextPool.getInstance();
    }

    public boolean isEnabled(Element[] elements) {
        return this.isAvailable(elements);
    }

    public boolean isAvailable(Element[] elements) {
        return false;
    }

    public void run(Element[] elements) {
        IFile testScriptResource = null;
        IFile testScriptResultResource = null;
        Entity entity1 = (Entity)elements[0];
        Entity entity2 = (Entity)elements[1];
        if (entity1.getUniqueName().getSubDomain().equals("TestScript")) {
            testScriptResource = this.getTestScript(entity1);
        } else if (entity1.getUniqueName().getSubDomain().equals("TestScriptResult")) {
            testScriptResultResource = this.getTestScriptResult(entity1);
        } else {
            return;
        }
        if (entity2.getUniqueName().getSubDomain().equals("TestScript")) {
            testScriptResource = this.getTestScript(entity2);
        } else if (entity2.getUniqueName().getSubDomain().equals("TestScriptResult")) {
            testScriptResultResource = this.getTestScriptResult(entity2);
        } else {
            return;
        }
        if (testScriptResource == null || testScriptResultResource == null) {
            return;
        }
        TestScriptCompareInput mTestScriptCompareInput = new TestScriptCompareInput(testScriptResource);
        TestScriptResultCompareInput mTestScriptResultCompareInput = new TestScriptResultCompareInput(testScriptResultResource);
        IFile tsResource = mTestScriptCompareInput.getContextInput();
        IFile tsrResource = mTestScriptResultCompareInput.getContextInput();
        if (tsResource == null || tsrResource == null) {
            UtilityClass.showErrorDialog(this.mTextPool.getText(27), TextPool.getInstance().getText(11015));
            return;
        }
        CompareConfiguration config = new CompareConfiguration();
        config.setLeftEditable(true);
        config.setRightEditable(true);
        config.setProperty("IGNORE_WHITESPACE", (Object)"true");
        config.setLeftLabel(testScriptResource.getName());
        config.setLeftImage(SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_TESTSCRIPT));
        config.setRightLabel(testScriptResultResource.getName());
        config.setRightImage(SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_TESTSCRIPTRESULT));
        EcattResourceCompareInput input = new EcattResourceCompareInput(config);
        Object[] resources = new IResource[]{tsResource, tsrResource};
        input.setSelection((ISelection)new StructuredSelection(resources));
        CompareUI.openCompareEditor((CompareEditorInput)input);
    }

    public ICategory getCategory() {
        return this.CATEGORY;
    }

    private IFile getTestScript(Entity entity) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName(entity));
        try {
            IFolder testsFolder = project.getFolder(this.mTextPool.getText(501));
            IFolder scriptsFolder = testsFolder.getFolder(this.getApplication(entity).getQualifiedName());
            String scriptName = this.getFileName(entity.getUniqueName().toString());
            IFile script = scriptsFolder.getFile(scriptName);
            return script;
        }
        catch (Exception e) {
            UtilityClass.showErrorDialog(this.mTextPool.getText(27), TextPool.getInstance().getText(803));
            return null;
        }
    }

    private IFile getTestScriptResult(Entity entity) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName(entity));
        try {
            IFolder testsFolder = project.getFolder(this.mTextPool.getText(501));
            IFolder scriptsFolder = testsFolder.getFolder(this.getApplication(entity.getParent()).getQualifiedName());
            IFolder resultsFolder = scriptsFolder.getFolder(this.mTextPool.getText(502));
            String testScriptResultName = this.getFileName(entity.getUniqueName().toString());
            String testScriptName = this.getFileName(entity.getParent().getUniqueName().toString());
            IFolder resultFolder = resultsFolder.getFolder(this.getApplication(entity.getParent()).getQualifiedName() + "_" + testScriptName);
            IFile testScriptResult = resultFolder.getFile(testScriptResultName);
            return testScriptResult;
        }
        catch (Exception e) {
            UtilityClass.showErrorDialog(this.mTextPool.getText(27), this.mTextPool.getText(804));
            return null;
        }
    }

    private String getProjectName(Entity entity) {
        return entity.getModel().getUniqueName().getName();
    }

    private Application getApplication(Entity entity) {
        DevelopmentObject developmentObject = DataSourceManager.getDataSourceManager((String)this.getProjectName(entity)).getDevelopmentObject(entity.getParent().getUniqueName());
        return (Application)developmentObject;
    }

    /*
     * WARNING - void declaration
     */
    private String getFileName(String uniqueName) {
        try {
            int startIndex;
            int endIndex = 0;
            while ((startIndex = uniqueName.indexOf(":", endIndex)) != -1) {
                void var2_3;
                endIndex = var2_3 + true;
            }
            return uniqueName.substring(endIndex);
        }
        catch (Exception e) {
            UtilityClass.showErrorDialog(this.mTextPool.getText(27), this.mTextPool.getText(71));
            return null;
        }
    }
}

