/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.generation.pp;

import com.sap.ide.generationfwk.naming.NamingGenerationUnitJava;
import com.sap.ide.generationfwk.pp.Entity;
import com.sap.ide.generationfwk.pp.File;
import com.sap.ide.generationfwk.pp.IPublicPartXML;
import com.sap.ide.generationfwk.pp.PublicPart;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceImplementation;
import com.sap.ide.metamodel.webdynpro.component.view.InterfaceView;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.webdynpro.checklayer.model.ModelPPObserver;
import com.sap.ide.webdynpro.generation.dependency.DependencyService;
import com.sap.ide.webdynpro.generation.naming.NamingService;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Map;

public final class PPEntityFileResolver
implements IPublicPartXML {
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$sap$ide$webdynpro$generation$pp$PPEntityFileResolver == null ? (class$com$sap$ide$webdynpro$generation$pp$PPEntityFileResolver = PPEntityFileResolver.class$("com.sap.ide.webdynpro.generation.pp.PPEntityFileResolver")) : class$com$sap$ide$webdynpro$generation$pp$PPEntityFileResolver).getName());
    public static final String ENTITY_TYP_COMMON_MODEL = "Common Model";
    public static final String ENTITY_TYP_WEB_DYNPRO_COMPONENT = "Web Dynpro Component";
    public static final String ENTITY_TYP_WEB_DYNPRO_COMPONENT_INTERFACE_DEFINITION = "Web Dynpro Component Interface Definition";
    static /* synthetic */ Class class$com$sap$ide$webdynpro$generation$pp$PPEntityFileResolver;

    public static void resolveFiles(NamingService namingService, DependencyService dependencyService, Map componentMap, Map componentInterfaceDefinitionMap, Map modelMap, PublicPart publicPart, Entity entity) {
        String lQualifiedName = null;
        lQualifiedName = entity.getPackage() != null && entity.getPackage().length() > 0 ? entity.getPackage().replace('/', '.') + '.' + entity.getName() : entity.getName();
        if (entity.getEntityType().equals(ENTITY_TYP_WEB_DYNPRO_COMPONENT)) {
            if (componentMap.containsKey(lQualifiedName)) {
                PPEntityFileResolver.resolveWebDynproComponent(namingService, dependencyService, (Component)componentMap.get(lQualifiedName), publicPart, entity);
            }
        } else if (entity.getEntityType().equals(ENTITY_TYP_WEB_DYNPRO_COMPONENT_INTERFACE_DEFINITION)) {
            if (componentInterfaceDefinitionMap.containsKey(lQualifiedName)) {
                PPEntityFileResolver.resolveWebDynproComponentInterfaceDefinition(namingService, dependencyService, (ComponentInterfaceDefinition)componentInterfaceDefinitionMap.get(lQualifiedName), publicPart, entity);
            }
        } else if (entity.getEntityType().equals(ENTITY_TYP_COMMON_MODEL) && modelMap.containsKey(lQualifiedName)) {
            PPEntityFileResolver.resolveCommonModel(namingService, dependencyService, (Model)modelMap.get(lQualifiedName), publicPart, entity);
        }
    }

    private static void resolveCommonModel(NamingService namingService, DependencyService dependencyService, Model model, PublicPart publicPart, Entity entity) {
        ArrayList<File> lFileList = new ArrayList<File>();
        String[] lFileNames = null;
        boolean lIsGeneration = dependencyService.getModelDependencies(model).isModelGeneration();
        MainDevelopmentObject[] lModelEntities = ModelPPObserver.getModelEntities((Model)model);
        int i = 0;
        while (i < lModelEntities.length) {
            block14: {
                block16: {
                    block15: {
                        lFileNames = PPEntityFileResolver.mdoToRelativeFilePath(lModelEntities[i], Boolean.TRUE, Boolean.TRUE);
                        int j = 0;
                        while (j < lFileNames.length) {
                            lFileList.add(new File(lFileNames[j], "relative", "src"));
                            ++j;
                        }
                        if (!lIsGeneration) break block14;
                        if (!(lModelEntities[i] instanceof ModelClass)) break block15;
                        lFileNames = PPEntityFileResolver.javaToRelativeFilePath(namingService.getModelClassNaming((ModelClass)lModelEntities[i]));
                        break block16;
                    }
                    if (!(lModelEntities[i] instanceof Model)) break block14;
                    lFileNames = PPEntityFileResolver.javaToRelativeFilePath(namingService.getModelNaming((Model)lModelEntities[i]));
                }
                int j = 0;
                while (j < lFileNames.length) {
                    lFileList.add(new File(lFileNames[j], "relative", "bin"));
                    ++j;
                }
            }
            ++i;
        }
        MainDevelopmentObject[] lDdicEntities = new MainDevelopmentObject[]{};
        try {
            lDdicEntities = ModelPPObserver.getDDICEntities((Model)model);
        }
        catch (LoadException e) {
            TRACE_LOCATION.catching((Throwable)e);
            return;
        }
        com.sap.dictionary.tools.generation.naming.NamingService lDdicNS = new com.sap.dictionary.tools.generation.naming.NamingService(namingService.getTargetPath());
        int i2 = 0;
        while (i2 < lDdicEntities.length) {
            lFileNames = PPEntityFileResolver.mdoToRelativeFilePath(lDdicEntities[i2], Boolean.TRUE, Boolean.TRUE);
            int j = 0;
            while (j < lFileNames.length) {
                lFileList.add(new File(lFileNames[j], "relative", "src"));
                ++j;
            }
            if (lIsGeneration) {
                if (lDdicEntities[i2] instanceof DtSimpleType) {
                    lFileList.add(new File(PPEntityFileResolver.absoluteToRelativePath(namingService.getTargetPath(), lDdicNS.getSimpleTypeNaming((DtSimpleType)lDdicEntities[i2]).getAbsoluteFilePath()), "relative", "gen"));
                } else if (lDdicEntities[i2] instanceof DtGeneralStructure) {
                    lFileList.add(new File(PPEntityFileResolver.absoluteToRelativePath(namingService.getTargetPath(), lDdicNS.getStructureNaming((DtGeneralStructure)lDdicEntities[i2]).getAbsoluteFilePath()), "relative", "gen"));
                }
            }
            ++i2;
        }
        File[] lFiles = new File[lFileList.size()];
        entity.setFiles(lFileList.toArray(lFiles));
    }

    private static void resolveWebDynproComponent(NamingService namingService, DependencyService dependencyService, Component component, PublicPart publicPart, Entity entity) {
        ArrayList<File> lFileList = new ArrayList<File>();
        String[] lFileNames = null;
        lFileNames = PPEntityFileResolver.mdoToRelativeFilePath((MainDevelopmentObject)component, true, true);
        int i = 0;
        while (i < lFileNames.length) {
            lFileList.add(new File(lFileNames[i], "relative", "src"));
            ++i;
        }
        if (component.hasComponentInterface()) {
            int i2;
            int i3;
            int i4;
            ComponentInterfaceImplementation lComponentInterfaceImplementation = component.getComponentInterface();
            lFileNames = PPEntityFileResolver.mdoToRelativeFilePath((MainDevelopmentObject)lComponentInterfaceImplementation, true, true);
            int i5 = 0;
            while (i5 < lFileNames.length) {
                lFileList.add(new File(lFileNames[i5], "relative", "src"));
                ++i5;
            }
            if (lComponentInterfaceImplementation.hasConfigurationController()) {
                lFileNames = PPEntityFileResolver.mdoToRelativeFilePath((MainDevelopmentObject)lComponentInterfaceImplementation.getConfigurationController(), false, true);
                i4 = 0;
                while (i4 < lFileNames.length) {
                    lFileList.add(new File(lFileNames[i4], "relative", "src"));
                    ++i4;
                }
                lFileNames = PPEntityFileResolver.mdoToRelativeFilePath((MainDevelopmentObject)lComponentInterfaceImplementation.getConfigurationController(), true, false);
                i3 = 0;
                while (i3 < lFileNames.length) {
                    lFileList.add(new File(lFileNames[i3], "relative", "gen"));
                    ++i3;
                }
                lFileNames = PPEntityFileResolver.javaToRelativeFilePath(namingService.getControllerExternalInterfaceNaming(lComponentInterfaceImplementation.getConfigurationController()));
                i2 = 0;
                while (i2 < lFileNames.length) {
                    lFileList.add(new File(lFileNames[i2], "relative", "bin"));
                    ++i2;
                }
            }
            if (lComponentInterfaceImplementation.hasInterfaceController()) {
                lFileNames = PPEntityFileResolver.mdoToRelativeFilePath((MainDevelopmentObject)lComponentInterfaceImplementation.getInterfaceController(), false, true);
                i4 = 0;
                while (i4 < lFileNames.length) {
                    lFileList.add(new File(lFileNames[i4], "relative", "src"));
                    ++i4;
                }
                lFileNames = PPEntityFileResolver.mdoToRelativeFilePath((MainDevelopmentObject)lComponentInterfaceImplementation.getInterfaceController(), true, false);
                i3 = 0;
                while (i3 < lFileNames.length) {
                    lFileList.add(new File(lFileNames[i3], "relative", "gen"));
                    ++i3;
                }
                lFileNames = PPEntityFileResolver.javaToRelativeFilePath(namingService.getControllerExternalInterfaceNaming(lComponentInterfaceImplementation.getInterfaceController()));
                i2 = 0;
                while (i2 < lFileNames.length) {
                    lFileList.add(new File(lFileNames[i2], "relative", "bin"));
                    ++i2;
                }
            }
            InterfaceView[] lInterfaceViews = lComponentInterfaceImplementation.getInterfaceViews();
            i3 = 0;
            while (i3 < lInterfaceViews.length) {
                lFileNames = PPEntityFileResolver.mdoToRelativeFilePath((MainDevelopmentObject)lInterfaceViews[i3], true, true);
                int j = 0;
                while (j < lFileNames.length) {
                    lFileList.add(new File(lFileNames[j], "relative", "src"));
                    ++j;
                }
                if (lInterfaceViews[i3].hasViewController()) {
                    lFileNames = PPEntityFileResolver.mdoToRelativeFilePath((MainDevelopmentObject)lInterfaceViews[i3].getViewController(), true, true);
                    int j2 = 0;
                    while (j2 < lFileNames.length) {
                        lFileList.add(new File(lFileNames[j2], "relative", "src"));
                        ++j2;
                    }
                }
                ++i3;
            }
        }
        lFileList.add(new File(PPEntityFileResolver.absoluteToRelativePath(namingService.getTargetPath(), namingService.getComponentRuntimeRepositoryNaming(component).getAbsoluteFilePath()), "relative", "gen"));
        File[] lFiles = new File[lFileList.size()];
        entity.setFiles(lFileList.toArray(lFiles));
    }

    private static void resolveWebDynproComponentInterfaceDefinition(NamingService namingService, DependencyService dependencyService, ComponentInterfaceDefinition componentInterfaceDefinition, PublicPart publicPart, Entity entity) {
        int i;
        int i2;
        ArrayList<File> lFileList = new ArrayList<File>();
        String[] lFileNames = null;
        lFileNames = PPEntityFileResolver.mdoToRelativeFilePath((MainDevelopmentObject)componentInterfaceDefinition, true, true);
        int i3 = 0;
        while (i3 < lFileNames.length) {
            lFileList.add(new File(lFileNames[i3], "relative", "src"));
            ++i3;
        }
        if (componentInterfaceDefinition.hasConfigurationController()) {
            lFileNames = PPEntityFileResolver.mdoToRelativeFilePath((MainDevelopmentObject)componentInterfaceDefinition.getConfigurationController(), true, true);
            i2 = 0;
            while (i2 < lFileNames.length) {
                lFileList.add(new File(lFileNames[i2], "relative", "src"));
                ++i2;
            }
            lFileNames = PPEntityFileResolver.javaToRelativeFilePath(namingService.getControllerExternalInterfaceNaming(componentInterfaceDefinition.getConfigurationController()));
            i = 0;
            while (i < lFileNames.length) {
                lFileList.add(new File(lFileNames[i], "relative", "bin"));
                ++i;
            }
        }
        if (componentInterfaceDefinition.hasInterfaceController()) {
            lFileNames = PPEntityFileResolver.mdoToRelativeFilePath((MainDevelopmentObject)componentInterfaceDefinition.getInterfaceController(), true, true);
            i2 = 0;
            while (i2 < lFileNames.length) {
                lFileList.add(new File(lFileNames[i2], "relative", "src"));
                ++i2;
            }
            lFileNames = PPEntityFileResolver.javaToRelativeFilePath(namingService.getControllerExternalInterfaceNaming(componentInterfaceDefinition.getInterfaceController()));
            i = 0;
            while (i < lFileNames.length) {
                lFileList.add(new File(lFileNames[i], "relative", "bin"));
                ++i;
            }
        }
        InterfaceView[] lInterfaceViews = componentInterfaceDefinition.getInterfaceViews();
        i = 0;
        while (i < lInterfaceViews.length) {
            lFileNames = PPEntityFileResolver.mdoToRelativeFilePath((MainDevelopmentObject)lInterfaceViews[i], true, true);
            int j = 0;
            while (j < lFileNames.length) {
                lFileList.add(new File(lFileNames[j], "relative", "src"));
                ++j;
            }
            if (lInterfaceViews[i].hasViewController()) {
                lFileNames = PPEntityFileResolver.mdoToRelativeFilePath((MainDevelopmentObject)lInterfaceViews[i].getViewController(), true, true);
                int j2 = 0;
                while (j2 < lFileNames.length) {
                    lFileList.add(new File(lFileNames[j2], "relative", "src"));
                    ++j2;
                }
            }
            ++i;
        }
        lFileList.add(new File(PPEntityFileResolver.absoluteToRelativePath(namingService.getTargetPath(), namingService.getComponentInterfaceDefinitionRuntimeRepositoryNaming(componentInterfaceDefinition).getAbsoluteFilePath()), "relative", "gen"));
        File[] lFiles = new File[lFileList.size()];
        entity.setFiles(lFileList.toArray(lFiles));
    }

    private static String[] mdoToRelativeFilePath(MainDevelopmentObject mdo, boolean mdoFile, boolean xlfFile) {
        ArrayList<String> lFileList = new ArrayList<String>();
        String[] lFileNames = null;
        if (mdoFile) {
            lFileList.add(NamingGenerationUnitJava.packageToPath((String)mdo.getQualifiedName()) + '.' + mdo.getMetaClass().getFileExtension());
        }
        if (xlfFile) {
            lFileList.add(NamingGenerationUnitJava.packageToPath((String)mdo.getQualifiedName()) + '.' + mdo.getMetaClass().getFileExtension() + '.' + "xlf");
            lFileList.add(NamingGenerationUnitJava.packageToPath((String)mdo.getQualifiedName()) + '.' + mdo.getMetaClass().getFileExtension() + "_*" + '.' + "xlf");
        }
        lFileNames = new String[lFileList.size()];
        return lFileList.toArray(lFileNames);
    }

    private static String[] javaToRelativeFilePath(NamingGenerationUnitJava namingJava) {
        String[] lFileNames = new String[]{NamingGenerationUnitJava.packageToPath((String)namingJava.getQualifiedName()) + '.' + "class", NamingGenerationUnitJava.packageToPath((String)namingJava.getQualifiedName()) + "$*" + '.' + "class"};
        return lFileNames;
    }

    private static String absoluteToRelativePath(String rootPath, String absolutePath) {
        return absolutePath.substring(rootPath.length() + 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

