/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.compilation.file;

import com.sap.engine.compilation.file.DirObject;
import java.io.File;
import java.io.IOException;

public class FileStructure {
    protected DirObject workDir;
    protected DirObject classpathDir;
    protected DirObject sourceDir;
    protected DirObject classesDir;
    protected String name;

    protected FileStructure(String parentDir, String name) throws IOException {
        this.name = name;
        if (new File(parentDir + name).exists()) {
            throw new IOException("Compiler with that name already exists !");
        }
        this.workDir = new DirObject(parentDir, name);
        this.classpathDir = this.workDir.createSubDir("classpath");
        this.sourceDir = this.workDir.createSubDir("source");
        this.classesDir = this.workDir.createSubDir("classes");
    }

    public void deleteFileStructure() {
        this.workDir.deleteDir(true);
    }

    public String getName() {
        return this.name;
    }
}

