/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.compilation.file;

import com.sap.engine.compilation.file.FileObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class DirObject
extends File {
    private Hashtable files = new Hashtable(5);
    private Hashtable dirs = new Hashtable(5);

    protected DirObject(String root, String name) {
        super(root + name);
        if (!this.exists()) {
            this.mkdir();
        }
    }

    public synchronized FileObject createFile(String name) {
        if (this.files.containsKey(name)) {
            return (FileObject)this.files.get(name);
        }
        FileObject file = new FileObject(this.toString() + name);
        this.files.put(name, file);
        return file;
    }

    public synchronized DirObject createSubDir(String name) {
        DirObject dir = new DirObject(this.toString(), name);
        dir.mkdir();
        this.dirs.put(name, dir);
        return dir;
    }

    public synchronized DirObject createPackage(String pack) {
        StringTokenizer tokenizer = new StringTokenizer(pack, "./");
        DirObject temp = this;
        while (tokenizer.hasMoreTokens()) {
            temp = temp.createSubDir(tokenizer.nextToken());
        }
        return temp;
    }

    public FileObject copyFile(String name, InputStream input) throws IOException {
        if (!this.files.contains(name)) {
            this.createFile(name);
        }
        FileObject file = (FileObject)this.files.get(name);
        file.copy(input);
        return file;
    }

    public void refresh(DirObject dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int fi = 0;
        while (fi < files.length) {
            if (files[fi].isDirectory()) {
                DirObject sub = dir.createSubDir(files[fi].getName());
                this.refresh(sub);
            } else {
                dir.createFile(files[fi].getName());
            }
            ++fi;
        }
    }

    public synchronized void deleteDir(boolean itSelf) {
        Enumeration dirEnum = this.dirs.elements();
        while (dirEnum.hasMoreElements()) {
            ((DirObject)dirEnum.nextElement()).deleteDir(true);
        }
        Enumeration filEnum = this.files.elements();
        while (filEnum.hasMoreElements()) {
            ((FileObject)filEnum.nextElement()).delete();
        }
        if (itSelf) {
            super.delete();
        }
    }

    public synchronized void deleteFiles() {
        Enumeration filEnum = this.files.elements();
        while (filEnum.hasMoreElements()) {
            ((FileObject)filEnum.nextElement()).delete();
        }
    }

    public String toString() {
        return this.getAbsolutePath() + File.separatorChar;
    }
}

