/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.compilation;

import com.sap.engine.compilation.Compiler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class PureSource {
    private String _classname;
    private String _package;
    private String source;
    private String encoding = null;

    public PureSource(String classname, String source) {
        if (classname.indexOf(46) > -1) {
            this._classname = classname.substring(classname.lastIndexOf(46) + 1);
            this._package = classname.substring(0, classname.lastIndexOf(46));
        } else {
            this._classname = classname;
            this._package = "";
        }
        this.source = source;
    }

    public PureSource(String classname, String source, String encoding) {
        if (classname.indexOf(46) > -1) {
            this._classname = classname.substring(classname.lastIndexOf(46) + 1);
            this._package = classname.substring(0, classname.lastIndexOf(46));
        } else {
            this._classname = classname;
            this._package = "";
        }
        this.source = source;
        this.encoding = encoding;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String get_classname() {
        return this._classname;
    }

    public void set_classname(String _classname) {
        this._classname = _classname;
    }

    public String get_package() {
        return this._package;
    }

    public void set_package(String _package) {
        this._package = _package;
    }

    public InputStream get_source() {
        if (this.encoding != null) {
            try {
                return new ByteArrayInputStream(this.source.getBytes(this.encoding));
            }
            catch (UnsupportedEncodingException uee) {
                Compiler.traceError("PureSource.get_source()", "Unsupported encoding : " + Compiler.exceptionTrace(uee));
                Compiler.logInfo("Unsupported encoding : " + this.encoding + "\r\n Will use default jdk encoding...");
                return new ByteArrayInputStream(this.source.getBytes());
            }
        }
        return new ByteArrayInputStream(this.source.getBytes());
    }
}

