/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.compilation;

import com.sap.engine.compilation.Compiler;
import com.sap.engine.compilation.CompilerException;
import com.sap.engine.compilation.InternalJavaCompiler;
import java.io.IOException;

public class InternalCompiler
extends Compiler {
    private InternalJavaCompiler internal;
    private boolean finished = false;
    private boolean success = false;

    public InternalCompiler(String root, String name) throws IOException {
        super(root, name);
    }

    public void compile() throws CompilerException {
        this.internal = new InternalJavaCompiler(this);
        this.finished = false;
        this.internal.go();
        InternalCompiler internalCompiler = this;
        synchronized (internalCompiler) {
            if (!this.finished) {
                try {
                    this.wait();
                }
                catch (InterruptedException iex) {
                    Compiler.traceDebug("InternalCompiler.compile()", "COMIPILATION: Interrupted! Reason:" + iex.getMessage());
                }
            }
        }
        if (!this.success) {
            throw new CompilerException("Compilation failed. Errors : " + this.internal.errors);
        }
    }

    public void compile(String[] args) throws CompilerException {
        this.setArgs(args);
        this.compile();
    }

    public synchronized void finishedCompilation(boolean success) {
        this.success = success;
        this.finished = true;
        this.notifyAll();
    }

    public String getErrorMessage() {
        return this.internal.error;
    }

    public String getOutputMessage() {
        return this.internal.output;
    }
}

