/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.compilation;

import com.sap.engine.compilation.Compiler;
import com.sap.engine.compilation.CompilerException;
import com.sap.engine.compilation.CompilerProcessFailureException;
import com.sap.engine.compilation.ExCommandLine;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ExternalCompiler
extends Compiler {
    private InputReader inReader;
    private ErrorReader errReader;

    public ExternalCompiler(String root, String name) throws IOException {
        super(root, name);
    }

    public synchronized void compile() throws CompilerException {
        Process process = null;
        ExCommandLine exParams = null;
        try {
            String javaHome = this.resolver.getJavaHome();
            String javac_command = javaHome != null ? javaHome + File.separatorChar + "javac" : "javac";
            exParams = this.getExCommandLineParams();
            ArrayList params = exParams.commandLine;
            params.add(0, javac_command);
            String[] args = params.toArray(new String[params.size()]);
            String cmdLine = this.getAsString(params);
            Compiler.traceInfo("ExternalCompiler.compiler() : ", "Executing line : " + cmdLine);
            if (exParams.isOptimized) {
                String rawCmdLine = this.getAsString(exParams.rawCommandLine);
                Compiler.traceInfo("ExternalCompiler.compiler() : ", " Raw params = " + rawCmdLine);
            }
            process = Runtime.getRuntime().exec(args);
        }
        catch (IOException ioex) {
            this.cleanFiles(exParams);
            Compiler.traceError("ExternalCompiler.compile()", "Error while compiling : " + Compiler.exceptionTrace(ioex));
            throw new CompilerProcessFailureException("Cannot " + ioex.getMessage());
        }
        this.inReader = new InputReader(process);
        this.errReader = new ErrorReader(process);
        Thread iReader = new Thread(this.inReader);
        iReader.start();
        Thread eReader = new Thread(this.errReader);
        eReader.start();
        int res = 0;
        try {
            try {
                res = process.waitFor();
            }
            catch (InterruptedException iex) {
                Compiler.traceError("ExternalCompiler.compile()", "Error while compiling : " + Compiler.exceptionTrace(iex));
                throw new CompilerException(iex.getMessage());
            }
            Object var10_12 = null;
            this.cleanFiles(exParams);
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.cleanFiles(exParams);
            throw throwable;
        }
        if (res != 0) {
            this.classpathDir.deleteDir(false);
            String str = " Compilation Failed! Exit Code=" + res;
            if (this.errReader != null) {
                str = str + " ;Error stream contains:\"" + this.errReader.getResult() + "\"";
            }
            Compiler.traceInfo("ExternalCompiler.compile()", str);
            throw new CompilerException(str);
        }
    }

    private void cleanFiles(ExCommandLine exParams) {
        if (exParams != null && exParams.isOptimized) {
            try {
                File file = new File(exParams.optionsFileName);
                file.delete();
                file = new File(exParams.srcFileName);
                file.delete();
            }
            catch (Exception e) {
                Compiler.traceDebug("ExternalCompiler.compile()", "COMIPILATION: Can not delete options/source files! Reason:" + e.getMessage());
            }
        }
    }

    public void compile(String[] args) throws CompilerException {
        this.override = args;
        this.compile();
    }

    public void finishedCompilation(boolean success) {
    }

    public String getErrorMessage() {
        return this.errReader.getResult();
    }

    public String getOutputMessage() {
        return this.inReader.getResult();
    }

    private String getAsString(List list) {
        StringBuffer buf = new StringBuffer();
        char chB = '<';
        char chE = '>';
        int i = 0;
        while (i < list.size()) {
            buf.append(chB);
            buf.append(list.get(i).toString());
            buf.append(chE);
            ++i;
        }
        return buf.toString();
    }

    private class ErrorReader
    implements Runnable {
        InputStream is = null;
        ByteArrayOutputStream baos;

        public ErrorReader(Process process) {
            this.is = process.getErrorStream();
            this.baos = new ByteArrayOutputStream();
        }

        public void run() {
            try {
                byte[] out = new byte[128];
                int len = 0;
                while ((len = this.is.read(out)) != -1) {
                    this.baos.write(out, 0, len);
                }
            }
            catch (Exception e) {
                Compiler.traceError("ExternalCompiler.ErrorReader.run()", "Error in processing error stream : " + Compiler.exceptionTrace(e));
            }
        }

        public String getResult() {
            return this.baos.toString();
        }

        public int size() {
            return this.baos.size();
        }
    }

    private class InputReader
    implements Runnable {
        InputStream is = null;
        ByteArrayOutputStream baos;

        public InputReader(Process process) {
            this.is = process.getInputStream();
        }

        public void run() {
            try {
                this.baos = new ByteArrayOutputStream();
                byte[] out = new byte[128];
                int len = 0;
                while ((len = this.is.read(out)) != -1) {
                    this.baos.write(out, 0, len);
                }
            }
            catch (Exception e) {
                Compiler.traceError("ExternalCompiler.InputReader.run()", "Error in processing input stream : " + Compiler.exceptionTrace(e));
            }
        }

        public String getResult() {
            return this.baos.toString();
        }
    }
}

