/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.compilation;

import com.sap.engine.compilation.ClasspathResolverInterface;
import com.sap.engine.compilation.CompilerException;
import com.sap.engine.compilation.ExCommandLine;
import com.sap.engine.compilation.InfoObject;
import com.sap.engine.compilation.InputJar;
import com.sap.engine.compilation.PureSource;
import com.sap.engine.compilation.file.DirObject;
import com.sap.engine.compilation.file.FileObject;
import com.sap.engine.compilation.file.FileStructure;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipException;

public abstract class Compiler
extends FileStructure {
    protected int outputLimit = 32768;
    private String resultCJ = "result.jar";
    private String _java = ".java";
    private String _class = ".class";
    static int XMX_DEFAULT = 0;
    private int javacXmx = -1;
    private boolean deleteClasses = false;
    protected ClasspathResolverInterface resolver;
    private ArrayList toCompile = new ArrayList();
    protected String[] override;
    private String generate;
    private boolean optimise;
    private boolean nowarn;
    private boolean verbose;
    private boolean deprecation;
    private String classpath;
    private String sourcepath;
    private String bootclasspath;
    private String extdirs;
    private String directory;
    private String encoding;
    private String target;
    Hashtable stored = new Hashtable();
    Vector vec = new Vector();
    public static Location location;
    public static Category category;
    private static boolean onServer;
    private static boolean debug;
    static /* synthetic */ Class class$com$sap$engine$compilation$Compiler;

    public Compiler(String root, String name) throws IOException {
        super(root, name);
    }

    public void setResolver(ClasspathResolverInterface resolver) {
        if (this.resolver != null) {
            return;
        }
        this.resolver = resolver;
    }

    public void addJavaFileToCompile(String java) {
        String help = this.adjustPathString(java, true);
        if (!this.toCompile.contains(help)) {
            this.toCompile.add(help);
        }
    }

    public void addSourceToCompile(PureSource source) throws IOException {
        DirObject dirClass;
        DirObject dirSource;
        String _package = source.get_package();
        if (_package != null && !_package.equals("")) {
            if (_package.indexOf(46) > -1) {
                dirSource = this.sourceDir;
                dirClass = this.classesDir;
                StringTokenizer token = new StringTokenizer(_package, ".");
                while (token.hasMoreTokens()) {
                    String subName = token.nextToken();
                    dirSource = dirSource.createSubDir(subName);
                    dirClass = dirClass.createSubDir(subName);
                }
            } else {
                dirSource = this.sourceDir.createSubDir(_package);
                dirClass = this.classesDir.createSubDir(_package);
            }
        } else {
            dirSource = this.sourceDir;
            dirClass = this.classesDir;
        }
        dirClass.createFile(source.get_classname() + this._class);
        FileObject java = dirSource.copyFile(source.get_classname() + this._java, source.get_source());
        this.addJavaFileToCompile(java.toString());
    }

    public void setArgs(String[] args) {
        this.override = args;
    }

    protected String[] buildArguments() {
        return this.getCommandLineParams().toArray(new String[0]);
    }

    public void setGenerate(String generate) {
        this.generate = generate;
    }

    public void setOptimise(boolean optimise) {
        this.optimise = optimise;
    }

    public void setNowarn(boolean nowarn) {
        this.nowarn = nowarn;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDeprecation(boolean deprecation) {
        this.deprecation = deprecation;
    }

    public void addClasspath(String classpath) {
        if (classpath == null) {
            return;
        }
        if (this.classpath == null) {
            this.classpath = "." + File.pathSeparatorChar + classpath + File.pathSeparatorChar;
        } else if (this.classpath.indexOf(classpath) == -1) {
            this.classpath = this.classpath + classpath + File.pathSeparatorChar;
        }
    }

    public void addClasspath(PureSource source) throws IOException {
        DirObject fileDir = this.sourceDir.createPackage(source.get_package());
        FileObject file = fileDir.createFile(source.get_classname() + this._java);
        file.copy(source.get_source());
        this.addClasspath(this.sourceDir.toString());
    }

    public void addClasspath(InputStream is) throws IOException {
        String tempJarName = "jar_" + this.currentTime() + ".jar";
        this.addClasspath(this.classpathDir.copyFile(tempJarName, is).toString());
    }

    public void addClasspath(InputJar[] jars) throws IOException {
        int ji = 0;
        while (ji < jars.length) {
            this.addClasspath(this.classpathDir.copyFile(jars[ji].getName(), jars[ji].getStream()).toString());
            ++ji;
        }
    }

    public void addSourcepath(String sourcepath) {
        if (this.sourcepath == null) {
            this.sourcepath = sourcepath + File.pathSeparatorChar;
        } else if (this.sourcepath.indexOf(sourcepath) == -1) {
            this.sourcepath = this.sourcepath + sourcepath + File.pathSeparatorChar;
        }
    }

    public void setBootclasspath(String bootclasspath) {
        this.bootclasspath = bootclasspath;
    }

    public void setExtdirs(String extdirs) {
        this.extdirs = extdirs;
    }

    public void setDirectory(String directory) {
        File dir = new File(directory);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.directory = directory;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getCommandLine() {
        if (this.override != null) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.override.length) {
                if (i != 0) {
                    buf.append(' ');
                }
                buf.append(this.override[i]);
                ++i;
            }
            return buf.toString();
        }
        String commandLine = " " + this.toCompile;
        if (this.generate != null) {
            commandLine = " -g " + this.generate + commandLine;
        }
        if (this.optimise) {
            commandLine = " -O" + commandLine;
        }
        if (this.nowarn) {
            commandLine = " -nowarn" + commandLine;
        }
        if (this.verbose) {
            commandLine = " -verbose" + commandLine;
        }
        if (this.deprecation) {
            commandLine = " -deprecation" + commandLine;
        }
        if (this.classpath != null) {
            commandLine = " -classpath " + this.packInQuote(this.classpath) + commandLine;
        }
        if (this.sourcepath != null) {
            commandLine = " -sourcepath " + this.packInQuote(this.sourcepath) + commandLine;
        }
        if (this.bootclasspath != null) {
            commandLine = " -bootclasspath " + this.packInQuote(this.bootclasspath) + commandLine;
        }
        if (this.extdirs != null) {
            commandLine = " -extdirs " + this.packInQuote(this.extdirs) + commandLine;
        }
        if (this.directory != null) {
            this.deleteClasses = false;
        } else {
            this.directory = this.classesDir.toString();
            this.deleteClasses = true;
        }
        commandLine = " -d " + this.packInQuote(this.directory) + commandLine;
        if (this.encoding != null) {
            commandLine = " -encoding " + this.encoding + commandLine;
        }
        if (this.target != null) {
            commandLine = " -target " + this.target + commandLine;
        }
        commandLine = commandLine.replace('\\', '/').replace(';', File.pathSeparatorChar);
        return commandLine;
    }

    public ArrayList getCommandLineParams() {
        ArrayList<String> commandLine = new ArrayList<String>();
        if (this.override != null) {
            int i = 0;
            while (i < this.override.length) {
                commandLine.add(this.override[i]);
                ++i;
            }
            return commandLine;
        }
        commandLine.addAll(this.toCompile);
        if (this.generate != null) {
            commandLine.add(0, this.generate);
            commandLine.add(0, "-g");
        }
        if (this.optimise) {
            commandLine.add(0, "-O");
        }
        if (this.nowarn) {
            commandLine.add(0, "-nowarn");
        }
        if (this.verbose) {
            commandLine.add(0, "-verbose");
        }
        if (this.deprecation) {
            commandLine.add(0, "-deprecation");
        }
        if (this.classpath != null) {
            commandLine.add(0, this.adjustPathString(this.classpath, true));
            commandLine.add(0, "-classpath");
        }
        if (this.sourcepath != null) {
            commandLine.add(0, this.adjustPathString(this.sourcepath, true));
            commandLine.add(0, "-sourcepath");
        }
        if (this.bootclasspath != null) {
            commandLine.add(0, this.adjustPathString(this.bootclasspath, true));
            commandLine.add(0, "-bootclasspath");
        }
        if (this.extdirs != null) {
            commandLine.add(0, this.adjustPathString(this.extdirs, true));
            commandLine.add(0, "-extdirs");
        }
        if (this.directory != null) {
            this.deleteClasses = false;
        } else {
            this.directory = this.classesDir.toString();
            this.deleteClasses = true;
        }
        commandLine.add(0, this.adjustPathString(this.directory, true));
        commandLine.add(0, "-d");
        if (this.encoding != null) {
            commandLine.add(0, this.encoding);
            commandLine.add(0, "-encoding");
        }
        if (this.target != null) {
            commandLine.add(0, this.adjustPathString(this.target, true));
            commandLine.add(0, "-target");
        }
        return commandLine;
    }

    public ExCommandLine getExCommandLineParams() {
        ExCommandLine exCommandLine = new ExCommandLine();
        ArrayList<String> commandLine = new ArrayList<String>();
        if (this.override != null) {
            int i = 0;
            while (i < this.override.length) {
                commandLine.add(this.override[i]);
                ++i;
            }
            exCommandLine.isOptimized = false;
            exCommandLine.commandLine = commandLine;
            exCommandLine.rawCommandLine = commandLine;
            return exCommandLine;
        }
        if (this.target != null) {
            commandLine.add("-target");
            commandLine.add(this.adjustPathString(this.target, true));
        }
        if (this.encoding != null) {
            commandLine.add("-encoding");
            commandLine.add(this.encoding);
        }
        if (this.directory != null) {
            this.deleteClasses = false;
        } else {
            this.directory = this.classesDir.toString();
            this.deleteClasses = true;
        }
        commandLine.add("-d");
        commandLine.add(this.adjustPathString(this.directory, true));
        if (this.extdirs != null) {
            commandLine.add("-extdirs");
            commandLine.add(this.adjustPathString(this.extdirs, true));
        }
        if (this.bootclasspath != null) {
            commandLine.add("-bootclasspath");
            commandLine.add(this.adjustPathString(this.bootclasspath, true));
        }
        if (this.sourcepath != null) {
            commandLine.add("-sourcepath");
            commandLine.add(this.adjustPathString(this.sourcepath, true));
        }
        if (this.classpath != null) {
            commandLine.add("-classpath");
            commandLine.add(this.adjustPathString(this.classpath, true));
        }
        if (this.deprecation) {
            commandLine.add("-deprecation");
        }
        if (this.verbose) {
            commandLine.add("-verbose");
        }
        if (this.nowarn) {
            commandLine.add("-nowarn");
        }
        if (this.optimise) {
            commandLine.add("-O");
        }
        if (this.generate != null) {
            commandLine.add("-g");
            commandLine.add(this.generate);
        }
        String javacXmxStr = null;
        if (this.javacXmx == -1) {
            if (XMX_DEFAULT > 0) {
                javacXmxStr = "-J-Xmx" + XMX_DEFAULT + "m";
            }
        } else {
            javacXmxStr = "-J-Xmx" + this.javacXmx + "m";
        }
        boolean res = false;
        ArrayList<String> commandLine2 = null;
        if (this.isOptimizationNeeded(commandLine, this.toCompile)) {
            commandLine2 = new ArrayList<String>();
            try {
                String optionsFile = '@' + this.createOptionsFile(commandLine, 'O');
                String srcFile = '@' + this.createOptionsFile(this.toCompile, 'S');
                if (javacXmxStr != null) {
                    commandLine2.add(javacXmxStr);
                }
                commandLine2.add(this.adjustPathString(optionsFile, false));
                commandLine2.add(this.adjustPathString(srcFile, false));
                res = true;
            }
            catch (Exception e) {
                String msg = "Can not create options file:" + e.getMessage();
                Compiler.traceInfo("Compiler.compile()", msg);
            }
        }
        if (javacXmxStr != null) {
            commandLine.add(0, javacXmxStr);
        }
        commandLine.addAll(this.toCompile);
        if (res) {
            exCommandLine.isOptimized = true;
            exCommandLine.commandLine = commandLine2;
            exCommandLine.rawCommandLine = commandLine;
            exCommandLine.optionsFileName = ((String)commandLine2.get(0)).substring(1);
            exCommandLine.srcFileName = ((String)commandLine2.get(1)).substring(1);
            return exCommandLine;
        }
        exCommandLine.isOptimized = false;
        exCommandLine.commandLine = commandLine;
        exCommandLine.rawCommandLine = commandLine;
        return exCommandLine;
    }

    public boolean isOptimizationNeeded(ArrayList optionsClasspath, ArrayList srcs) {
        return true;
    }

    public synchronized String createOptionsFile(ArrayList args, char pref) throws IOException {
        long millis = System.currentTimeMillis();
        String fileName = this.workDir.getAbsolutePath() + File.separatorChar + pref + millis + ".txt";
        try {
            PrintWriter pw = new PrintWriter(new FileOutputStream(fileName));
            int i = 0;
            while (i < args.size()) {
                pw.println((String)args.get(i));
                ++i;
            }
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Compiler.traceInfo("Compiler.createSourcesFile()", "Error while creating the sources file : " + Compiler.exceptionTrace(e));
            throw e;
        }
        return fileName;
    }

    private String packInQuote(String str) {
        return "\"" + str + "\"";
    }

    private String adjustPathString(String pathString, boolean quoted) {
        String help = pathString.replace('\\', '/').replace(';', File.pathSeparatorChar);
        if (quoted) {
            return this.packInQuote(help);
        }
        return help;
    }

    public void setDependancyFromService(String name) throws Exception {
        String _classpath = this.resolver.setDependancyFromService(name);
        if (_classpath != null) {
            this.addClasspath(_classpath);
        }
    }

    public void setDependancyFromInterface(String name) throws Exception {
        String _classpath = this.resolver.setDependancyFromInterface(name);
        if (_classpath != null) {
            this.addClasspath(_classpath);
        }
    }

    public void setDependancyFromLibrary(String name) throws Exception {
        String _classpath = this.resolver.setDependancyFromLibrary(name);
        if (_classpath != null) {
            this.addClasspath(_classpath);
        }
    }

    public void setDependancyFromApplication(String name) throws Exception {
        String _classpath = this.resolver.setDependancyFromApplication(name);
        if (_classpath != null) {
            this.addClasspath(_classpath);
        }
    }

    public JarFile loadCompiledClasses() {
        try {
            FileObject jar = this.workDir.createFile(this.resultCJ);
            this.makeJarFromDir(jar.toString(), new String[]{this.directory});
            this.archivate();
            this.classpathDir.deleteDir(false);
            return new JarFile(jar);
        }
        catch (Exception e) {
            Compiler.logError("Can't get compiled classes : " + Compiler.exceptionTrace(e));
            return null;
        }
    }

    public void release() {
        this.stored.clear();
        this.vec.clear();
        this.sourceDir.deleteDir(false);
        this.classesDir.refresh(this.classesDir);
        this.classesDir.deleteDir(false);
        this.classpathDir.deleteDir(false);
        this.workDir.deleteFiles();
        this.toCompile = null;
        this.classpath = null;
        this.sourcepath = null;
    }

    public void close() {
        this.release();
        this.stored.clear();
        this.vec.clear();
        this.deleteFileStructure();
        this.toCompile = null;
        this.classpath = null;
        this.sourcepath = null;
    }

    private long currentTime() {
        return System.currentTimeMillis();
    }

    private void makeJarFromDir(String jarName, String[] dirNames) {
        if (!jarName.endsWith(".jar")) {
            jarName = jarName + ".jar";
        }
        int i = 0;
        while (i < dirNames.length) {
            this.listDir(dirNames[i], this.vec);
            ++i;
        }
        this.stored.put(jarName, this.vec);
    }

    private void listDir(String dirName, Vector allFiles) {
        if (dirName == null || dirName == "") {
            return;
        }
        File directory = new File(dirName);
        if (!directory.isDirectory()) {
            return;
        }
        File[] files = directory.listFiles();
        if (files != null && files.length > 0) {
            InfoObject info = null;
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    this.browseSubDir(files[i].getAbsolutePath(), "", allFiles);
                } else if (files[i].getName().endsWith(".class")) {
                    info = new InfoObject(this.getEntryName(files[i], ""), files[i].getAbsolutePath());
                    allFiles.addElement(info);
                }
                ++i;
            }
        }
    }

    private String getEntryName(File file, String packName) {
        String tempName = file.getName();
        tempName = (packName.trim().equals("") ? "" : packName + "\\") + tempName;
        return tempName;
    }

    private void browseSubDir(String dirName, String packageName, Vector files) {
        InfoObject info = null;
        File f = new File(dirName);
        if (f.isDirectory()) {
            File[] dirFiles = f.listFiles();
            if (dirFiles != null) {
                int i = 0;
                while (i < dirFiles.length) {
                    if (dirFiles[i].isDirectory()) {
                        this.browseSubDir(dirFiles[i].getAbsolutePath(), (packageName.equals("") ? "" : packageName + "\\") + f.getName(), files);
                    } else if (dirFiles[i].getName().endsWith(".class")) {
                        info = new InfoObject(this.getEntryName(dirFiles[i], (packageName.equals("") ? "" : packageName + "\\") + f.getName()), dirFiles[i].getAbsolutePath());
                        files.addElement(info);
                    }
                    ++i;
                }
            }
        } else if (f.getName().endsWith(".class")) {
            info = new InfoObject(packageName.equals("") ? f.getName() : packageName + "\\" + f.getName(), f.getAbsolutePath());
            files.addElement(info);
        }
    }

    private void archivate() throws Exception {
        Enumeration names = this.stored.keys();
        String jarName = "";
        Vector tempVec = null;
        while (names.hasMoreElements()) {
            jarName = (String)names.nextElement();
            tempVec = (Vector)this.stored.get(jarName);
            if (tempVec.size() <= 0) continue;
            this.writeZipFile(jarName, tempVec);
            this.stored.remove(jarName);
            tempVec.clear();
        }
        if (this.deleteClasses) {
            this.classesDir.deleteDir(true);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeZipFile(String jarName, Vector infos) throws IOException {
        fos = null;
        bos = null;
        zip = null;
        try {
            block11: {
                fos = new FileOutputStream(jarName);
                bos = new BufferedOutputStream(fos);
                zip = new JarOutputStream(bos);
                zip.setMethod(8);
                zip.setLevel(9);
                if (infos.size() != 0) break block11;
                var9_6 = null;
                ** GOTO lbl58
            }
            fileObjects = infos.elements();
            infoObj = null;
            while (true) {
                block12: {
                    if (fileObjects.hasMoreElements()) break block12;
                    zip.flush();
                    zip.finish();
                    zip.close();
                    bos.close();
                    fos.close();
                    ** GOTO lbl68
                }
                infoObj = (InfoObject)fileObjects.nextElement();
                if (infoObj == null) continue;
                this.copyJFile((JarOutputStream)zip, infoObj.getEntryName(), infoObj.getFilePath());
            }
        }
        catch (ZipException ze) {
            Compiler.logError("Error while creating zip file : " + Compiler.exceptionTrace(ze));
            var9_8 = null;
            try {
                zip.flush();
                zip.finish();
                zip.close();
                bos.close();
                fos.close();
                return;
            }
            catch (Exception exx) {
                Compiler.logError("Error while creating zip file : " + Compiler.exceptionTrace(exx));
                return;
            }
        }
        {
            catch (Throwable var8_17) {
                var9_9 = null;
                ** try [egrp 2[TRYBLOCK] [2 : 192->219)] { 
lbl49:
                // 1 sources

                zip.flush();
                zip.finish();
                zip.close();
                bos.close();
                fos.close();
                throw var8_17;
lbl55:
                // 1 sources

                catch (Exception exx) {
                    Compiler.logError("Error while creating zip file : " + Compiler.exceptionTrace(exx));
                }
                throw var8_17;
            }
lbl58:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [2 : 192->219)] { 
lbl59:
            // 1 sources

            zip.flush();
            zip.finish();
            zip.close();
            bos.close();
            fos.close();
            return;
lbl65:
            // 1 sources

            catch (Exception exx) {
                Compiler.logError("Error while creating zip file : " + Compiler.exceptionTrace(exx));
            }
            return;
lbl68:
            // 1 sources

            var9_7 = null;
            try {}
            catch (Exception exx) {}
            Compiler.logError("Error while creating zip file : " + Compiler.exceptionTrace(exx));
            return;
            zip.flush();
            zip.finish();
            zip.close();
            bos.close();
            fos.close();
            return;
        }
    }

    private void copyJFile(JarOutputStream zip, String entryName, String filePath) throws IOException {
        JarEntry entry = null;
        int result = 0;
        byte[] fileEntry = null;
        FileInputStream inStream = null;
        BufferedInputStream in = null;
        inStream = new FileInputStream(filePath);
        in = new BufferedInputStream(inStream);
        fileEntry = new byte[in.available()];
        result = in.read(fileEntry, 0, fileEntry.length);
        in.close();
        ((InputStream)inStream).close();
        if (result == -1) {
            return;
        }
        entry = new JarEntry(entryName.replace('\\', '/'));
        entry.setMethod(8);
        if (fileEntry != null) {
            entry.setSize(fileEntry.length);
            CRC32 crc = new CRC32();
            crc.update(fileEntry);
            entry.setCrc(crc.getValue());
            try {
                zip.putNextEntry(entry);
                if (fileEntry.length > 0) {
                    zip.write(fileEntry, 0, fileEntry.length);
                    this.addDirEntries(zip, entryName);
                }
                zip.closeEntry();
            }
            catch (ZipException z) {
                Compiler.logError("Error writing zip entry : " + Compiler.exceptionTrace(z));
                zip.closeEntry();
            }
        }
    }

    private void addDirEntries(JarOutputStream jos, String jarEntryName) throws IOException {
        int ind = jarEntryName.indexOf(47);
        String dir = "";
        JarEntry jentry = null;
        while (ind >= 0) {
            dir = dir + jarEntryName.substring(0, ind + 1);
            jarEntryName = jarEntryName.substring(ind + 1);
            ind = jarEntryName.indexOf(47);
            jentry = new JarEntry(dir);
            jentry.setSize(0L);
            try {
                jos.putNextEntry(jentry);
                jos.closeEntry();
            }
            catch (ZipException z) {
                Compiler.logError("Error writing zip entry : " + Compiler.exceptionTrace(z));
                jos.closeEntry();
            }
        }
    }

    public static String exceptionTrace(Throwable thr) {
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        thr.printStackTrace(new PrintStream(ostr));
        return "\r\n" + ostr.toString();
    }

    public static void logInfo(String message) {
        if (onServer) {
            Category.SYS_SERVER.logT(300, location, message);
        } else {
            System.out.println("compilation info log : " + message);
        }
    }

    public static void logError(String message) {
        if (onServer) {
            Category.SYS_SERVER.logT(500, location, message);
        } else {
            System.out.println("compilation error log : " + message);
        }
    }

    public static void logWarning(String message) {
        if (onServer) {
            Category.SYS_SERVER.logT(400, location, message);
        } else {
            System.out.println("compilation warning log : " + message);
        }
    }

    public static void traceInfo(String where, String message) {
        if (onServer) {
            location.infoT(where, message);
        } else if (debug) {
            System.out.println("compilation info trace : " + message);
        }
    }

    public static void traceDebug(String where, String message) {
        if (onServer) {
            location.debugT(where, message);
        } else if (debug) {
            System.out.println("compilation debug trace : " + message);
        }
    }

    public static void traceError(String where, String message) {
        if (onServer) {
            location.errorT(where, message);
        } else if (debug) {
            System.out.println("compilation error trace : " + message);
        }
    }

    public int getJavacXmx() {
        return this.javacXmx;
    }

    public void setJavacXmx(int value) {
        this.javacXmx = value;
    }

    public static void setDefaultXmx(int value) {
        XMX_DEFAULT = value;
    }

    public abstract void compile() throws CompilerException;

    public abstract void compile(String[] var1) throws CompilerException;

    public abstract void finishedCompilation(boolean var1);

    public abstract String getErrorMessage();

    public abstract String getOutputMessage();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        onServer = false;
        debug = false;
        Package pack = (class$com$sap$engine$compilation$Compiler == null ? (class$com$sap$engine$compilation$Compiler = Compiler.class$("com.sap.engine.compilation.Compiler")) : class$com$sap$engine$compilation$Compiler).getPackage();
        location = pack != null ? Location.getLocation((String)pack.getName()) : Location.getLocation((String)"com.sap.engine.compilation");
        category = Category.SYS_SERVER;
        if (System.getProperties().getProperty("server") != null) {
            onServer = true;
        }
        if (System.getProperties().getProperty("compilation_debug") != null) {
            debug = true;
        }
    }
}

