/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.compilation;

import com.sap.engine.compilation.ClasspathResolverInterface;
import com.sap.engine.compilation.Compiler;
import com.sap.engine.compilation.ExtInternalCompiler;
import com.sap.engine.compilation.ExternalCompiler;
import com.sap.engine.compilation.InternalCompiler;
import com.sap.engine.compilation.ResolverAdapter;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Properties;

public class CompilationFactory {
    public static final String EXTERNAL = "0";
    public static final String INTERNAL = "1";
    public static final String EXTERNAL_INTERNAL = "2";
    public static final String OPTION_OPTIMISE_B = "o";
    public static final String OPTION_NOWARN_B = "now";
    public static final String OPTION_VERBOSE_B = "ver";
    public static final String OPTION_DEPRECATION_B = "dep";
    public static final String OPTION_GENERATE = "g";
    public static final String OPTION_CLASSPATH = "class";
    public static final String OPTION_SOURCEPATH = "source";
    public static final String OPTION_BOOTCLASSPATH = "boot";
    public static final String OPTION_EXTDIRS = "ext";
    public static final String OPTION_DIRECTORY = "dir";
    public static final String OPTION_ENCODING = "enc";
    public static final String OPTION_TARGET = "tar";
    public static final String ARGUMENTS = "args";
    public static final String RESOLVER = "resolver";
    public static final String COMPILATION_METHOD = "compilation";
    public static final String COMPILER_NAME = "name";
    private static String un = "_";
    private static String ti = "~";
    private static String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public static Compiler getCompiler(String name) throws IOException {
        ResolverAdapter resolver = new ResolverAdapter();
        ExternalCompiler compiler = new ExternalCompiler(resolver.getWorkingDir(), name);
        compiler.setResolver(resolver);
        return compiler;
    }

    public static Compiler getCompiler(Properties props) throws IOException {
        String method;
        Compiler.traceInfo("CompilationFactory.getCompiler(Properties) : ", "Properties : " + props);
        if (props == null) {
            ResolverAdapter resolver = new ResolverAdapter();
            String compilerName = CompilationFactory.composeCompilerName(resolver.getWorkingDir());
            ExternalCompiler compiler = new ExternalCompiler(resolver.getWorkingDir(), compilerName);
            compiler.setResolver(resolver);
            return compiler;
        }
        ClasspathResolverInterface resolver = ((Hashtable)props).containsKey(RESOLVER) ? (ClasspathResolverInterface)((Hashtable)props).get(RESOLVER) : new ResolverAdapter();
        Compiler.traceInfo("CompilationFactory.getCompiler(Properties) : ", "Resolver : " + resolver);
        String compilerName = ((Hashtable)props).containsKey(COMPILER_NAME) ? (String)((Hashtable)props).get(COMPILER_NAME) : CompilationFactory.composeCompilerName(resolver.getWorkingDir());
        Compiler.traceInfo("CompilationFactory.getCompiler(Properties) : ", "CompilerName : " + compilerName);
        Compiler compiler = ((Hashtable)props).containsKey(COMPILATION_METHOD) ? ((method = (String)((Hashtable)props).get(COMPILATION_METHOD)).equals(INTERNAL) ? new InternalCompiler(resolver.getWorkingDir(), compilerName) : (method.equals(EXTERNAL_INTERNAL) ? new ExtInternalCompiler(resolver.getWorkingDir(), compilerName) : new ExternalCompiler(resolver.getWorkingDir(), compilerName))) : new ExternalCompiler(resolver.getWorkingDir(), compilerName);
        compiler.setResolver(resolver);
        if (((Hashtable)props).containsKey(ARGUMENTS)) {
            compiler.setArgs((String[])((Hashtable)props).get(ARGUMENTS));
        }
        if (((Hashtable)props).containsKey(OPTION_GENERATE)) {
            compiler.setGenerate((String)((Hashtable)props).get(OPTION_GENERATE));
        }
        if (((Hashtable)props).containsKey(OPTION_OPTIMISE_B)) {
            compiler.setOptimise((Boolean)((Hashtable)props).get(OPTION_OPTIMISE_B));
        }
        if (((Hashtable)props).containsKey(OPTION_NOWARN_B)) {
            compiler.setNowarn((Boolean)((Hashtable)props).get(OPTION_NOWARN_B));
        }
        if (((Hashtable)props).containsKey(OPTION_VERBOSE_B)) {
            compiler.setVerbose((Boolean)((Hashtable)props).get(OPTION_VERBOSE_B));
        }
        if (((Hashtable)props).containsKey(OPTION_DEPRECATION_B)) {
            compiler.setDeprecation((Boolean)((Hashtable)props).get(OPTION_DEPRECATION_B));
        }
        if (((Hashtable)props).containsKey(OPTION_CLASSPATH)) {
            compiler.addClasspath((String)((Hashtable)props).get(OPTION_CLASSPATH));
        }
        if (((Hashtable)props).containsKey(OPTION_SOURCEPATH)) {
            compiler.addSourcepath((String)((Hashtable)props).get(OPTION_SOURCEPATH));
        }
        if (((Hashtable)props).containsKey(OPTION_BOOTCLASSPATH)) {
            compiler.setBootclasspath((String)((Hashtable)props).get(OPTION_BOOTCLASSPATH));
        }
        if (((Hashtable)props).containsKey(OPTION_EXTDIRS)) {
            compiler.setExtdirs((String)((Hashtable)props).get(OPTION_EXTDIRS));
        }
        if (((Hashtable)props).containsKey(OPTION_DIRECTORY)) {
            compiler.setDirectory((String)((Hashtable)props).get(OPTION_DIRECTORY));
        }
        if (((Hashtable)props).containsKey(OPTION_ENCODING)) {
            compiler.setEncoding((String)((Hashtable)props).get(OPTION_ENCODING));
        }
        if (((Hashtable)props).containsKey(OPTION_TARGET)) {
            compiler.setTarget((String)((Hashtable)props).get(OPTION_TARGET));
        }
        return compiler;
    }

    private static String composeCompilerName(String rootDir) {
        String name;
        Calendar c = Calendar.getInstance();
        String month = months[c.get(2)];
        int day = c.get(5);
        int hour = c.get(11);
        int min = c.get(12);
        String searchName = name = "compiler" + un + month + un + day + un + "at" + un + hour + "." + min;
        int compilerId = 0;
        while (new File(rootDir + "/" + searchName).exists()) {
            searchName = name + ti + ++compilerId;
        }
        name = searchName;
        return name;
    }
}

