/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.generationfwk.text;

import com.sap.ide.generationfwk.text.FiniteAutomaton;
import com.sap.tc.logging.Location;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class UCAMergeWriter
extends Writer {
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$sap$ide$generationfwk$text$UCAMergeWriter == null ? (class$com$sap$ide$generationfwk$text$UCAMergeWriter = UCAMergeWriter.class$("com.sap.ide.generationfwk.text.UCAMergeWriter")) : class$com$sap$ide$generationfwk$text$UCAMergeWriter).getName());
    private static String lineSeparator = System.getProperty("line.separator");
    private static final String UCA_BEGIN_MARKER = "//@@begin";
    private static final String UCA_END_MARKER = "//@@end";
    private static final String OBSOLETE_UCA_KEY_PREFIX = "obsolete:";
    private static final String OBSOLETE_UCA_LINE_PREFIX = "//";
    private Writer out;
    private Map ucas;
    private String ucaKey = null;
    private String ucaOption = null;
    private boolean ignoreWrites = false;
    private UCARecognizer sm = new UCARecognizer();
    static /* synthetic */ Class class$com$sap$ide$generationfwk$text$UCAMergeWriter;

    public UCAMergeWriter(Map ucas, Writer writer) throws Exception {
        this.ucas = ucas;
        this.out = writer;
    }

    public static Map readUCAs(String codeString) throws Exception {
        HashMap<String, String> ucas = new HashMap<String, String>();
        if (codeString != null && codeString.length() > 0) {
            BufferedReader in = new BufferedReader(new StringReader(codeString));
            boolean inUCA = false;
            String line = null;
            String ucaKey = null;
            String ucaOptions = null;
            boolean ucaIsObsolete = false;
            StringBuffer ucaContent = null;
            while ((line = in.readLine()) != null) {
                if (!inUCA) {
                    if (!line.trim().startsWith(UCA_BEGIN_MARKER)) continue;
                    ucaKey = line.trim().substring(UCA_BEGIN_MARKER.length()).trim();
                    ucaOptions = "";
                    ucaIsObsolete = false;
                    if (ucaKey.lastIndexOf(32) >= 0) {
                        ucaOptions = ucaKey.substring(ucaKey.lastIndexOf(32)).trim();
                        ucaKey = ucaKey.substring(0, ucaKey.lastIndexOf(32));
                    }
                    if (ucaKey.startsWith(OBSOLETE_UCA_KEY_PREFIX)) {
                        ucaKey = ucaKey.substring(OBSOLETE_UCA_KEY_PREFIX.length());
                        ucaIsObsolete = true;
                    }
                    ucaContent = new StringBuffer();
                    inUCA = true;
                    continue;
                }
                if (line.trim().startsWith(UCA_END_MARKER)) {
                    inUCA = false;
                    if (ucaOptions.equalsIgnoreCase("IGNORE")) continue;
                    ucas.put(ucaKey, ucaContent.toString());
                    continue;
                }
                if (ucaIsObsolete && line.startsWith(OBSOLETE_UCA_LINE_PREFIX)) {
                    ucaContent.append(line.substring(OBSOLETE_UCA_LINE_PREFIX.length())).append(lineSeparator);
                    continue;
                }
                ucaContent.append(line).append(lineSeparator);
            }
            if (inUCA) {
                throw new RuntimeException("Unclosed User Code Area //@@begin " + ucaKey + ", " + UCA_END_MARKER + " is missing.");
            }
        }
        return ucas;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.sm.consume(cbuf, off, len);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        Iterator it = this.ucas.keySet().iterator();
        if (it.hasNext()) {
            this.out.write(lineSeparator + "// ---- content of obsolete user coding area(s) ----" + lineSeparator);
            while (it.hasNext()) {
                String ucaKey = (String)it.next();
                this.out.write("//@@begin obsolete:" + ucaKey + lineSeparator);
                StringTokenizer tokenizer = new StringTokenizer((String)this.ucas.get(ucaKey), lineSeparator);
                while (tokenizer.hasMoreTokens()) {
                    this.out.write(OBSOLETE_UCA_LINE_PREFIX + tokenizer.nextToken() + lineSeparator);
                }
                this.out.write(UCA_END_MARKER + lineSeparator);
            }
        }
        this.out.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class UCARecognizer
    extends FiniteAutomaton {
        private static final int S0 = 0;
        private static final int S1 = 1;
        private static final int S2 = 2;
        private static final int S3 = 3;
        private static final int S4 = 4;
        private static final int S5 = 5;
        private static final int S6 = 6;
        private static final int S7 = 7;
        private static final int S8 = 8;
        private static final int WRITE = 0;
        private static final int BUFFER0 = 1;
        private static final int BUFFER = 2;
        private static final int FLUSH = 3;
        private static final int CHECK_FOR_UCA = 4;
        private StringBuffer buf = new StringBuffer();

        UCARecognizer() {
            this.defineTransitions(0, " \t/\"", new int[]{1, 1, 1, 0, 0}, new int[]{1, 1, 2, 5, 0});
            this.defineTransitions(1, " \t/\"", new int[]{2, 2, 2, 3, 3}, new int[]{1, 1, 2, 5, 0});
            this.defineTransitions(2, "/*", new int[]{2, 3, 3}, new int[]{3, 7, 0});
            this.defineTransitions(3, "\r", new int[]{2, 2}, new int[]{4, 3});
            this.defineTransitions(4, "\n", new int[]{4, 2}, new int[]{0, 3});
            this.defineTransitions(5, "\\\"", new int[]{0, 0, 0}, new int[]{6, 0, 5});
            this.defineTransitions(6, "", new int[]{0}, new int[]{5});
            this.defineTransitions(7, "*", new int[]{0, 0}, new int[]{8, 7});
            this.defineTransitions(8, "/*", new int[]{0, 0, 0}, new int[]{0, 8, 7});
            this.reset();
        }

        protected void doAction(int action, char c) throws IOException {
            switch (action) {
                case 0: {
                    if (UCAMergeWriter.this.ignoreWrites) break;
                    UCAMergeWriter.this.out.write(c);
                    break;
                }
                case 1: {
                    this.buf.delete(0, this.buf.length());
                }
                case 2: {
                    this.buf.append(c);
                    break;
                }
                case 3: {
                    if (UCAMergeWriter.this.ignoreWrites) break;
                    UCAMergeWriter.this.out.write(this.buf.toString());
                    this.buf.delete(0, this.buf.length());
                    UCAMergeWriter.this.out.write(c);
                    break;
                }
                case 4: {
                    this.buf.append(c);
                    String token = this.buf.substring(0, this.buf.length() - 2).trim();
                    if (UCAMergeWriter.this.ucaKey == null && token.startsWith(UCAMergeWriter.UCA_BEGIN_MARKER)) {
                        if ((token = token.substring(UCAMergeWriter.UCA_BEGIN_MARKER.length()).trim()).indexOf(32) >= 0) {
                            UCAMergeWriter.this.ucaKey = token.substring(0, token.indexOf(32));
                            UCAMergeWriter.this.ucaOption = token.substring(token.indexOf(32) + 1).trim();
                        } else {
                            UCAMergeWriter.this.ucaKey = token;
                            UCAMergeWriter.this.ucaOption = null;
                        }
                        UCAMergeWriter.this.out.write(this.buf.toString());
                        UCAMergeWriter.this.ignoreWrites = UCAMergeWriter.this.ucas.containsKey(UCAMergeWriter.this.ucaKey);
                        break;
                    }
                    if (UCAMergeWriter.this.ucaKey != null && token.startsWith(UCAMergeWriter.UCA_END_MARKER)) {
                        if (UCAMergeWriter.this.ucas.containsKey(UCAMergeWriter.this.ucaKey)) {
                            UCAMergeWriter.this.out.write((String)UCAMergeWriter.this.ucas.get(UCAMergeWriter.this.ucaKey));
                            UCAMergeWriter.this.ucas.remove(UCAMergeWriter.this.ucaKey);
                        }
                        UCAMergeWriter.this.out.write(this.buf.toString());
                        UCAMergeWriter.this.ignoreWrites = false;
                        UCAMergeWriter.this.ucaKey = null;
                        UCAMergeWriter.this.ucaOption = null;
                        break;
                    }
                    if (UCAMergeWriter.this.ignoreWrites) break;
                    UCAMergeWriter.this.out.write(this.buf.toString());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }
}

