/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.generationfwk.task;

import com.sap.ide.generationfwk.configuration.IGenerationUnit;
import com.sap.ide.generationfwk.configuration.template.ITemplate;
import com.sap.ide.generationfwk.task.GenerationTaskBase;
import com.sap.ide.generationfwk.util.dir.DirectoryCreationService;
import com.sap.tc.logging.Location;
import com.tssap.util.xml.DOMAccess;
import com.tssap.util.xml.DOMTransformerI;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.transform.Source;

public class GenerationTaskXSLT
extends GenerationTaskBase {
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$sap$ide$generationfwk$task$GenerationTaskXSLT == null ? (class$com$sap$ide$generationfwk$task$GenerationTaskXSLT = GenerationTaskXSLT.class$("com.sap.ide.generationfwk.task.GenerationTaskXSLT")) : class$com$sap$ide$generationfwk$task$GenerationTaskXSLT).getName());
    public static final String CONTEXT_ID_XML_DATA_SOURCE = "xmlDataSource";
    private ITemplate mTemplate = null;
    static /* synthetic */ Class class$com$sap$ide$generationfwk$task$GenerationTaskXSLT;

    public GenerationTaskXSLT(int environment) {
        super(environment);
    }

    public String getType() {
        return "xsltTemplate";
    }

    public final String executeTransient(IGenerationUnit generationUnit, HashMap context) throws Exception {
        this.executeTransient(generationUnit, context, null);
        return null;
    }

    public final String executeTransient(IGenerationUnit generationUnit, HashMap context, String codeBody) throws Exception {
        this.setContext(context);
        this.setTemplate((ITemplate)generationUnit);
        this.setOutputPath("");
        this.setCodeBody(codeBody);
        try {
            DOMTransformerI lTransformer = DOMAccess.getDOMTransformer((String)this.getTemplate().getFilePath());
            Iterator lKeyIterator = this.getContext().keySet().iterator();
            String lKey = "";
            while (lKeyIterator.hasNext()) {
                lKey = (String)lKeyIterator.next();
                lTransformer.setParameter(lKey, this.getContext().get(lKey));
            }
            Object lXmlDataSource = this.getContext().get(CONTEXT_ID_XML_DATA_SOURCE);
            if (lXmlDataSource == null) {
                throw new Exception("Required attribute xmlDataSource is not set");
            }
            if (!this.isTestMode()) {
                String lOutputString = "";
                if (lXmlDataSource instanceof String) {
                    lTransformer.transform((String)lXmlDataSource, lOutputString);
                } else if (lXmlDataSource instanceof InputStream) {
                    lTransformer.transform((InputStream)lXmlDataSource, lOutputString);
                } else if (lXmlDataSource instanceof Source) {
                    lTransformer.transform((Source)lXmlDataSource, lOutputString);
                } else if (lXmlDataSource instanceof Reader) {
                    lTransformer.transform((Reader)lXmlDataSource, lOutputString);
                } else {
                    throw new Exception("XML data source is of type " + lXmlDataSource.getClass().getName() + " and not of required type java.io.InputStream, java.io.Reader, avax.xml.transform.Source or java.lang.String");
                }
                return lOutputString;
            }
            if (this.getEnvironment() == 1 || this.getEnvironment() == 3) {
                System.out.println("!!! Test mode, no generation !!!");
                return "";
            }
        }
        catch (Throwable th) {
            if (th instanceof Exception) {
                throw (Exception)th;
            }
            throw (Error)th;
        }
        return null;
    }

    public final void executePersistent(IGenerationUnit generationUnit, HashMap context, String outputPath) throws Exception {
        this.executePersistent(generationUnit, context, outputPath, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void executePersistent(IGenerationUnit generationUnit, HashMap context, String outputPath, String codeBody) throws Exception {
        this.setContext(context);
        this.setTemplate((ITemplate)generationUnit);
        this.setOutputPath(outputPath);
        this.setCodeBody(codeBody);
        GenerationTaskBase.checkFilePathLength(outputPath);
        try {
            DOMTransformerI lTransformer = DOMAccess.getDOMTransformer((String)this.getTemplate().getFilePath());
            Iterator lKeyIterator = this.getContext().keySet().iterator();
            String lKey = "";
            while (lKeyIterator.hasNext()) {
                lKey = (String)lKeyIterator.next();
                lTransformer.setParameter(lKey, this.getContext().get(lKey));
            }
            Object lXmlDataSource = this.getContext().get(CONTEXT_ID_XML_DATA_SOURCE);
            if (lXmlDataSource == null) {
                throw new Exception("Required attribute xmlDataSource is not set");
            }
            if (!this.isTestMode()) {
                int lIndex = this.getOutputPath().lastIndexOf(47);
                if (lIndex != -1) {
                    DirectoryCreationService.createDirectory(this.getOutputPath().substring(0, lIndex));
                }
                if (lXmlDataSource instanceof String) {
                    lTransformer.transform((String)lXmlDataSource, outputPath);
                    return;
                } else if (lXmlDataSource instanceof InputStream) {
                    lTransformer.transform((InputStream)lXmlDataSource, outputPath);
                    return;
                } else if (lXmlDataSource instanceof Source) {
                    lTransformer.transform((Source)lXmlDataSource, outputPath);
                    return;
                } else {
                    if (!(lXmlDataSource instanceof Reader)) throw new Exception("XML data source is of type " + lXmlDataSource.getClass().getName() + " and not of required type java.io.InputStream, java.io.Reader, avax.xml.transform.Source or java.lang.String");
                    lTransformer.transform((Reader)lXmlDataSource, outputPath);
                }
                return;
            } else {
                if (this.getEnvironment() != 1 && this.getEnvironment() != 3) return;
                System.out.println("!!! Test mode, no generation !!!");
            }
            return;
        }
        catch (Throwable th) {
            if (!(th instanceof Exception)) throw (Error)th;
            throw (Exception)th;
        }
    }

    public final ITemplate getTemplate() {
        return this.mTemplate;
    }

    private void setTemplate(ITemplate template) {
        this.mTemplate = template;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

