/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.generationfwk.configuration;

import com.sap.ide.generationfwk.configuration.GenerationConfigurationBase;
import com.sap.ide.generationfwk.configuration.IGenerationUnit;
import com.sap.ide.generationfwk.configuration.method.Method;
import com.sap.ide.generationfwk.configuration.template.Template;
import com.sap.ide.generationfwk.logging.ILogging;
import com.sap.tc.logging.Location;
import java.net.URL;

public class GenerationConfiguration
extends GenerationConfigurationBase {
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$sap$ide$generationfwk$configuration$GenerationConfiguration == null ? (class$com$sap$ide$generationfwk$configuration$GenerationConfiguration = GenerationConfiguration.class$("com.sap.ide.generationfwk.configuration.GenerationConfiguration")) : class$com$sap$ide$generationfwk$configuration$GenerationConfiguration).getName());
    static /* synthetic */ Class class$com$sap$ide$generationfwk$configuration$GenerationConfiguration;

    public GenerationConfiguration(String templateConfigurationFile, ILogging logging) {
        super(templateConfigurationFile, logging);
    }

    public GenerationConfiguration(ILogging logging) {
        super(logging);
    }

    public final void refresh() {
        String lConfigurationFilePath = this.findConfigurationFile(this.getConfigurationFile());
        this.getLogging().printMessage(1, "Initialize generation templates from configuration " + lConfigurationFilePath);
        try {
            this.getConfiguration(this.parseConfigurationFile(lConfigurationFilePath));
        }
        catch (Throwable th) {
            this.getLogging().printMessage(2, "Configuration file " + lConfigurationFilePath + " could not be parsed");
            th.printStackTrace();
        }
    }

    protected final String findConfigurationFile(String configurationFile) {
        String lFileName = "";
        URL lUrl = this.getClass().getClassLoader().getResource(configurationFile);
        if (lUrl != null) {
            lFileName = lUrl.getFile();
        }
        if (lUrl != null && lFileName != null) {
            if (lFileName.lastIndexOf(".jar") != -1 && !lFileName.startsWith("jar:")) {
                lFileName = "jar:" + lFileName;
            }
        } else if (this.isConfigurationFileExternal()) {
            lFileName = configurationFile;
        }
        return lFileName;
    }

    public final IGenerationUnit createGenerationUnitForMethod(String id, String methodName, String methodClassName, boolean isStatic, String outputEncoding) {
        return new Method(id, methodName, methodClassName, isStatic, outputEncoding);
    }

    public final IGenerationUnit createGenerationUnitForTemplate(String id, String path, String sourceType, String helperClassName, String templateEncoding, String outputEncoding) {
        return new Template(id, path, sourceType, helperClassName, templateEncoding, outputEncoding);
    }

    protected final String getTemplatePath(String templateName) {
        URL lUrl = this.getClass().getClassLoader().getResource(templateName);
        if (lUrl != null) {
            return lUrl.getFile();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

