/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.generationfwk;

import com.sap.ide.generationfwk.configuration.GenerationConfiguration;
import com.sap.ide.generationfwk.configuration.GenerationConfigurationBase;
import com.sap.ide.generationfwk.configuration.IGenerationUnit;
import com.sap.ide.generationfwk.environment.IEnvironment;
import com.sap.ide.generationfwk.jarm.JarmInstrumentation;
import com.sap.ide.generationfwk.logging.ILogging;
import com.sap.ide.generationfwk.task.GenerationTaskJavaMethod;
import com.sap.ide.generationfwk.task.GenerationTaskVelocity;
import com.sap.ide.generationfwk.task.GenerationTaskXSLT;
import com.sap.ide.generationfwk.task.IGenerationTask;
import com.sap.ide.generationfwk.trace.ITraceCategories;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.PropertiesConfigurator;
import com.sap.tc.logging.TraceFormatter;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;

public abstract class GenerationBase
implements ILogging,
IEnvironment {
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$sap$ide$generationfwk$GenerationBase == null ? (class$com$sap$ide$generationfwk$GenerationBase = GenerationBase.class$("com.sap.ide.generationfwk.GenerationBase")) : class$com$sap$ide$generationfwk$GenerationBase).getName());
    private GenerationConfigurationBase mGenerationConfiguration = null;
    private boolean mLogging = true;
    private boolean mTestMode = false;
    private boolean mIncremental = false;
    private int mEnvironment = 1;
    private String mExtensionId = "";
    private IGenerationTask mGenerationTaskVelocity = null;
    private IGenerationTask mGenerationTaskJavaMethod = null;
    private IGenerationTask mGenerationTaskXSLT = null;
    private int mJarmLevel = Integer.parseInt(JarmInstrumentation.getDefaultJarmLevel());
    static /* synthetic */ Class class$com$sap$ide$generationfwk$GenerationBase;

    public GenerationBase(int environment) {
        this.setEnvironment(environment);
        this.setConfiguration(new GenerationConfiguration(this));
    }

    public GenerationBase(int environment, String configurationFile) {
        this.setEnvironment(environment);
        this.setConfiguration(new GenerationConfiguration(configurationFile, this));
    }

    protected final void setConfiguration(GenerationConfigurationBase generationConfiguration) {
        this.mGenerationConfiguration = generationConfiguration;
    }

    public final GenerationConfigurationBase getGenerationConfiguration() {
        return this.mGenerationConfiguration;
    }

    public final void refreshConfiguration() {
        if (this.getGenerationConfiguration() != null) {
            this.getGenerationConfiguration().refresh();
        }
    }

    public abstract void printMessage(int var1, String var2);

    public final void printMessages(int category, String[] messageTexts) {
        if (messageTexts == null) {
            return;
        }
        int i = 0;
        while (i < messageTexts.length) {
            this.printMessage(category, messageTexts[i]);
            ++i;
        }
    }

    public final void setLogging(boolean logging) {
        this.mLogging = logging;
    }

    public final boolean isLogging() {
        return this.mLogging;
    }

    protected final String doTransientGeneration(String id, HashMap generationContext, String displayName) {
        return this.doTransientGeneration(id, generationContext, displayName, null);
    }

    protected String doTransientGeneration(String id, HashMap generationContext, String displayName, String codeBody) {
        IGenerationTask lGenerationTask;
        IGenerationUnit lGenerationUnit = this.getGenerationConfiguration().getGenerationUnit(id);
        if (lGenerationUnit == null) {
            this.printMessage(2, "GenerationUnit " + id + " is not available");
            return null;
        }
        generationContext.put("encoding", lGenerationUnit.getOutputEncoding());
        if (codeBody != null) {
            generationContext.put("codeBody", codeBody);
        }
        if (displayName != null && displayName.length() > 0) {
            this.printMessage(1, "Generating " + displayName);
        }
        if ((lGenerationTask = this.getGenerationTask(lGenerationUnit.getType())) == null) {
            this.printMessage(2, "GenerationTask for GenerationUnitType" + lGenerationUnit.getType() + " is not available");
            return null;
        }
        try {
            lGenerationTask.setExtensionId(this.getExtensionId());
            lGenerationTask.setTestMode(this.isTestMode());
            return lGenerationTask.executeTransient(lGenerationUnit, generationContext, codeBody);
        }
        catch (Exception ex) {
            if (this.getEnvironment() == 1 || this.getEnvironment() == 3) {
                ex.printStackTrace();
            } else if (this.getEnvironment() == 2) {
                TRACE_LOCATION.errorT("Generation error while processing Generation Unit" + lGenerationUnit.getId() + " (" + ex.getClass().getName() + ": " + ex.getMessage() + ")", new Object[]{ex});
            }
            this.printMessage(2, ex.getMessage() + " (" + ex.toString() + ")");
            return null;
        }
    }

    protected final boolean doPersistentGeneration(String id, HashMap generationContext, String outputFile, String displayName) {
        return this.doPersistentGeneration(id, generationContext, outputFile, displayName, null);
    }

    protected final boolean doPersistentGeneration(String id, HashMap generationContext, String outputFile, String displayName, String codeBody) {
        long lStartingTime;
        IGenerationTask lGenerationTask;
        if (GenerationBase.isOutputFileReadOnly(outputFile)) {
            this.printMessage(2, "Existing output file " + outputFile + " is read-only!");
            return false;
        }
        IGenerationUnit lGenerationUnit = this.getGenerationConfiguration().getGenerationUnit(id);
        if (lGenerationUnit == null) {
            this.printMessage(2, "GenerationUnit " + id + " is not available");
            return false;
        }
        generationContext.put("encoding", lGenerationUnit.getOutputEncoding());
        if (codeBody != null) {
            generationContext.put("codeBody", codeBody);
        }
        if (displayName != null && displayName.length() > 0) {
            this.printMessage(1, "Generating " + displayName);
        }
        if ((lGenerationTask = this.getGenerationTask(lGenerationUnit.getType())) == null) {
            this.printMessage(2, "GenerationTask for GenerationUnitType" + lGenerationUnit.getType() + " is not available");
            return false;
        }
        long lEndingTime = lStartingTime = System.currentTimeMillis();
        try {
            lGenerationTask.setExtensionId(this.getExtensionId());
            lGenerationTask.setTestMode(this.isTestMode());
            lGenerationTask.executePersistent(lGenerationUnit, generationContext, outputFile, codeBody);
        }
        catch (Exception ex) {
            if (this.getEnvironment() == 1 || this.getEnvironment() == 3) {
                ex.printStackTrace();
            } else if (this.getEnvironment() == 2) {
                TRACE_LOCATION.errorT("Generation error while processing " + outputFile + " (" + ex.toString() + ")", new Object[]{ex});
            }
            this.printMessage(2, ex.toString() + ", " + outputFile);
            return false;
        }
        lEndingTime = System.currentTimeMillis();
        if (this.getEnvironment() == 2) {
            TRACE_LOCATION.infoT("Creating file " + outputFile + ": " + (lEndingTime - lStartingTime) + " ms)");
        }
        return true;
    }

    protected final boolean isGeneration(String outputFilePath) {
        File lOutputFile = new File(outputFilePath);
        if (!lOutputFile.exists()) {
            return true;
        }
        return !this.isIncremental();
    }

    protected static final boolean isOutputFileReadOnly(String absoluteFilePath) {
        File lFile = new File(absoluteFilePath);
        if (!lFile.exists()) {
            return false;
        }
        return !lFile.canWrite();
    }

    public final void setTestMode(boolean test) {
        this.mTestMode = test;
    }

    public final boolean isTestMode() {
        return this.mTestMode;
    }

    public final void setIncremental(boolean incremental) {
        this.mIncremental = incremental;
    }

    public final boolean isIncremental() {
        return this.mIncremental;
    }

    private void setEnvironment(int environment) {
        this.mEnvironment = environment;
    }

    public final int getEnvironment() {
        return this.mEnvironment;
    }

    public final String getExtensionId() {
        return this.mExtensionId;
    }

    public final void setExtensionId(String extensionId) {
        this.mExtensionId = extensionId;
    }

    public int getJarmLevel() {
        return this.mJarmLevel;
    }

    public final void setJarmLevel(int jarmLevel) {
        this.mJarmLevel = jarmLevel;
    }

    private IGenerationTask getGenerationTask(String generationUnitType) {
        if (generationUnitType.equals("velocityTemplate")) {
            if (this.getTaskVelocity() == null) {
                this.setTaskVelocity(new GenerationTaskVelocity(this.getEnvironment()));
            }
            return this.getTaskVelocity();
        }
        if (generationUnitType.equals("javaMethod")) {
            if (this.getTaskJavaMethod() == null) {
                this.setTaskJavaMethod(new GenerationTaskJavaMethod(this.getEnvironment()));
            }
            return this.getTaskJavaMethod();
        }
        if (generationUnitType.equals("xsltTemplate")) {
            if (this.getTaskXslt() == null) {
                this.setTaskXslt(new GenerationTaskXSLT(this.getEnvironment()));
            }
            return this.getTaskXslt();
        }
        return null;
    }

    private void setTaskVelocity(GenerationTaskVelocity taskVelocity) {
        this.mGenerationTaskVelocity = taskVelocity;
    }

    private GenerationTaskVelocity getTaskVelocity() {
        return (GenerationTaskVelocity)this.mGenerationTaskVelocity;
    }

    private void setTaskJavaMethod(GenerationTaskJavaMethod taskJavaMethod) {
        this.mGenerationTaskJavaMethod = taskJavaMethod;
    }

    private GenerationTaskJavaMethod getTaskJavaMethod() {
        return (GenerationTaskJavaMethod)this.mGenerationTaskJavaMethod;
    }

    private void setTaskXslt(GenerationTaskXSLT taskXslt) {
        this.mGenerationTaskXSLT = taskXslt;
    }

    private GenerationTaskXSLT getTaskXslt() {
        return (GenerationTaskXSLT)this.mGenerationTaskXSLT;
    }

    protected void deleteOutputFolderContent(String outputFolder) {
        this.printMessage(1, "Scrubbing generation output folder");
        if (outputFolder == null || outputFolder.length() == 0) {
            return;
        }
        File lOutputFolderFile = new File(outputFolder);
        if (!lOutputFolderFile.isDirectory()) {
            return;
        }
        if (!lOutputFolderFile.exists()) {
            return;
        }
        File[] lChildFiles = lOutputFolderFile.listFiles();
        int i = 0;
        while (lChildFiles == null || i < lChildFiles.length) {
            this.deleteFilesAndFoldersRecursivly(lChildFiles[i]);
            ++i;
        }
    }

    private void deleteFilesAndFoldersRecursivly(File file) {
        File[] lChildFiles = file.listFiles();
        if (lChildFiles != null && lChildFiles.length > 0) {
            int i = 0;
            while (i < lChildFiles.length) {
                this.deleteFilesAndFoldersRecursivly(lChildFiles[i]);
                ++i;
            }
        }
        if (!GenerationBase.isOutputFileReadOnly(file.getAbsolutePath())) {
            file.delete();
        }
    }

    private static void configureTrace() {
        InputStream lInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("generation_framework_trace.properties");
        if (lInputStream != null) {
            Properties lProperties = new Properties();
            try {
                lProperties.load(lInputStream);
            }
            catch (Exception ex) {
                TRACE_LOCATION.catching((Throwable)ex);
                ex.printStackTrace();
            }
            PropertiesConfigurator lConfigurator = new PropertiesConfigurator(lProperties);
            lConfigurator.configure();
            ITraceCategories.TRACE_CATEGORY_GENERATION_FWK_CORE_INITIALIZATION.infoT(TRACE_LOCATION, "trace: using configuration file 'generation_framework_trace.properties' from classpath");
            return;
        }
        Category lCategory = ITraceCategories.TRACE_CATEGORY_GENERATION_FWK;
        lCategory.setEffectiveSeverity(400);
        FileLog lFileLog = new FileLog("%t/generation_framework_core.log");
        lFileLog.setFormatter((Formatter)new TraceFormatter("%24d[%5s] %-30l [%t]: %m"));
        lCategory.addLog((Log)lFileLog);
        ITraceCategories.TRACE_CATEGORY_GENERATION_FWK_CORE_INITIALIZATION.infoT(TRACE_LOCATION, "trace: using internal configuration file");
    }

    protected void cleanup() {
        this.setConfiguration(null);
        this.setTaskVelocity(null);
        this.setTaskJavaMethod(null);
        this.setTaskXslt(null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

