/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.dictionary.repository;

import com.sap.ide.eclipse.component.dcmetadata.model.IPPModel;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.ide.eclipse.dii.component.IPPEntityService;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.plugin.DictionaryRootManager;
import com.sap.ide.metamodel.dictionary.plugin.MetamodelDictionaryEclipse;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.Entity;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PPEntityServiceHelper {
    private static final String NATURE_ID_WEBDYNPRO = "com.sap.ide.webdynpro.archivebuilder.WebDynproNature";
    static /* synthetic */ Class class$com$sap$ide$metamodel$dictionary$repository$PPEntityServiceHelper;

    public static void addEntityListener(IDCExtendedProject project, Metamodel metamodel) {
        String projectName = metamodel.getName();
        IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        try {
            if (eclipseProject.hasNature(NATURE_ID_WEBDYNPRO)) {
                PPEntityServiceHelper.addEntityListenerForWebDynproProject(project, metamodel);
            } else {
                PPEntityServiceHelper.addEntityListenerForDDicProject(project, metamodel);
            }
        }
        catch (CoreException e) {
            MetamodelDictionaryEclipse.internalError(class$com$sap$ide$metamodel$dictionary$repository$PPEntityServiceHelper == null ? (class$com$sap$ide$metamodel$dictionary$repository$PPEntityServiceHelper = PPEntityServiceHelper.class$("com.sap.ide.metamodel.dictionary.repository.PPEntityServiceHelper")) : class$com$sap$ide$metamodel$dictionary$repository$PPEntityServiceHelper, "addEntiyListener", "Error get webdynpro nature", (Exception)((Object)e), true);
        }
    }

    private static void addEntityListenerForDDicProject(IDCExtendedProject project, Metamodel metamodel) {
        project.addPPEntityService((IPPEntityService)new SimpleTypesAndStructuresEntityService(metamodel));
        project.addPPEntityService((IPPEntityService)new TablesEntityService(metamodel));
    }

    private static void addEntityListenerForWebDynproProject(IDCExtendedProject project, Metamodel metamodel) {
        project.addPPEntityService((IPPEntityService)new SimpleTypesAndStructuresEntityService(metamodel));
    }

    private static Entity createEntity(DevelopmentObject developmentObject) {
        Entity entity = ComponentFactory.createEntity();
        String objectName = developmentObject.getName();
        String objectPackage = "";
        if (developmentObject.isMDO()) {
            objectPackage = ((MainDevelopmentObject)developmentObject).getPackage();
            objectPackage = objectPackage.replace('.', '/');
        }
        IPPModel.EntityType entityType = null;
        if (developmentObject instanceof DtDbTable) {
            entityType = IPPModel.EntityType.DICTIONARY_DATABASE_TABLE;
        } else if (developmentObject instanceof DtSimpleType) {
            entityType = IPPModel.EntityType.DICTIONARY_SIMPLE_TYPE;
        } else if (developmentObject instanceof DtGeneralStructure) {
            entityType = IPPModel.EntityType.DICTIONARY_STRUCTURE;
        }
        String type = entityType.toString();
        if (entityType.getSubTyps().length <= 0) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"No subtype found");
            return null;
        }
        String subType = entityType.getSubTyps()[0].toString();
        entity.setName(objectName);
        entity.setCaption(objectName);
        entity.setDescription(objectName);
        entity.setPackageName(objectPackage);
        entity.setType(type);
        entity.setSubType(subType);
        return entity;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class TablesEntityService
    implements IPPEntityService {
        Metamodel mMetamodel;
        static /* synthetic */ Class class$com$sap$ide$metamodel$dictionary$repository$PPEntityServiceHelper;

        public TablesEntityService(Metamodel metamodel) {
            this.mMetamodel = metamodel;
        }

        public Iterator getEntities(String aType) {
            try {
                DtDictionaryRoot root = DictionaryRootManager.getDictionaryRoot(this.mMetamodel);
                ArrayList<Entity> list = new ArrayList<Entity>();
                if (aType.equals(IPPModel.EntityType.DICTIONARY_DATABASE_TABLE.toString())) {
                    DtDbTable[] tables = root.getTables();
                    int i = 0;
                    while (i < tables.length) {
                        if (!tables[i].originatesInArchive()) {
                            list.add(PPEntityServiceHelper.createEntity((DevelopmentObject)tables[i]));
                        }
                        ++i;
                    }
                }
                return ((AbstractList)list).iterator();
            }
            catch (LoadException e) {
                MetamodelDictionaryEclipse.internalError(class$com$sap$ide$metamodel$dictionary$repository$PPEntityServiceHelper == null ? (class$com$sap$ide$metamodel$dictionary$repository$PPEntityServiceHelper = TablesEntityService.class$("com.sap.ide.metamodel.dictionary.repository.PPEntityServiceHelper")) : class$com$sap$ide$metamodel$dictionary$repository$PPEntityServiceHelper, "TableEntityService.getEntities", "error get db tables from metamodel", (Exception)((Object)e), true);
                return null;
            }
        }

        public String[] getTypes() {
            try {
                DtDictionaryRoot root = DictionaryRootManager.getDictionaryRoot(this.mMetamodel);
                Vector<String> types = new Vector<String>();
                DtDbTable[] tables = root.getTables();
                if (tables.length > 0) {
                    int i = 0;
                    while (i < tables.length) {
                        if (!tables[i].originatesInArchive()) {
                            types.add(IPPModel.EntityType.DICTIONARY_DATABASE_TABLE.toString());
                            break;
                        }
                        ++i;
                    }
                }
                String[] ret = types.toArray(new String[0]);
                return ret;
            }
            catch (LoadException e) {
                MetamodelDictionaryEclipse.internalError(class$com$sap$ide$metamodel$dictionary$repository$PPEntityServiceHelper == null ? (class$com$sap$ide$metamodel$dictionary$repository$PPEntityServiceHelper = TablesEntityService.class$("com.sap.ide.metamodel.dictionary.repository.PPEntityServiceHelper")) : class$com$sap$ide$metamodel$dictionary$repository$PPEntityServiceHelper, "TableEntityService.getTypes", "error get db tables from metamodel", (Exception)((Object)e), true);
                return null;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class SimpleTypesAndStructuresEntityService
    implements IPPEntityService {
        Metamodel mMetamodel;
        static /* synthetic */ Class class$com$sap$ide$metamodel$dictionary$repository$PPEntityServiceHelper;

        public SimpleTypesAndStructuresEntityService(Metamodel metamodel) {
            this.mMetamodel = metamodel;
        }

        public Iterator getEntities(String aType) {
            try {
                DtDictionaryRoot root = DictionaryRootManager.getDictionaryRoot(this.mMetamodel);
                ArrayList<Entity> list = new ArrayList<Entity>();
                if (aType.equals(IPPModel.EntityType.DICTIONARY_SIMPLE_TYPE.toString())) {
                    DtSimpleType[] types = root.getSimpleTypes();
                    int i = 0;
                    while (i < types.length) {
                        if (!(types[i].getBackendName() != null && types[i].getBackendName().length() > 0 || types[i].originatesInArchive())) {
                            list.add(PPEntityServiceHelper.createEntity((DevelopmentObject)types[i]));
                        }
                        ++i;
                    }
                } else if (aType.equals(IPPModel.EntityType.DICTIONARY_STRUCTURE.toString())) {
                    DtGeneralStructure[] structures = root.getStructures();
                    int i = 0;
                    while (i < structures.length) {
                        if (!(structures[i].getBackendName() != null && structures[i].getBackendName().length() > 0 || structures[i].originatesInArchive())) {
                            list.add(PPEntityServiceHelper.createEntity((DevelopmentObject)structures[i]));
                        }
                        ++i;
                    }
                }
                return ((AbstractList)list).iterator();
            }
            catch (LoadException e) {
                MetamodelDictionaryEclipse.internalError(class$com$sap$ide$metamodel$dictionary$repository$PPEntityServiceHelper == null ? (class$com$sap$ide$metamodel$dictionary$repository$PPEntityServiceHelper = SimpleTypesAndStructuresEntityService.class$("com.sap.ide.metamodel.dictionary.repository.PPEntityServiceHelper")) : class$com$sap$ide$metamodel$dictionary$repository$PPEntityServiceHelper, "SimpleTypesAndStructuresEntityService.getEntities", "error get simple types and structures from metamodel", (Exception)((Object)e), true);
                return null;
            }
        }

        public String[] getTypes() {
            try {
                DtGeneralStructure[] structures;
                DtDictionaryRoot root = DictionaryRootManager.getDictionaryRoot(this.mMetamodel);
                Vector<String> types = new Vector<String>();
                DtSimpleType[] stypes = root.getSimpleTypes();
                if (stypes.length > 0) {
                    int i = 0;
                    while (i < stypes.length) {
                        if (!(stypes[i].getBackendName() != null && stypes[i].getBackendName().length() > 0 || stypes[i].originatesInArchive())) {
                            types.add(IPPModel.EntityType.DICTIONARY_SIMPLE_TYPE.toString());
                            break;
                        }
                        ++i;
                    }
                }
                if ((structures = root.getStructures()).length > 0) {
                    int i = 0;
                    while (i < structures.length) {
                        if (!(structures[i].getBackendName() != null && structures[i].getBackendName().length() > 0 || structures[i].originatesInArchive())) {
                            types.add(IPPModel.EntityType.DICTIONARY_STRUCTURE.toString());
                            break;
                        }
                        ++i;
                    }
                }
                String[] ret = types.toArray(new String[0]);
                return ret;
            }
            catch (LoadException e) {
                MetamodelDictionaryEclipse.internalError(class$com$sap$ide$metamodel$dictionary$repository$PPEntityServiceHelper == null ? (class$com$sap$ide$metamodel$dictionary$repository$PPEntityServiceHelper = SimpleTypesAndStructuresEntityService.class$("com.sap.ide.metamodel.dictionary.repository.PPEntityServiceHelper")) : class$com$sap$ide$metamodel$dictionary$repository$PPEntityServiceHelper, "SimpleTypesAndStructuresEntityService.getTypes", "error get simple types and structures from metamodel", (Exception)((Object)e), true);
                return null;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

