/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.dictionary.plugin;

import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.ICoreModelExtender;
import com.sap.ide.metamodel.core.repository.IMMRepositoryObjectProvider;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.dictionary.plugin.DictionaryRootManager;
import com.sap.ide.metamodel.dictionary.repository.MMRepositoryObjectProvider;
import com.sap.ide.metamodel.dictionary.repository.PPEntityServiceHelper;
import com.sap.ide.metamodel.dictionary.services.ServicesEclipse;
import com.sap.ide.metamodel.general.Root;
import java.io.File;
import org.eclipse.core.internal.plugins.PluginDescriptor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Plugin;

public class MetamodelDictionaryEclipse
extends Plugin
implements ICoreModelExtender {
    private static MetamodelDictionaryEclipse plugin;
    private static final String CONTENT_FOLDER_NAME = "content";
    private static final String CONTENT_ARCHIVE_NAME = "SapMetamodelDictionaryContent.zip";

    public MetamodelDictionaryEclipse(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public static MetamodelDictionaryEclipse getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public String getContentArchivePath() {
        PluginDescriptor descriptor = (PluginDescriptor)this.getDescriptor();
        String contentArchivePath = descriptor.getLocation() + CONTENT_FOLDER_NAME;
        if (contentArchivePath.startsWith("file:")) {
            contentArchivePath = contentArchivePath.substring(5);
        }
        contentArchivePath = contentArchivePath + File.separator + CONTENT_ARCHIVE_NAME;
        return contentArchivePath;
    }

    public String getMetamodelName() {
        return "DtDictionary";
    }

    public Root getRoot(Metamodel metamodel) {
        return DictionaryRootManager.getDictionaryRoot(metamodel);
    }

    public static void internalError(Class theClass, String methodName, String message, Exception exception, boolean logOnly) {
        ServicesUI.internalError((Class)theClass, (String)methodName, (String)message, (Throwable)exception, (Plugin)plugin, (boolean)logOnly);
    }

    public static void logMessage(String message) {
        ServicesUI.logMessage((String)message, (Plugin)plugin);
    }

    public IMMRepositoryObjectProvider getRepositoryObjectProvider() {
        return MMRepositoryObjectProvider.getInstance();
    }

    public void preMetamodelShutdown(Metamodel metamodel) {
        DictionaryRootManager.releaseDictionaryRootManager(metamodel);
    }

    public void doDCProjectInitialization(IDCExtendedProject project, Metamodel metamodel) {
        if (ServicesEclipse.projectHasDictionaryNature(metamodel.getName())) {
            PPEntityServiceHelper.addEntityListener(project, metamodel);
        }
    }

    public void postReload(Metamodel metamodel) {
    }
}

