/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.tree.transform;

import com.sap.engine.gui.tree.transform.TransformableTreeNode;
import java.util.Vector;
import javax.swing.tree.DefaultTreeModel;

public class TreeTransformer {
    protected TransformableTreeNode basicRoot = null;
    protected Vector transInfo = new Vector();
    protected DefaultTreeModel[] modelsContainer;

    public TreeTransformer(TransformableTreeNode basicRoot, Vector v) {
        this.basicRoot = basicRoot;
        this.transInfo = v;
        this.fillModelsContainer();
    }

    public DefaultTreeModel getTransModel(int i) {
        return this.modelsContainer[i];
    }

    public void reload(TransformableTreeNode modifiedRoot) {
        this.detectDifferent(this.basicRoot, modifiedRoot);
    }

    private void detectDifferent(TransformableTreeNode node1, TransformableTreeNode node2) {
        TransformableTreeNode element = this.differentNode(node1, node2);
        if (element.toString() == null) {
            int i = 0;
            while (i < node1.getChildCount()) {
                this.detectDifferent((TransformableTreeNode)node1.getChildAt(i), (TransformableTreeNode)node2.getChildAt(i));
                ++i;
            }
        }
    }

    private TransformableTreeNode differentNode(TransformableTreeNode node1, TransformableTreeNode node2) {
        TransformableTreeNode resultNode;
        block7: {
            int count2;
            int count1;
            block6: {
                resultNode = new TransformableTreeNode();
                count1 = node1.getChildCount();
                if (count1 <= (count2 = node2.getChildCount())) break block6;
                resultNode = (TransformableTreeNode)node1.getChildAt(count1 - 1);
                int i = 0;
                while (i < count2) {
                    if (!this.isEqualToForDifferentNode((TransformableTreeNode)node1.getChildAt(i), (TransformableTreeNode)node2.getChildAt(i))) {
                        resultNode = (TransformableTreeNode)node1.getChildAt(i);
                        break;
                    }
                    ++i;
                }
                int k = 0;
                while (k < this.modelsContainer.length) {
                    this.removeNodeAtAllOccurrences(this.modelsContainer[k], (TransformableTreeNode)this.modelsContainer[k].getRoot(), resultNode);
                    this.sortRecursive(this.modelsContainer[k], (TransformableTreeNode)this.modelsContainer[k].getRoot());
                    ++k;
                }
                break block7;
            }
            if (count1 >= count2) break block7;
            resultNode = (TransformableTreeNode)node2.getChildAt(count2 - 1);
            int i = 0;
            if (i < count1) {
                if (!this.isEqualToForDifferentNode((TransformableTreeNode)node1.getChildAt(i), (TransformableTreeNode)node2.getChildAt(i))) {
                    resultNode = (TransformableTreeNode)node2.getChildAt(i);
                }
            }
            int k = 0;
            while (k < this.modelsContainer.length) {
                Vector<TransformableTreeNode> v = new Vector<TransformableTreeNode>();
                v.add((TransformableTreeNode)node2.getRoot());
                this.insertNodeIntoReadyModel(this.modelsContainer[k], (TransformableTreeNode)node2.getRoot(), resultNode, v, (int[])this.transInfo.elementAt(k));
                this.sortRecursive(this.modelsContainer[k], (TransformableTreeNode)this.modelsContainer[k].getRoot());
                ++k;
            }
        }
        return resultNode;
    }

    private boolean isEqualToForDifferentNode(TransformableTreeNode node, TransformableTreeNode root) {
        boolean flag = false;
        if (node.getNodeLevel() == root.getNodeLevel() && node != null && node.getName() != null && root != null && node.getName().equals(root.getName())) {
            flag = true;
        }
        return flag;
    }

    private void fillModelsContainer() {
        int count = this.transInfo.size();
        this.modelsContainer = new DefaultTreeModel[count];
        int i = 0;
        while (i < count) {
            this.modelsContainer[i] = this.createTransModel(i);
            this.sortRecursive(this.modelsContainer[i], (TransformableTreeNode)this.modelsContainer[i].getRoot());
            ++i;
        }
    }

    private DefaultTreeModel createTransModel(int i) {
        TransformableTreeNode permRoot = new TransformableTreeNode(this.basicRoot.getName());
        permRoot.setUserObject(this.basicRoot.getUserObject());
        permRoot.setNodeLevel(this.basicRoot.getNodeLevel());
        DefaultTreeModel permModel = new DefaultTreeModel(permRoot);
        this.transform(permModel, (int[])this.transInfo.elementAt(i));
        return permModel;
    }

    public void removeNodeAtAllOccurrences(DefaultTreeModel model, TransformableTreeNode root, TransformableTreeNode deletedNode) {
        if (root.getName() == deletedNode.getName()) {
            model.removeNodeFromParent(root);
        }
        int i = 0;
        while (i < root.getChildCount()) {
            this.removeNodeAtAllOccurrences(model, (TransformableTreeNode)root.getChildAt(i), deletedNode);
            ++i;
        }
    }

    public void insertNodeIntoReadyModel(DefaultTreeModel existingModel, TransformableTreeNode node, TransformableTreeNode insertedNode, Vector v, int[] a) {
        if (node.isLeaf()) {
            if (this.checkIfNeeded(node, a)) {
                v.add(node);
                this.putToTree(insertedNode, v, a, existingModel);
                v.removeElementAt(v.size() - 1);
            } else {
                this.putToTree(insertedNode, v, a, existingModel);
            }
        } else if (this.checkIfNeeded(node, a)) {
            v.add(node);
            int i = 0;
            while (i < node.getChildCount()) {
                this.insertNodeIntoReadyModel(existingModel, (TransformableTreeNode)node.getChildAt(i), insertedNode, v, a);
                ++i;
            }
            v.removeElementAt(v.size() - 1);
        } else {
            int i = 0;
            while (i < node.getChildCount()) {
                this.insertNodeIntoReadyModel(existingModel, (TransformableTreeNode)node.getChildAt(i), insertedNode, v, a);
                ++i;
            }
        }
    }

    private void putToTree(TransformableTreeNode insNode, Vector v, int[] a, DefaultTreeModel existingModel) {
        int i = 0;
        while (i < v.size()) {
            Vector modifiedV;
            if (this.isEqualTo(insNode, (TransformableTreeNode)v.elementAt(i)) && ((TransformableTreeNode)(modifiedV = this.modifyVector(v, a)).elementAt(1)).getNodeLevel() == a[0]) {
                this.addVectorToTree(existingModel, (TransformableTreeNode)existingModel.getRoot(), modifiedV);
            }
            ++i;
        }
    }

    private void transform(DefaultTreeModel transformedModel, int[] a) {
        Vector<TransformableTreeNode> neededNodes = new Vector<TransformableTreeNode>();
        neededNodes.add((TransformableTreeNode)transformedModel.getRoot());
        this.cc(transformedModel, this.basicRoot, neededNodes, a);
    }

    private boolean checkIfNeeded(TransformableTreeNode node, int[] a) {
        int level = node.getNodeLevel();
        boolean flag = false;
        int i = 0;
        while (i < a.length) {
            if (a[i] == level) {
                flag = true;
            }
            ++i;
        }
        return flag;
    }

    private void cc(DefaultTreeModel transformedModel, TransformableTreeNode node, Vector v, int[] a) {
        block7: {
            block5: {
                block6: {
                    if (!node.isLeaf()) break block5;
                    if (!this.checkIfNeeded(node, a)) break block6;
                    v.add(node);
                    Vector modifiedV = this.modifyVector(v, a);
                    if (((TransformableTreeNode)modifiedV.elementAt(1)).getNodeLevel() == a[0]) {
                        this.addVectorToTree(transformedModel, (TransformableTreeNode)transformedModel.getRoot(), modifiedV);
                    }
                    v.removeElementAt(v.size() - 1);
                    break block7;
                }
                Vector modifiedV = this.modifyVector(v, a);
                if (((TransformableTreeNode)modifiedV.elementAt(1)).getNodeLevel() != a[0]) break block7;
                this.addVectorToTree(transformedModel, (TransformableTreeNode)transformedModel.getRoot(), modifiedV);
                break block7;
            }
            if (this.checkIfNeeded(node, a)) {
                v.add(node);
                int i = 0;
                while (i < node.getChildCount()) {
                    this.cc(transformedModel, (TransformableTreeNode)node.getChildAt(i), v, a);
                    ++i;
                }
                v.removeElementAt(v.size() - 1);
            } else {
                int i = 0;
                while (i < node.getChildCount()) {
                    this.cc(transformedModel, (TransformableTreeNode)node.getChildAt(i), v, a);
                    ++i;
                }
            }
        }
    }

    private void addVectorToTree(DefaultTreeModel newModel, TransformableTreeNode node, Vector v) {
        if (this.isEqualTo(node, (TransformableTreeNode)newModel.getRoot()) && node.isLeaf()) {
            v.remove(0);
            this.addVectorToNode(newModel, node, v);
        } else if (node.isLeaf()) {
            if (v.size() != 1 || !this.isEqualTo(node, (TransformableTreeNode)v.elementAt(0))) {
                this.addVectorToNode(newModel, node, v);
            }
        } else if (this.isEqualTo(node, (TransformableTreeNode)v.elementAt(0))) {
            v.remove(0);
            TransformableTreeNode newNode = this.matchingChild((TransformableTreeNode)v.elementAt(0), node);
            if (newNode == null) {
                this.addVectorToNode(newModel, node, v);
            } else {
                this.addVectorToTree(newModel, newNode, v);
            }
        } else {
            this.addVectorToNode(newModel, node, v);
        }
    }

    private Vector modifyVector(Vector v, int[] a) {
        Vector<TransformableTreeNode> newV = new Vector<TransformableTreeNode>();
        TransformableTreeNode node = new TransformableTreeNode(((TransformableTreeNode)v.elementAt(0)).getName());
        node.setUserObject(((TransformableTreeNode)v.elementAt(0)).getUserObject());
        node.setNodeLevel(((TransformableTreeNode)v.elementAt(0)).getNodeLevel());
        newV.add(node);
        int i = 0;
        while (i < a.length) {
            int j = 1;
            while (j < v.size()) {
                if (((TransformableTreeNode)v.elementAt(j)).getNodeLevel() == a[i]) {
                    TransformableTreeNode node1 = new TransformableTreeNode(((TransformableTreeNode)v.elementAt(j)).getName());
                    node1.setUserObject(((TransformableTreeNode)v.elementAt(j)).getUserObject());
                    node1.setNodeLevel(((TransformableTreeNode)v.elementAt(j)).getNodeLevel());
                    newV.add(node1);
                }
                ++j;
            }
            ++i;
        }
        return newV;
    }

    private boolean isEqualTo(TransformableTreeNode node, TransformableTreeNode root) {
        boolean flag = false;
        if (node.getNodeLevel() == root.getNodeLevel() && node.getName() == root.getName()) {
            flag = true;
        }
        return flag;
    }

    private TransformableTreeNode matchingChild(TransformableTreeNode node, TransformableTreeNode root) {
        TransformableTreeNode newNode = null;
        int i = 0;
        while (i < root.getChildCount()) {
            if (this.isEqualTo((TransformableTreeNode)root.getChildAt(i), node)) {
                newNode = (TransformableTreeNode)root.getChildAt(i);
                break;
            }
            ++i;
        }
        return newNode;
    }

    private void addVectorToNode(DefaultTreeModel newModel, TransformableTreeNode node, Vector v) {
        int i = 0;
        while (i < v.size()) {
            TransformableTreeNode newNode = (TransformableTreeNode)v.elementAt(i);
            newModel.insertNodeInto(newNode, node, 0);
            node = newNode;
            ++i;
        }
    }

    private void removeNode(DefaultTreeModel model, TransformableTreeNode node) {
        model.removeNodeFromParent(node);
    }

    private void findPlaceAndInsert(DefaultTreeModel model, TransformableTreeNode parrent, TransformableTreeNode node) {
        int childCount = parrent.getChildCount();
        boolean added = false;
        TransformableTreeNode theNode = null;
        int counter = 0;
        while (counter < childCount) {
            theNode = (TransformableTreeNode)parrent.getChildAt(counter);
            if (theNode.toString().compareTo(node.toString()) > 0) {
                model.insertNodeInto(node, parrent, counter);
                added = true;
                break;
            }
            if (theNode.toString().compareTo(node.toString()) == 0) {
                int i = 0;
                while (i < node.getChildCount()) {
                    this.findPlaceAndInsert(model, theNode, (TransformableTreeNode)node.getChildAt(i));
                    this.sort(model, theNode);
                    ++i;
                }
                return;
            }
            ++counter;
        }
        if (!added) {
            model.insertNodeInto(node, parrent, childCount);
        }
    }

    private void sort(DefaultTreeModel model, TransformableTreeNode currentRoot) {
        if (!currentRoot.isLeaf() && currentRoot.getChildCount() > 1) {
            TransformableTreeNode currentNode = null;
            int indexOfNode = 0;
            int countOfNodes = currentRoot.getChildCount();
            do {
                currentNode = (TransformableTreeNode)currentRoot.getChildAt(indexOfNode);
                countOfNodes = currentRoot.getChildCount();
                if (indexOfNode == countOfNodes - 1) break;
                if (currentRoot.getChildAt(indexOfNode + 1).toString().compareTo(currentNode.toString()) <= 0) {
                    this.removeNode(model, currentNode);
                    this.findPlaceAndInsert(model, currentRoot, currentNode);
                    indexOfNode = 0;
                    this.sort(model, currentNode);
                    continue;
                }
                ++indexOfNode;
            } while (indexOfNode < countOfNodes - 1);
        }
    }

    private void sortRecursive(DefaultTreeModel model, TransformableTreeNode root) {
        int countOfChildren = root.getChildCount();
        this.sort(model, root);
        countOfChildren = root.getChildCount();
        int counter = 0;
        while (counter < countOfChildren) {
            this.sortRecursive(model, (TransformableTreeNode)root.getChildAt(counter));
            ++counter;
        }
    }
}

