/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.table;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class SortModel
extends AbstractTableModel
implements TableModelListener {
    Vector indexes = new Vector();
    Vector sortingColumns = new Vector();
    boolean ascending = true;
    boolean startSort = false;
    protected AbstractTableModel model;
    protected JTable tableView;
    int columnToSort = 0;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;

    public SortModel(AbstractTableModel model) {
        this.setModel(model);
    }

    public void initSortColumn(int column) {
        if (column > this.getColumnCount() || column < 0) {
            return;
        }
        this.columnToSort = column;
        this.sortingColumns.addElement(new Integer(column));
        if (this.tableView != null) {
            int i = 0;
            while (i < this.model.getColumnCount()) {
                String headerText = this.model.getColumnName(this.tableView.convertColumnIndexToModel(i)).toString();
                if (this.tableView.convertColumnIndexToModel(i) == column) {
                    headerText = this.ascending ? "<" + headerText : ">" + headerText;
                }
                this.tableView.getColumnModel().getColumn(i).setHeaderValue(headerText);
                ++i;
            }
            this.tableView.getTableHeader().repaint();
        }
        this.reallocateIndexes();
    }

    public AbstractTableModel getModel() {
        return this.model;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public void setModel(AbstractTableModel model) {
        this.model = model;
        model.addTableModelListener(this);
        this.reallocateIndexes();
        this.initModel();
    }

    void initModel() {
        this.model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent ev) {
            }
        });
    }

    public int compareRowsByColumn(int row1, int row2, int column) {
        Object v2;
        String s2;
        AbstractTableModel data = this.model;
        Object o1 = data.getValueAt(row1, column);
        Object o2 = data.getValueAt(row2, column);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        Class<?> type = o1.getClass();
        if (type == (class$java$util$Date == null ? (class$java$util$Date = SortModel.class$("java.util.Date")) : class$java$util$Date)) {
            Date d2;
            long n2;
            Date d1 = (Date)o1;
            long n1 = d1.getTime();
            if (n1 < (n2 = (d2 = (Date)o2).getTime())) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            return 0;
        }
        if (type == (class$java$lang$String == null ? (class$java$lang$String = SortModel.class$("java.lang.String")) : class$java$lang$String)) {
            String s22;
            String s1 = (String)data.getValueAt(row1, column);
            int result = s1.compareTo(s22 = (String)data.getValueAt(row2, column));
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type.getSuperclass() == (class$java$lang$Number == null ? (class$java$lang$Number = SortModel.class$("java.lang.Number")) : class$java$lang$Number)) {
            Number n2;
            double d2;
            Number n1 = (Number)data.getValueAt(row1, column);
            double d1 = n1.doubleValue();
            if (d1 < (d2 = (n2 = (Number)data.getValueAt(row2, column)).doubleValue())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
        Object v1 = data.getValueAt(row1, column);
        String s1 = v1.toString();
        int result = s1.compareTo(s2 = (v2 = data.getValueAt(row2, column)).toString());
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    public int compare(int row1, int row2) {
        int level = 0;
        while (level < this.sortingColumns.size()) {
            Integer column = (Integer)this.sortingColumns.elementAt(level);
            int result = this.compareRowsByColumn(row1, row2, column);
            if (result != 0) {
                return this.ascending ? result : -result;
            }
            ++level;
        }
        return 0;
    }

    public void reallocateIndexes() {
        int rowCount = this.model.getRowCount();
        if (rowCount < this.indexes.size()) {
            this.indexes.removeAllElements();
        }
        int row = this.indexes.size();
        while (row < rowCount) {
            this.indexes.addElement(new Integer(row));
            ++row;
        }
    }

    public synchronized void tableChanged(TableModelEvent e) {
        this.reallocateIndexes();
        this.fireTableChanged(e);
        this.sort(this);
    }

    public void sort(Object sender) {
        this.startSort = true;
        this.shuttlesort((Vector)this.indexes.clone(), this.indexes, 0, this.indexes.size());
        this.startSort = false;
    }

    public void shuttlesort(Vector from, Vector to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare((Integer)from.elementAt(middle - 1), (Integer)from.elementAt(middle)) <= 0) {
            int i = low;
            while (i < high) {
                to.setElementAt(new Integer((Integer)from.elementAt(i)), i);
                ++i;
            }
            return;
        }
        int i = low;
        while (i < high) {
            if (q >= high || p < middle && this.compare((Integer)from.elementAt(p), (Integer)from.elementAt(q)) <= 0) {
                to.setElementAt(new Integer((Integer)from.elementAt(p++)), i);
            } else {
                to.setElementAt(new Integer((Integer)from.elementAt(q++)), i);
            }
            ++i;
        }
    }

    public void sortByColumn(int column) {
        this.sortByColumn(column, true);
    }

    public void sortByColumn(int column, boolean ascending) {
        this.ascending = ascending;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(column));
        this.sort(this);
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void addHeaderListener(JTable table) {
        final SortModel sorter = this;
        this.tableView = table;
        this.tableView.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = SortModel.this.tableView.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = SortModel.this.tableView.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    SortModel.this.ascending = column == SortModel.this.columnToSort ? !SortModel.this.ascending : true;
                    SortModel.this.columnToSort = column;
                    int i = 0;
                    while (i < SortModel.this.model.getColumnCount()) {
                        String headerText = SortModel.this.model.getColumnName(SortModel.this.tableView.convertColumnIndexToModel(i)).toString();
                        if (SortModel.this.tableView.convertColumnIndexToModel(i) == column) {
                            headerText = SortModel.this.ascending ? "<" + headerText : ">" + headerText;
                        }
                        SortModel.this.tableView.getColumnModel().getColumn(i).setHeaderValue(headerText);
                        ++i;
                    }
                    SortModel.this.tableView.getTableHeader().repaint();
                    sorter.sortByColumn(column, SortModel.this.ascending);
                    SortModel.this.tableView.getSelectionModel().clearSelection();
                }
            }
        };
        JTableHeader th = this.tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
    }

    public int getRowCount() {
        return this.model.getRowCount();
    }

    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    public String getColumnName(int aColumn) {
        return this.model.getColumnName(aColumn);
    }

    public Class getColumnClass(int aColumn) {
        return this.model.getColumnClass(aColumn);
    }

    public boolean isCellEditable(int row, int column) {
        return this.model.isCellEditable(row, column);
    }

    public Object getValueAt(int aRow, int aColumn) {
        if (this.indexes.size() == 0) {
            return null;
        }
        return this.model.getValueAt((Integer)this.indexes.elementAt(aRow), aColumn);
    }

    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.model.setValueAt(aValue, (Integer)this.indexes.elementAt(aRow), aColumn);
    }

    public synchronized int getTrueIndex(int i) {
        return (Integer)this.indexes.elementAt(i);
    }

    public synchronized int getViewIndex(int index) {
        int i = 0;
        while (i < this.indexes.size()) {
            if ((Integer)this.indexes.elementAt(i) == index) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

