/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.status;

import com.sap.engine.gui.status.ImageHolder;
import com.sap.engine.gui.status.StatusInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.UIManager;

public class StatusLinePanel
extends JPanel {
    private final JLabel statusLabel;
    private StatusInfo item;
    private final Timer timer = new Timer(750, new TimerActionHandler());
    private static final Color RED_COLOR = new Color(210, 0, 5);
    private static final Color DEFAULT_BACKGROUND_COLOR = UIManager.getColor("Panel.background");
    private static final int DELAY_PERIOD = 750;
    private boolean initiatedByTimer = false;

    public StatusLinePanel() {
        this.timer.setRepeats(false);
        this.setLayout(new BorderLayout(5, 5));
        this.statusLabel = new JLabel();
        this.add((Component)this.statusLabel, "Center");
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    void setItem(StatusInfo item) {
        this.item = item;
        this.initiatedByTimer = false;
        this.statusLabel.setText(item.getTitle());
        this.statusLabel.setIcon(ImageHolder.getIcon(item.getStatus()));
        if (item.getStatus() == 2) {
            if (!this.getBackground().equals(RED_COLOR)) {
                this.setBackground(RED_COLOR);
                this.timer.start();
            }
        } else if (!this.getBackground().equals(DEFAULT_BACKGROUND_COLOR)) {
            this.setBackground(DEFAULT_BACKGROUND_COLOR);
        }
    }

    public void repaint() {
        super.repaint();
        if (this.statusLabel != null && this.item != null) {
            if (this.item.getStatus() == 2) {
                if (!this.getBackground().equals(RED_COLOR) && !this.initiatedByTimer) {
                    this.setBackground(RED_COLOR);
                    this.timer.start();
                }
            } else if (!this.getBackground().equals(DEFAULT_BACKGROUND_COLOR)) {
                this.setBackground(DEFAULT_BACKGROUND_COLOR);
            }
            if (this.statusLabel.getIcon() != ImageHolder.getIcon(this.item.getStatus())) {
                this.statusLabel.setIcon(ImageHolder.getIcon(this.item.getStatus()));
            }
            if (!this.statusLabel.getText().equals(this.item.getTitle())) {
                this.statusLabel.setText(this.item.getTitle());
            }
        }
    }

    private class TimerActionHandler
    implements ActionListener {
        private TimerActionHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!StatusLinePanel.this.getBackground().equals(DEFAULT_BACKGROUND_COLOR)) {
                StatusLinePanel.this.initiatedByTimer = true;
                StatusLinePanel.this.setBackground(DEFAULT_BACKGROUND_COLOR);
            }
        }
    }
}

