/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.ser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.ImageIcon;

public class SerializableImage
implements Serializable {
    static final long serialVersionUID = 100600685252571804L;
    public byte[] imageData;
    public String imageFileName;

    public SerializableImage() {
    }

    public SerializableImage(String fileName) {
        this.initImageData(fileName);
    }

    protected void initImageData(String fileName) {
        this.imageFileName = fileName;
        if (fileName == null) {
            this.imageData = null;
            return;
        }
        File file = new File(fileName);
        if (file.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                this.imageData = new byte[in.available()];
                in.read(this.imageData);
                in.close();
            }
            catch (IOException e) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                this.imageData = null;
            }
        } else {
            this.imageData = null;
        }
    }

    public ImageIcon getImageIcon() {
        if (this.imageData != null) {
            return new ImageIcon(this.imageData);
        }
        return null;
    }

    public ImageIcon getImageIcon(String fileName) {
        this.initImageData(fileName);
        if (this.imageData != null) {
            return new ImageIcon(this.imageData);
        }
        return null;
    }

    public String getIconName() {
        return this.imageFileName;
    }

    public Object clone() {
        SerializableImage newImage = new SerializableImage();
        newImage.imageFileName = this.imageFileName;
        if (this.imageData == null) {
            newImage.imageData = null;
        } else {
            newImage.imageData = new byte[this.imageData.length];
            System.arraycopy(this.imageData, 0, newImage.imageData, 0, this.imageData.length);
        }
        return newImage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SerializableImage)) return false;
        SerializableImage img = (SerializableImage)obj;
        if (this.imageFileName != null) {
            if (img.imageFileName == null) return false;
            if (!this.imageFileName.equals(img.imageFileName)) {
                return false;
            }
        } else if (img.imageFileName != null) {
            return false;
        }
        if (this.imageData != null) {
            if (img.imageData == null) return false;
            if (this.imageData.length != img.imageData.length) {
                return false;
            }
            int i = 0;
            while (i < this.imageData.length) {
                if (this.imageData[i] != img.imageData[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        } else {
            if (img.imageData == null) return true;
            return false;
        }
    }
}

