/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.lib;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ReferencePanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    public static final String ADD_CMD = "ADD_CMD";
    public static final String REMOVE_CMD = "REMOVE_CMD";
    public static final String EDIT_CMD = "EDIT_CMD";
    JScrollPane jScrollPane1 = new JScrollPane();
    JList theList = new JList();
    JButton addButton = new JButton();
    JButton removeButton = new JButton();
    JButton editButton = new JButton();
    Border border1 = new EtchedBorder(1, Color.white, new Color(134, 134, 134));
    TitledBorder titledBorder1;
    String title = "Title";
    String newText = "Enter name:";
    String editText = "Edit name:";
    Frame frame = null;
    Vector componentsVector = null;
    private JCheckBox addAsLib = new JCheckBox("Add as library", true);

    public ReferencePanel() {
        try {
            this.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ReferencePanel(String title, String newText, String editText) {
        this.title = title;
        this.newText = newText;
        this.editText = editText;
        try {
            this.init();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void init() throws Exception {
        this.setLayout(new GridBagLayout());
        this.addButton.setText("Add");
        this.addButton.setActionCommand(ADD_CMD);
        this.addButton.addActionListener(this);
        this.removeButton.setText("Remove");
        this.removeButton.setActionCommand(REMOVE_CMD);
        this.removeButton.addActionListener(this);
        this.editButton.setText("Edit");
        this.editButton.setActionCommand(EDIT_CMD);
        this.editButton.addActionListener(this);
        this.titledBorder1 = new TitledBorder(this.border1, this.title);
        this.jScrollPane1.setBorder(this.titledBorder1);
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 0, 1, 3, 0.1, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.addButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(8, 5, 5, 5), 0, 0));
        this.add((Component)this.removeButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.editButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.addAsLib, new GridBagConstraints(0, 3, 1, 1, 0.1, 0.0, 15, 2, new Insets(8, 5, 5, 5), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.theList, null);
        this.theList.addListSelectionListener(this);
        this.theList.setSelectionMode(0);
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public void setEnabled(boolean flag) {
        this.addButton.setEnabled(flag);
        this.removeButton.setEnabled(false);
        this.editButton.setEnabled(false);
        this.theList.setEnabled(flag);
    }

    public void initList(String[] names) {
        if (this.componentsVector == null) {
            this.componentsVector = new Vector();
        } else {
            this.componentsVector.removeAllElements();
        }
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                this.componentsVector.add(names[i]);
                ++i;
            }
        }
        this.theList.setListData(this.componentsVector);
    }

    public void initList(Vector names) {
        this.componentsVector = names != null ? (Vector)names.clone() : new Vector();
        this.theList.setListData(this.componentsVector);
    }

    public String[] getListDataArray() {
        if (this.componentsVector == null || this.componentsVector.size() == 0) {
            return null;
        }
        Object[] res = new String[this.componentsVector.size()];
        this.componentsVector.copyInto(res);
        return res;
    }

    public Vector getListData() {
        return this.componentsVector;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(ADD_CMD)) {
            this.addButtonAction();
        } else if (cmd.equals(REMOVE_CMD)) {
            this.removeButtonAction();
        } else if (cmd.equals(EDIT_CMD)) {
            this.editButtonAction();
        }
    }

    private void addButtonAction() {
        String component = JOptionPane.showInputDialog(this, this.newText, "Enter a name for new component", -1);
        if (component == null || component.equals("")) {
            return;
        }
        if (this.addAsLib.isSelected()) {
            if (component.toLowerCase().indexOf("library:") == -1) {
                component = "library:" + component;
            } else if (component.indexOf("library:") == -1) {
                component = "library:" + component.substring(component.toLowerCase().indexOf("library:") + 8);
            }
        } else if (component.toLowerCase().indexOf("library:") != -1 && component.indexOf("library:") == -1) {
            component = "library:" + component.substring(component.toLowerCase().indexOf("library:") + 8);
        }
        if (this.componentsVector == null) {
            this.componentsVector = new Vector();
        }
        if (!this.componentsVector.contains(component)) {
            this.componentsVector.add(component.trim());
            this.theList.setListData(this.componentsVector);
        }
    }

    private void removeButtonAction() {
        if (!this.theList.isSelectionEmpty()) {
            int index = this.theList.getSelectedIndex();
            this.componentsVector.removeElementAt(index);
            this.theList.setListData(this.componentsVector);
        }
    }

    public void editButtonAction() {
        if (!this.theList.isSelectionEmpty()) {
            int index = this.theList.getSelectedIndex();
            String value = (String)this.componentsVector.elementAt(index);
            String name = (String)JOptionPane.showInputDialog(this, this.editText, "Edit the name of the component", -1, null, null, value);
            if (name == null || name.equals("")) {
                return;
            }
            if (!this.componentsVector.contains(name.trim())) {
                this.componentsVector.setElementAt(name.trim(), index);
                this.theList.setListData(this.componentsVector);
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.theList.isSelectionEmpty()) {
            this.removeButton.setEnabled(true);
            this.editButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
        }
    }
}

