/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.diagram;

import com.sap.engine.gui.diagram.DoubleDiagramPanel;
import com.sap.engine.gui.diagram.SingleDiagramPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class RuntimeScrollablePanel
extends JPanel
implements Runnable {
    Border etchedBorder = BorderFactory.createEtchedBorder();
    GridBagLayout gridBagLayout = new GridBagLayout();
    BorderLayout borderLayout = new BorderLayout();
    JPanel panel = new JPanel();
    JScrollPane panelScrollPane = new JScrollPane(this.panel);
    Vector panelsVector = new Vector();
    int panelsCount;
    boolean isDouble;

    public RuntimeScrollablePanel(int panelsCount, boolean isDouble) {
        this.panelsCount = panelsCount;
        this.isDouble = isDouble;
        try {
            this.initScrollablePanel();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (isDouble) {
            this.initDoublePanel();
        } else {
            this.initSinglePanel();
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    private void initScrollablePanel() throws Exception {
        this.setLayout(this.borderLayout);
        this.panel.setLayout(this.gridBagLayout);
        this.add((Component)this.panelScrollPane, "Center");
        this.panel.setBorder(this.etchedBorder);
    }

    public void initDoublePanel() {
        Color c1 = new Color(0, 255, 0);
        Color c2 = new Color(255, 127, 127);
        int i = 0;
        while (i < this.panelsCount) {
            DoubleDiagramPanel diagramPanel = new DoubleDiagramPanel(true);
            diagramPanel.setColors(c1, c2);
            diagramPanel.setPreferredSize(new Dimension(250, 150));
            JPanel aPanel = new JPanel();
            aPanel.setLayout(new BorderLayout());
            aPanel.add((Component)diagramPanel, "Center");
            aPanel.setBorder(BorderFactory.createBevelBorder(0));
            this.panel.add((Component)aPanel, new GridBagConstraints(0, i, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.panelsVector.addElement(diagramPanel);
            ++i;
        }
    }

    public void initSinglePanel() {
        Color c = new Color(0, 255, 0);
        int i = 0;
        while (i < this.panelsCount) {
            SingleDiagramPanel diagramPanel = new SingleDiagramPanel(true);
            diagramPanel.setColor(c);
            diagramPanel.setPreferredSize(new Dimension(250, 150));
            JPanel aPanel = new JPanel();
            aPanel.setLayout(new BorderLayout());
            aPanel.add((Component)diagramPanel, "Center");
            aPanel.setBorder(BorderFactory.createBevelBorder(0));
            this.panel.add((Component)aPanel, new GridBagConstraints(0, i, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.panelsVector.addElement(diagramPanel);
            ++i;
        }
    }

    public void setMaxValues(int[] maxValues) {
        if (!this.isDouble) {
            int i = 0;
            while (i < maxValues.length) {
                SingleDiagramPanel singleDiagramPanel = (SingleDiagramPanel)this.panelsVector.elementAt(i);
                singleDiagramPanel.setMaxValue(maxValues[i]);
                this.panelsVector.setElementAt(singleDiagramPanel, i);
                ++i;
            }
        }
    }

    public void setMaxValues(int[] maxValues1, int[] maxValues2) {
        if (this.isDouble && maxValues1.length == maxValues2.length) {
            int i = 0;
            while (i < maxValues1.length) {
                DoubleDiagramPanel doubleDiagramPanel = (DoubleDiagramPanel)this.panelsVector.elementAt(i);
                doubleDiagramPanel.setMaxValues(maxValues1[i], maxValues2[i]);
                this.panelsVector.setElementAt(doubleDiagramPanel, i);
                ++i;
            }
        }
    }

    public void setNames(String[] names) {
        if (!this.isDouble) {
            int i = 0;
            while (i < names.length) {
                SingleDiagramPanel singleDiagramPanel = (SingleDiagramPanel)this.panelsVector.elementAt(i);
                singleDiagramPanel.setNameLabel(names[i]);
                this.panelsVector.setElementAt(singleDiagramPanel, i);
                ++i;
            }
        }
    }

    public void setNames(String[] names1, String[] names2) {
        if (this.isDouble && names1.length == names2.length) {
            int i = 0;
            while (i < names1.length) {
                DoubleDiagramPanel doubleDiagramPanel = (DoubleDiagramPanel)this.panelsVector.elementAt(i);
                doubleDiagramPanel.setNameLabels(names1[i], names2[i]);
                this.panelsVector.setElementAt(doubleDiagramPanel, i);
                ++i;
            }
        }
    }

    public void addValues(int[] values) {
        if (!this.isDouble) {
            int i = 0;
            while (i < values.length) {
                SingleDiagramPanel singleDiagramPanel = (SingleDiagramPanel)this.panelsVector.elementAt(i);
                singleDiagramPanel.setValue(values[i]);
                this.panelsVector.setElementAt(singleDiagramPanel, i);
                ++i;
            }
        }
    }

    public void addValues(int[] values1, int[] values2) {
        if (this.isDouble && values1.length == values2.length) {
            int i = 0;
            while (i < values1.length) {
                DoubleDiagramPanel doubleDiagramPanel = (DoubleDiagramPanel)this.panelsVector.elementAt(i);
                doubleDiagramPanel.setValue(values1[i], values2[i]);
                this.panelsVector.setElementAt(doubleDiagramPanel, i);
                ++i;
            }
        }
    }

    public void reset() {
        if (this.isDouble) {
            int i = 0;
            while (i < this.panelsVector.size()) {
                DoubleDiagramPanel doubleDiagramPanel = (DoubleDiagramPanel)this.panelsVector.elementAt(i);
                doubleDiagramPanel.reset();
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.panelsVector.size()) {
                SingleDiagramPanel singleDiagramPanel = (SingleDiagramPanel)this.panelsVector.elementAt(i);
                singleDiagramPanel.reset();
                ++i;
            }
        }
    }

    public void run() {
        if (this.isDouble) {
            int x1 = (int)(Math.random() * 100.0);
            int x2 = (int)(Math.random() * 100.0);
            int v1 = 0;
            int v2 = 0;
            boolean p = false;
            while (true) {
                v1 = 50 - (int)(Math.random() * 100.0);
                v2 = 50 - (int)(Math.random() * 100.0);
                x2 += v2 % 8;
                if ((x1 += v1 % 8) > 100) {
                    x1 = 100;
                }
                if (x2 > 100) {
                    x2 = 100;
                }
                if (x1 < 0) {
                    x1 = 0;
                }
                if (x2 < 0) {
                    x2 = 0;
                }
                int value1 = x1;
                int value2 = x2;
                Thread thread = Thread.currentThread();
                int i = 0;
                while (i < this.panelsVector.size()) {
                    ((DoubleDiagramPanel)this.panelsVector.elementAt(i)).setValue(value1, value2);
                    ++i;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception ex) {}
            }
        }
        int x = (int)(Math.random() * 100.0);
        int v = 0;
        boolean p = false;
        while (true) {
            if ((x += (v = 50 - (int)(Math.random() * 100.0)) % 8) > 100) {
                x = 100;
            }
            if (x < 0) {
                x = 0;
            }
            int value = x;
            Thread thread = Thread.currentThread();
            int i = 0;
            while (i < this.panelsVector.size()) {
                ((SingleDiagramPanel)this.panelsVector.elementAt(i)).setValue(value);
                ++i;
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception ex) {
                continue;
            }
            break;
        }
    }
}

