/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.diagram;

import com.sap.engine.gui.diagram.MultiDiagramGridPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MultiDiagramPanel
extends JPanel {
    protected int[] maxValues;
    protected int[] minValues;
    protected Color[] colors;
    protected int step = 5;
    protected int gridSize = 20;
    protected boolean isProgressBar = true;
    protected int diagramsCount = 0;
    protected MultiDiagramGridPane grid;
    protected int maxDiagramsCount;
    protected JLabel[] maxLabels;
    protected JLabel[] barLabels;
    protected JLabel[] valueLabels;
    protected JLabel[] nameLabels;

    public MultiDiagramPanel(int diagramsCount, boolean isProgress) {
        this.isProgressBar = isProgress;
        this.diagramsCount = diagramsCount;
        this.maxValues = new int[diagramsCount];
        this.minValues = new int[diagramsCount];
        this.initDefaults();
        this.initView();
    }

    protected void setMaxDiagramsCount(int maxDiagramsCount) {
        this.maxDiagramsCount = maxDiagramsCount;
    }

    protected void initView() {
        this.setBackground(Color.black);
        this.setLayout(new GridBagLayout());
        JPanel labelsPanel = new JPanel();
        labelsPanel.setLayout(new GridBagLayout());
        labelsPanel.setBackground(Color.black);
        JPanel maxLabelsPanel = new JPanel();
        maxLabelsPanel.setLayout(new GridBagLayout());
        maxLabelsPanel.setBackground(Color.black);
        int i = 0;
        while (i < this.diagramsCount) {
            if (i % 2 == 0) {
                labelsPanel.add((Component)this.nameLabels[i], new GridBagConstraints(0, i / 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 10, 0, 3), 0, 0));
                labelsPanel.add((Component)this.valueLabels[i], new GridBagConstraints(1, i / 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 25), 0, 0));
                labelsPanel.add((Component)this.barLabels[i], new GridBagConstraints(2, i / 2, 1, 1, 0.1, 0.0, 17, 0, new Insets(3, 0, 0, 15), 0, 0));
            } else {
                labelsPanel.add((Component)this.nameLabels[i], new GridBagConstraints(3, (i - 1) / 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 10, 0, 3), 0, 0));
                labelsPanel.add((Component)this.valueLabels[i], new GridBagConstraints(4, (i - 1) / 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 0, 25), 0, 0));
                labelsPanel.add((Component)this.barLabels[i], new GridBagConstraints(5, (i - 1) / 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 0, 0, 3), 0, 0));
            }
            maxLabelsPanel.add((Component)this.maxLabels[i], new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 3, 0, 3), 0, 0));
            ++i;
        }
        this.add((Component)maxLabelsPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.grid, new GridBagConstraints(1, 0, 2, 2, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)labelsPanel, new GridBagConstraints(1, 2, 4, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 3), 0, 0));
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public void setMaxValues(int[] maxValues) {
        this.maxValues = maxValues;
        int i = 0;
        while (i < this.diagramsCount) {
            if (maxValues[i] != -1) {
                this.maxLabels[i].setText(maxValues[i] + "");
            } else {
                maxValues[i] = Integer.MAX_VALUE;
                this.maxLabels[i].setText("Max");
            }
            ++i;
        }
    }

    public void setMinValues(int[] minValues) {
        this.minValues = minValues;
    }

    public void setNameLabels(String[] names) {
        int i = 0;
        while (i < this.diagramsCount) {
            this.nameLabels[i].setText(names[i]);
            ++i;
        }
    }

    public void setNameLabels(String name) {
        int i = 0;
        while (i < this.diagramsCount) {
            this.nameLabels[i].setText(name);
            ++i;
        }
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
        this.grid.setColor(colors);
        int i = 0;
        while (i < this.diagramsCount) {
            this.maxLabels[i].setForeground(colors[i]);
            this.nameLabels[i].setForeground(colors[i]);
            this.barLabels[i].setForeground(colors[i]);
            this.valueLabels[i].setForeground(colors[i]);
            ++i;
        }
    }

    public void setValue(int[] values) {
        int[] gridValues = new int[this.diagramsCount];
        int i = 0;
        while (i < this.diagramsCount) {
            this.valueLabels[i].setText("" + values[i]);
            this.barLabels[i].setText("" + (int)((float)(values[i] - this.minValues[i]) / (float)this.maxValues[i] * 100.0f) + "%");
            gridValues[i] = (int)((float)(values[i] - this.minValues[i]) / (float)this.maxValues[i] * 100.0f);
            ++i;
        }
        this.grid.setValue(gridValues);
    }

    public void setValue(int value) {
        int[] gridValues = new int[this.diagramsCount];
        int i = 0;
        while (i < this.diagramsCount) {
            this.valueLabels[i].setText("" + value);
            this.barLabels[i].setText("" + (int)((float)(value - this.minValues[i]) / (float)this.maxValues[i] * 100.0f) + "%");
            gridValues[i] = (int)((float)(value - this.minValues[i]) / (float)this.maxValues[i] * 100.0f);
            ++i;
        }
        this.grid.setValue(gridValues);
    }

    protected void initDefaults() {
        this.setMaxDiagramsCount(5);
        this.colors = new Color[this.maxDiagramsCount];
        this.colors[0] = Color.green;
        this.colors[1] = new Color(255, 127, 127);
        this.colors[2] = Color.orange;
        this.colors[3] = Color.white;
        this.colors[4] = Color.lightGray;
        Font font = new Font("serif", 0, 10);
        this.maxLabels = new JLabel[this.diagramsCount];
        this.nameLabels = new JLabel[this.diagramsCount];
        this.barLabels = new JLabel[this.diagramsCount];
        this.valueLabels = new JLabel[this.diagramsCount];
        int i = 0;
        while (i < this.diagramsCount) {
            this.maxValues[i] = 100;
            this.minValues[i] = 0;
            this.maxLabels[i] = new JLabel();
            this.maxLabels[i].setBackground(Color.black);
            this.maxLabels[i].setFont(font);
            if (this.maxValues[i] != Integer.MAX_VALUE) {
                this.maxLabels[i].setText(this.maxValues[i] + "");
            } else {
                this.maxLabels[i].setText("Max");
            }
            this.nameLabels[i] = new JLabel();
            this.nameLabels[i].setText(" ");
            this.nameLabels[i].setBackground(Color.black);
            this.barLabels[i] = new JLabel();
            this.barLabels[i].setText("0%");
            this.barLabels[i].setBackground(Color.black);
            this.barLabels[i].setVerticalAlignment(1);
            this.barLabels[i].setFont(font);
            this.valueLabels[i] = new JLabel();
            this.valueLabels[i].setText("0");
            this.valueLabels[i].setBackground(Color.black);
            this.valueLabels[i].setVerticalAlignment(1);
            ++i;
        }
        this.grid = new MultiDiagramGridPane(this.minValues, this.maxValues, this.gridSize, this.gridSize, this.colors);
        this.setColors(this.colors);
    }

    public void reset() {
        this.grid.reset();
    }
}

