/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.diagram;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.gui.diagram.SingleDiagramPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LogoPanel
extends JPanel
implements Runnable {
    protected SingleDiagramPanel singleDiagramPanel = new SingleDiagramPanel(false);
    protected JLabel javaVersionLabel = new JLabel();
    protected JLabel osNameLabel = new JLabel();
    protected JLabel osVersionLabel = new JLabel();
    protected JLabel javaVMVersionLabel = new JLabel();
    protected JLabel javaVMVendorLabel = new JLabel();
    protected JLabel javaVMNameLabel = new JLabel();
    protected JLabel javaUserDirLabel = new JLabel();
    private boolean isStop = false;
    private Thread thread;
    private Runtime runtime = Runtime.getRuntime();

    public LogoPanel() {
        try {
            this.initMainPanel();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        float usage = 0.0f;
        float total = 0.0f;
        while (!this.isStop) {
            total = this.runtime.totalMemory();
            this.singleDiagramPanel.setMaxValue((int)(total / 1024.0f));
            usage = total - (float)this.runtime.freeMemory();
            this.singleDiagramPanel.setValue((int)(usage / 1024.0f));
            try {
                Thread.sleep(1500L);
                System.gc();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void stop() {
        this.isStop = true;
    }

    public void start() {
        this.thread = new Thread(this);
        this.isStop = false;
        this.thread.start();
    }

    private void initMainPanel() {
        this.javaVersionLabel.setText(SystemProperties.getProperty((String)"java.version"));
        this.osNameLabel.setText(SystemProperties.getProperty((String)"os.name"));
        this.osVersionLabel.setText(SystemProperties.getProperty((String)"os.version"));
        this.javaVMVersionLabel.setText(SystemProperties.getProperty((String)"java.vm.version"));
        this.javaVMVendorLabel.setText(SystemProperties.getProperty((String)"java.vm.vendor"));
        this.javaVMNameLabel.setText(SystemProperties.getProperty((String)"java.vm.name"));
        this.javaUserDirLabel.setText(SystemProperties.getProperty((String)"user.dir"));
        this.singleDiagramPanel.setNameLabel("Memory usage (Kbytes):");
        this.singleDiagramPanel.setMaxValue(100);
        JPanel diagramPanel = new JPanel();
        diagramPanel.setBorder(BorderFactory.createBevelBorder(0));
        diagramPanel.setLayout(new BorderLayout());
        diagramPanel.add((Component)this.singleDiagramPanel, "Center");
        JLabel ebServerText = new JLabel("SAP J2EE Engine Administrator Version 6.20");
        Font font = new Font("serif", 1, 16);
        ebServerText.setFont(font);
        JLabel javaVersionText = new JLabel("Java version: ");
        JLabel osNameText = new JLabel("Operating system: ");
        JLabel osVersionText = new JLabel("Operating system version: ");
        JLabel javaVMVersionText = new JLabel("Java virtual machine version:");
        JLabel javaVMVendorText = new JLabel("Java virtual machine vendor: ");
        JLabel javaVMNameText = new JLabel("Java virtual machine name: ");
        JLabel javaUserDirText = new JLabel("Java user directory: ");
        this.setLayout(new GridBagLayout());
        this.add((Component)ebServerText, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.add((Component)osNameText, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.osNameLabel, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)osVersionText, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.osVersionLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)javaVersionText, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.javaVersionLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)javaVMNameText, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.javaVMNameLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)javaVMVersionText, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.javaVMVersionLabel, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)javaVMVendorText, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.javaVMVendorLabel, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)javaUserDirText, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.javaUserDirLabel, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 10, 5), 0, 0));
        this.add((Component)diagramPanel, new GridBagConstraints(0, 8, 2, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
    }
}

