/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.diagram;

import com.sap.engine.gui.diagram.DoubleDiagramGridPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DoubleDiagramPanel
extends JPanel {
    protected int maxValue1;
    protected int maxValue2;
    protected int minValue1;
    protected int minValue2;
    protected Color color1;
    protected Color color2;
    protected int step = 5;
    protected int gridSize = 20;
    protected boolean isProgressBar = true;
    protected DoubleDiagramGridPane grid;
    protected JLabel maxLabel1;
    protected JLabel maxLabel2;
    protected JLabel barLabel1;
    protected JLabel barLabel2;
    protected JLabel valueLabel1;
    protected JLabel valueLabel2;
    protected JLabel nameLabel1;
    protected JLabel nameLabel2;

    public DoubleDiagramPanel(boolean isProgress) {
        this.isProgressBar = isProgress;
        this.initDefaults();
        this.initView();
    }

    protected void initView() {
        this.setBackground(Color.black);
        this.setLayout(new GridBagLayout());
        JPanel labelsPanel = new JPanel();
        labelsPanel.setLayout(new GridBagLayout());
        labelsPanel.setBackground(Color.black);
        labelsPanel.add((Component)this.nameLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 5, 0, 15), 0, 0));
        labelsPanel.add((Component)this.valueLabel1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 25), 0, 0));
        labelsPanel.add((Component)this.nameLabel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 15), 0, 0));
        labelsPanel.add((Component)this.valueLabel2, new GridBagConstraints(3, 0, 1, 1, 0.1, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        labelsPanel.add((Component)this.barLabel1, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 3), 0, 0));
        labelsPanel.add((Component)this.barLabel2, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.grid, new GridBagConstraints(1, 0, 2, 2, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.maxLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.maxLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)labelsPanel, new GridBagConstraints(1, 2, 4, 1, 1.0, 0.0, 12, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public void setMaxValues(int maxValue1, int maxValue2) {
        this.maxValue1 = maxValue1;
        this.maxValue2 = maxValue2;
        this.maxLabel2.setText(maxValue2 + "");
        if (maxValue1 != Integer.MAX_VALUE) {
            this.maxLabel1.setText(maxValue1 + "");
        } else {
            this.maxLabel1.setText("Max");
        }
    }

    public void setMinValues(int minValue1, int minValue2) {
        this.minValue1 = minValue1;
        this.minValue2 = minValue2;
    }

    public void setNameLabels(String name1, String name2) {
        this.nameLabel1.setText(name1);
        this.nameLabel2.setText(name2);
    }

    public void setColors(Color color1, Color color2) {
        this.color1 = color1;
        this.color2 = color2;
        this.maxLabel1.setForeground(color1);
        this.maxLabel2.setForeground(color2);
        this.nameLabel1.setForeground(color1);
        this.nameLabel2.setForeground(color2);
        this.barLabel1.setForeground(color1);
        this.barLabel2.setForeground(color2);
        this.valueLabel1.setForeground(color1);
        this.valueLabel2.setForeground(color2);
        this.grid.setColor(color1, color2);
    }

    public void setValue(int value1, int value2) {
        this.valueLabel1.setText("" + value1);
        this.valueLabel2.setText("" + value2);
        this.barLabel1.setText("" + (int)((float)(value1 - this.minValue1) / (float)this.maxValue1 * 100.0f) + "%");
        this.barLabel2.setText("" + (int)((float)(value2 - this.minValue2) / (float)this.maxValue2 * 100.0f) + "%");
        this.grid.setValue((int)((float)(value1 - this.minValue1) / (float)this.maxValue1 * 100.0f), (int)((float)(value2 - this.minValue2) / (float)this.maxValue2 * 100.0f));
    }

    protected void initDefaults() {
        this.maxValue1 = 100;
        this.maxValue2 = 100;
        this.minValue1 = 0;
        this.minValue2 = 0;
        this.color1 = Color.green;
        this.color2 = Color.green;
        Font font = new Font("serif", 0, 10);
        this.maxLabel1 = new JLabel();
        this.maxLabel2 = new JLabel();
        if (this.maxValue1 != Integer.MAX_VALUE) {
            this.maxLabel1.setText(this.maxValue1 + "");
        } else {
            this.maxLabel1.setText("Max");
        }
        if (this.maxValue2 != Integer.MAX_VALUE) {
            this.maxLabel2.setText(this.maxValue2 + "");
        } else {
            this.maxLabel2.setText("Max");
        }
        this.maxLabel1.setBackground(Color.black);
        this.maxLabel2.setBackground(Color.black);
        this.maxLabel1.setFont(font);
        this.maxLabel2.setFont(font);
        this.nameLabel1 = new JLabel(" ");
        this.nameLabel2 = new JLabel(" ");
        this.nameLabel1.setBackground(Color.black);
        this.nameLabel2.setBackground(Color.black);
        this.barLabel1 = new JLabel();
        this.barLabel2 = new JLabel();
        this.barLabel1.setText("0%");
        this.barLabel2.setText("0%");
        this.barLabel1.setBackground(Color.black);
        this.barLabel2.setBackground(Color.black);
        this.barLabel1.setVerticalAlignment(1);
        this.barLabel2.setVerticalAlignment(1);
        this.barLabel1.setPreferredSize(new Dimension(17, 10));
        this.barLabel2.setPreferredSize(new Dimension(17, 10));
        this.barLabel1.setFont(font);
        this.barLabel2.setFont(font);
        this.barLabel1.setPreferredSize(new Dimension(25, 30));
        this.barLabel2.setPreferredSize(new Dimension(25, 30));
        this.valueLabel1 = new JLabel();
        this.valueLabel2 = new JLabel();
        this.valueLabel1.setPreferredSize(new Dimension(25, 30));
        this.valueLabel2.setPreferredSize(new Dimension(25, 30));
        this.valueLabel1.setText("0");
        this.valueLabel2.setText("0");
        this.valueLabel1.setBackground(Color.black);
        this.valueLabel2.setBackground(Color.black);
        this.valueLabel1.setVerticalAlignment(1);
        this.valueLabel2.setVerticalAlignment(1);
        this.grid = new DoubleDiagramGridPane(this.minValue1, this.minValue2, this.maxValue1, this.maxValue2, this.gridSize, this.gridSize, this.color1, this.color2);
    }

    public void reset() {
        this.grid.reset();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        ((Component)frame).setSize(300, 300);
        Color c1 = new Color(0, 255, 0);
        Color c2 = new Color(255, 127, 127);
        DoubleDiagramPanel panel = new DoubleDiagramPanel(true);
        panel.setColors(c1, c2);
        panel.setNameLabels("Barbossa", "Quel");
        panel.setMaxValues(100, 300);
        frame.getContentPane().add(panel);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.show();
        Thread thread = Thread.currentThread();
        boolean i = false;
        while (true) {
            int value1 = 50;
            int value2 = 60;
            panel.setValue(value1, value2);
            try {
                Thread.sleep(100L);
            }
            catch (Exception ex) {
            }
        }
    }
}

