/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.diagram;

import com.sap.engine.gui.diagram.DiagramBuffer;
import com.sap.engine.gui.diagram.DiagramIterator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class DoubleDiagramGridPane
extends JPanel {
    public static final int MAX_SCREEN_SIZE = 1024;
    protected int maxValue1;
    protected int maxValue2;
    protected int minValue1;
    protected int minValue2;
    protected Color color1;
    protected Color color2;
    protected Color gridColor;
    protected int gridSizeX;
    protected int gridSizeY;
    private DiagramBuffer data1;
    private DiagramBuffer data2;
    private int step;
    private int maxCount;
    private Dimension dim;

    public DoubleDiagramGridPane(int minValue1, int minValue2, int maxValue1, int maxValue2, int gridSizeX, int gridSizeY, Color color1, Color color2) {
        this(minValue1, minValue2, maxValue1, maxValue2, gridSizeX, gridSizeY, color1, color2, new Color(0, 127, 0));
    }

    public DoubleDiagramGridPane(int minValue1, int minValue2, int maxValue1, int maxValue2, int gridSizeX, int gridSizeY, Color color1, Color color2, Color gridColor) {
        this.maxValue1 = maxValue1;
        this.maxValue2 = maxValue2;
        this.minValue1 = minValue1;
        this.minValue2 = minValue2;
        this.color1 = color1;
        this.color2 = color2;
        this.gridColor = gridColor;
        this.gridSizeX = gridSizeX;
        this.gridSizeY = gridSizeY;
        this.setStep(3);
    }

    public void setValue(int value1, int value2) {
        this.data1.add(value1 - this.minValue1);
        this.data2.add(value2 - this.minValue2);
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
    }

    public void setColor(Color color1, Color color2) {
        this.color1 = color1;
        this.color2 = color2;
    }

    public void setgridSizeX(int gridSizeX) {
        this.gridSizeX = gridSizeX;
    }

    public void setgridSizeY(int gridSizeY) {
        this.gridSizeY = gridSizeY;
    }

    public void setStep(int step) {
        this.step = step;
        this.maxCount = 1024 / step;
        this.data1 = new DiagramBuffer(this.maxCount);
        this.data2 = new DiagramBuffer(this.maxCount);
    }

    public void setMaxValue(int maxValue1, int maxValue2) {
        this.maxValue1 = maxValue1;
        this.maxValue2 = maxValue2;
    }

    public void setMinValue(int minValue1, int minValue2) {
        this.minValue1 = minValue1;
        this.minValue2 = minValue2;
    }

    protected void drowHorLine(Graphics g, int width, int height) {
        int i = height - 1;
        while (i > -this.gridSizeY) {
            g.drawLine(0, i, width, i);
            i -= this.gridSizeY;
        }
    }

    protected void drowVertLine(Graphics g, int width, int height) {
        int i = width - 1;
        while (i > -this.gridSizeX) {
            g.drawLine(i, 0, i, height);
            i -= this.gridSizeX;
        }
    }

    protected void drowPoints(Graphics g, int width, int height) {
        int x = width;
        int x1 = width;
        int y = height;
        int y1 = height;
        float range1 = 0.0f;
        float range2 = 0.0f;
        range1 = (float)height / (float)(this.maxValue1 - this.minValue1);
        range2 = (float)height / (float)(this.maxValue2 - this.minValue2);
        g.setColor(this.color1);
        DiagramIterator iterator1 = this.data1.getIterator();
        x = width;
        if (!iterator1.hasMore()) {
            return;
        }
        y = (int)((float)height - (float)iterator1.next() * range1);
        int i = width - this.step;
        while (iterator1.hasMore() && i > -this.step) {
            y1 = (int)((float)height - (float)iterator1.next() * range1);
            g.drawLine(i, y1, x, y);
            x = i;
            y = y1;
            i -= this.step;
        }
        g.setColor(this.color2);
        DiagramIterator iterator2 = this.data2.getIterator();
        x = width;
        if (!iterator2.hasMore()) {
            return;
        }
        y = (int)((float)height - (float)iterator2.next() * range2);
        int i2 = width - this.step;
        while (iterator2.hasMore() && i2 > -this.step) {
            y1 = (int)((float)height - (float)iterator2.next() * range2);
            g.drawLine(i2, y1, x, y);
            x = i2;
            y = y1;
            i2 -= this.step;
        }
    }

    public void reset() {
        this.data1.reset();
        this.data2.reset();
    }

    public void paint(Graphics g) {
        this.dim = this.getSize();
        g.setColor(Color.black);
        g.fillRect(0, 0, this.dim.width, this.dim.height);
        g.setColor(this.gridColor);
        this.drowHorLine(g, this.dim.width, this.dim.height);
        this.drowVertLine(g, this.dim.width, this.dim.height);
        this.drowPoints(g, this.dim.width, this.dim.height);
    }
}

