/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.connect;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class ProxyDialog
extends JDialog
implements ActionListener,
KeyListener {
    private final JPanel proxyPanel = new JPanel();
    private final JPanel buttonsPanel = new JPanel();
    private final JTextField hostField = new JTextField(20);
    private final JTextField portField = new JTextField(20);
    private final JLabel hostLabel = new JLabel("Host:");
    private final JLabel portLabel = new JLabel("Port:");
    private final JButton okButton = new JButton();
    private boolean isOK = false;
    private boolean isEditable = true;
    private JButton cancelButton;

    public ProxyDialog(Frame frame) {
        this(frame, true);
    }

    public ProxyDialog(Frame frame, boolean isEditable) {
        super(frame, "Proxy", true);
        this.isEditable = isEditable;
        this.okButton.setText("OK");
        this.okButton.addActionListener(this);
        this.buttonsPanel.setLayout(new FlowLayout());
        this.buttonsPanel.add(this.okButton);
        if (isEditable) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(this);
            this.buttonsPanel.add(this.cancelButton);
        } else {
            this.hostField.setEditable(false);
            this.portField.setEditable(false);
        }
        this.proxyPanel.setLayout(new GridBagLayout());
        this.proxyPanel.add((Component)this.hostLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.proxyPanel.add((Component)this.hostField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.proxyPanel.add((Component)this.portLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.proxyPanel.add((Component)this.portField, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.proxyPanel, "Center");
        this.getContentPane().add((Component)this.buttonsPanel, "South");
        this.addKeyListener(this);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    public boolean showDialog() {
        ((Component)this).setVisible(true);
        return this.isOK;
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.okButton) {
            this.okAction();
        } else if (ae.getSource() == this.cancelButton) {
            this.cancelAction();
        }
    }

    public String getPort() {
        return this.portField.getText();
    }

    public void setPort(String port) {
        this.portField.setText(port);
    }

    public String getHost() {
        return this.hostField.getText();
    }

    public void setHost(String host) {
        this.hostField.setText(host);
    }

    private void okAction() {
        if (!this.isEditable) {
            this.cancelAction();
            return;
        }
        if (this.hostField.getText().trim().equals("") || this.portField.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(this, "You must enter host and port !", "Error", 2);
            return;
        }
        try {
            Integer.parseInt(this.portField.getText().trim());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Invalid port number !", "Error", 2);
            return;
        }
        ((Component)this).setVisible(false);
        this.isOK = true;
    }

    private void cancelAction() {
        this.isOK = false;
        ((Component)this).setVisible(false);
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 10: {
                this.okAction();
                break;
            }
            case 27: {
                this.cancelAction();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

