/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.connect;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.gui.connect.BasicSettings;
import com.sap.engine.gui.connect.ImageHolder;
import com.sap.engine.gui.connect.ProxyDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class LoginDialog
extends CEscapeDialog
implements ActionListener,
FocusListener,
ItemListener {
    protected static final String NONE_LABEL = "No Layer";
    public static final String NONE_LAYER = "None";
    protected static final String HTTP_LABEL = "HTTP Tunneling";
    public static final String HTTP_LAYER = "httptunneling";
    protected static final String SSL_LABEL = "SSL";
    public static final String SSL_LAYER = "ssl";
    public static final String HTTPS_LABEL = "HTTPS";
    public static final String HTTPS_LAYER = "https";
    protected final int INITIAL_PROPDLG_WIDTH = 450;
    protected final int INITIAL_PROPDLG_HEIGHT = 225;
    protected final String OK_CMD = "ok cmd";
    protected final String CANCEL_CMD = "cancel cmd";
    protected final String PROXY_SETTINGS_CMD = "proxy settings cmd";
    protected JFrame mainFrame;
    protected JPanel mainPanel;
    protected JLabel userLabel;
    protected JTextField userField;
    protected JLabel passwordLabel;
    protected JPasswordField passwordField;
    protected JLabel hostLabel;
    protected JTextField hostField;
    protected JLabel portLabel;
    protected JTextField portField;
    protected JPanel logoPanel;
    protected JLabel logoLabel;
    protected JButton connectButton;
    protected JButton cancelButton;
    protected JPanel transportsPanel;
    protected JComboBox transportsBox;
    protected JButton transportsButton;
    protected ProxyDialog proxyDialog;
    protected boolean canceled = true;
    protected String proxyHost = "";
    protected String proxyPort = "";
    private int loginPort;
    private int httpPort;
    private int httpsPort;
    private int sslPort;

    public LoginDialog(JFrame frame, String userName, String host, int port, String proxyHost, String proxyPort, int layer) {
        super(frame, BasicSettings.getResourceString("LogTitle", "Login"), true);
        this.mainFrame = frame;
        this.initDialog(userName, host, port, proxyHost, proxyPort, layer);
        this.pack();
    }

    public LoginDialog(JFrame frame, String userName, String loginHost, int loginPort, String httpHost, int httpPort, int sslPort, int httpsPort, int layer) {
        this(frame, userName, loginHost, loginPort, httpHost, String.valueOf(httpPort), layer);
        this.loginPort = loginPort;
        this.httpPort = httpPort;
        this.sslPort = sslPort;
        this.httpsPort = httpsPort;
        if (this.transportsBox.getSelectedIndex() == layer) {
            this.transportsBox.setSelectedIndex(-1);
            this.transportsBox.setSelectedIndex(layer);
        }
    }

    protected void initDialog(String user, String host, int port, String proxyHost, String proxyPort, int layer) {
        this.proxyDialog = new ProxyDialog(this.mainFrame);
        this.proxyDialog.setHost(proxyHost);
        this.proxyDialog.setPort(proxyPort);
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.setPreferredSize(new Dimension(450, 225));
        this.userLabel = new JLabel(BasicSettings.getResourceString("UserNameLabel", "User Name:"));
        this.mainPanel.add((Component)this.userLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.userField = new JTextField(user);
        this.userField.addFocusListener(this);
        this.userField.setNextFocusableComponent(this.passwordField);
        this.mainPanel.add((Component)this.userField, new GridBagConstraints(1, 1, 3, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.passwordLabel = new JLabel(BasicSettings.getResourceString("PasswordLabel", "Password:"));
        this.mainPanel.add((Component)this.passwordLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.passwordField = new JPasswordField();
        this.passwordField.addFocusListener(this);
        this.passwordField.setNextFocusableComponent(this.hostField);
        this.mainPanel.add((Component)this.passwordField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.hostLabel = new JLabel(BasicSettings.getResourceString("HostLabel", "Host:"));
        this.mainPanel.add((Component)this.hostLabel, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        if (host == null || host.trim().length() == 0) {
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                host = "";
            }
        }
        this.hostField = new JTextField(host);
        this.hostField.addFocusListener(this);
        this.hostField.setNextFocusableComponent(this.portField);
        this.mainPanel.add((Component)this.hostField, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.portLabel = new JLabel(BasicSettings.getResourceString("PortLabel", "Port:"));
        this.mainPanel.add((Component)this.portLabel, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.portField = new JTextField(Integer.toString(port));
        this.portField.addFocusListener(this);
        this.portField.setNextFocusableComponent(this.connectButton);
        this.mainPanel.add((Component)this.portField, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.logoPanel = new JPanel();
        this.logoLabel = new JLabel(ImageHolder.bigLogo);
        this.logoPanel.add((Component)this.logoLabel, "Center");
        this.logoPanel.setPreferredSize(new Dimension(180, 60));
        this.logoPanel.setBackground(Color.white);
        this.logoPanel.setMinimumSize(new Dimension(180, 60));
        this.logoPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.mainPanel.add((Component)this.logoPanel, new GridBagConstraints(4, 1, 1, 2, 0.0, 0.0, 10, 0, new Insets(5, 20, 5, 20), 0, 0));
        this.connectButton = new JButton(BasicSettings.getResourceString("ConnectButton", "Connect"));
        this.connectButton.setMnemonic(BasicSettings.getResourceString("ConnectButtonMnemonic", "c").charAt(0));
        this.connectButton.setActionCommand("ok cmd");
        this.connectButton.addActionListener(this);
        this.connectButton.setNextFocusableComponent(this.cancelButton);
        this.mainPanel.add((Component)this.connectButton, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 20, 5, 20), 0, 0));
        this.cancelButton = new JButton(BasicSettings.getResourceString("CancelButton", "Cancel"));
        this.cancelButton.setMnemonic(BasicSettings.getResourceString("CancelButtonMnemonic", "a").charAt(0));
        this.cancelButton.setActionCommand("cancel cmd");
        this.cancelButton.addActionListener(this);
        this.mainPanel.add((Component)this.cancelButton, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 20, 5, 20), 0, 0));
        this.transportsPanel = new JPanel(new BorderLayout(5, 5));
        this.transportsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Transport Layers "), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        this.transportsButton = new JButton(BasicSettings.getResourceString("SettingsButton", "Settings"));
        this.transportsButton.setMnemonic(BasicSettings.getResourceString("SettingsButtonMnemonic", "s").charAt(0));
        this.transportsButton.setMnemonic('s');
        this.transportsButton.addActionListener(this);
        this.transportsPanel.add((Component)this.transportsButton, "East");
        this.transportsBox = new JComboBox();
        this.transportsBox.addItem(NONE_LABEL);
        this.transportsBox.addItem(HTTP_LABEL);
        this.transportsBox.addItem(SSL_LABEL);
        this.transportsBox.addItem(HTTPS_LABEL);
        this.transportsBox.addItemListener(this);
        this.transportsBox.setSelectedIndex(-1);
        if (layer < 0 || layer > 3) {
            layer = 0;
        }
        this.transportsBox.setSelectedIndex(layer);
        this.transportsPanel.add((Component)this.transportsBox, "Center");
        this.mainPanel.add((Component)this.transportsPanel, new GridBagConstraints(0, 5, 5, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.portField.setText(Integer.toString(port));
        this.getContentPane().add(this.mainPanel);
        this.userField.requestFocus();
        if (this.mainFrame == null) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)this).setLocation(screenSize.width / 2 - 225, screenSize.height / 2 - 112);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                LoginDialog.this.cancelAction();
            }
        });
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public String getUserName() {
        return this.userField.getText();
    }

    public String getPassword() {
        return new String(this.passwordField.getPassword());
    }

    public String getHost() {
        return this.hostField.getText();
    }

    public int getPort() {
        return Integer.parseInt(this.portField.getText().trim());
    }

    public String getLayer() {
        int index = this.transportsBox.getSelectedIndex();
        switch (index) {
            case 0: {
                return NONE_LAYER;
            }
            case 1: {
                return HTTP_LAYER;
            }
            case 2: {
                return SSL_LAYER;
            }
            case 3: {
                return HTTPS_LAYER;
            }
        }
        return NONE_LAYER;
    }

    public int getLayerAsNumber() {
        return this.transportsBox.getSelectedIndex();
    }

    public Properties getBrokerProperties() {
        Properties result = new Properties();
        ((Hashtable)result).put("Host", this.hostField.getText());
        ((Hashtable)result).put("Port", this.portField.getText());
        ((Hashtable)result).put("TransportLayerQueue", this.getLayer());
        ((Hashtable)result).put("HTTP_Host", this.proxyHost);
        ((Hashtable)result).put("HTTP_Port", this.proxyPort);
        return result;
    }

    protected void performEnterAction(KeyEvent e) {
        this.connectAction();
    }

    public void focusGained(FocusEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JTextField) {
            ((JTextField)obj).selectAll();
        } else if (obj instanceof JPasswordField) {
            ((JPasswordField)obj).selectAll();
        }
    }

    public void focusLost(FocusEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JTextField) {
            ((JTextField)obj).select(0, 0);
        } else if (obj instanceof JPasswordField) {
            ((JPasswordField)obj).select(0, 0);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("ok cmd")) {
            this.connectAction();
        } else if (cmd.equals("cancel cmd")) {
            this.cancelAction();
        } else if (cmd.equals("proxy settings cmd")) {
            this.proxySettingsAction();
        }
    }

    private void connectAction() {
        this.canceled = false;
        try {
            if (this.userField.getText().equals("")) {
                JOptionPane.showMessageDialog(this.mainFrame, BasicSettings.getResourceString("InvalidNameMsg", "You must enter valid user name !"), BasicSettings.getResourceString("ErrorMsg", "Error"), 2);
                return;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.mainFrame, BasicSettings.getResourceString("InvalidNameMsg", "You must enter valid user name !"), BasicSettings.getResourceString("ErrorMsg", "Error"), 2);
            return;
        }
        try {
            Integer.parseInt(this.portField.getText().trim());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.mainFrame, BasicSettings.getResourceString("InvalidPortMsg", "Invalid port number !"), BasicSettings.getResourceString("ErrorMsg", "Error"), 2);
            return;
        }
        ((Component)this).setVisible(false);
    }

    private void cancelAction() {
        ((Component)this).setVisible(false);
    }

    public void proxySettingsAction() {
        if (this.proxyDialog.showDialog()) {
            this.proxyHost = this.proxyDialog.getHost();
            this.proxyPort = this.proxyDialog.getPort();
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        Object source = ie.getSource();
        if (ie.getSource() == this.transportsBox) {
            int selected = ((JComboBox)source).getSelectedIndex();
            switch (selected) {
                case 0: {
                    this.transportsButton.setEnabled(false);
                    this.portField.setText(String.valueOf(this.loginPort));
                    break;
                }
                case 1: {
                    this.transportsButton.setEnabled(true);
                    this.transportsButton.setActionCommand("proxy settings cmd");
                    this.portField.setText(String.valueOf(this.httpPort));
                    break;
                }
                case 2: {
                    this.transportsButton.setEnabled(false);
                    this.portField.setText(String.valueOf(this.sslPort));
                    break;
                }
                case 3: {
                    this.transportsButton.setEnabled(true);
                    this.transportsButton.setActionCommand("proxy settings cmd");
                    this.portField.setText(String.valueOf(this.httpsPort));
                    break;
                }
            }
        }
    }
}

