/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.connect;

import com.sap.engine.gui.connect.BasicSettings;
import com.sap.engine.gui.connect.ImageHolder;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JSeparator;
import javax.swing.JToolBar;

public class BasicToolBar
extends JToolBar {
    JButton connectBtn = new JButton();
    JSeparator separator = new JSeparator();
    ActionListener action;
    Vector levelOne;
    Vector levelTwo;

    public BasicToolBar(ActionListener action) {
        this.action = action;
        this.initView();
        this.initActions();
    }

    protected void initView() {
        this.connectBtn.setIcon(ImageHolder.connectIcon);
        this.connectBtn.setPreferredSize(new Dimension(24, 24));
        this.connectBtn.setToolTipText(BasicSettings.getResourceString("connect", "Connect"));
        this.add(this.connectBtn);
        this.separator.setVisible(false);
    }

    private void initActions() {
        this.connectBtn.setActionCommand("MN_CONNECT_CMD");
        this.connectBtn.addActionListener(this.action);
    }

    public boolean addVector(Vector target) {
        if (target == null) {
            return false;
        }
        int i = 0;
        while (i < target.size()) {
            if (target.elementAt(i) == null) {
                if (i < target.size() - 1) {
                    this.addSeparator();
                }
            } else {
                this.add((JButton)target.elementAt(i));
            }
            ++i;
        }
        this.invalidate();
        this.validate();
        this.repaint();
        return !target.isEmpty();
    }

    public void removeVector() {
        this.removeAll();
        this.levelOne = null;
        this.levelTwo = null;
        this.add(this.connectBtn);
        this.separator.setVisible(false);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void addVectorLevelOne(Vector target) {
        this.removeVector();
        this.levelOne = target;
        if (this.levelOne != null) {
            this.addVector(this.levelOne);
        }
    }

    public void addVectorLevelTwo(Vector target) {
        this.levelTwo = target;
        this.addVectorLevelOne(this.levelOne);
        if (this.levelTwo != null) {
            this.addVector(this.levelTwo);
        }
    }

    public void addArrayLevelTwo(JButton[] target) {
        this.addVectorLevelOne(this.levelOne);
        if (target != null) {
            this.addSeparator();
            int i = 0;
            while (i < target.length) {
                if (target[i] == null) {
                    if (i < target.length - 1) {
                        this.addSeparator();
                    }
                } else {
                    this.add(target[i]);
                }
                ++i;
            }
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public void switchConnect(boolean isConnect) {
        if (isConnect) {
            this.connectBtn.setIcon(ImageHolder.disconnectIcon);
            this.connectBtn.setToolTipText(BasicSettings.getResourceString("disconnect", "Disconnect"));
        } else {
            this.connectBtn.setIcon(ImageHolder.connectIcon);
            this.connectBtn.setToolTipText(BasicSettings.getResourceString("connect", "Connect"));
        }
    }

    public void setConnectProgress(boolean progress) {
        this.connectBtn.setEnabled(!progress);
    }
}

