/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.connect;

import com.sap.engine.gui.lf.LookAndFeelFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class BasicOptions
extends Properties {
    public static int INITIAL_WIDTH = 510;
    public static int INITIAL_HEIGHT = 515;
    public static int MAX_RECONNECT = 4;
    private String fileName;
    private String optionsName = "Basic Frame Options";
    protected LookAndFeelFactory lfFactory = new LookAndFeelFactory();

    public BasicOptions(String fileName, String optionsName) {
        this.fileName = fileName;
        this.optionsName = optionsName;
        try {
            FileInputStream propStream = new FileInputStream(fileName);
            this.load(propStream);
            propStream.close();
            this.lfFactory.load(this);
        }
        catch (IOException ex) {
            this.initDefaultProperties();
        }
    }

    public void updateFrameLocation(Frame frame) {
        try {
            int locatX = Integer.parseInt(this.getProperty("FrameLocationX"));
            int locatY = Integer.parseInt(this.getProperty("FrameLocationY"));
            int width = Integer.parseInt(this.getProperty("FrameWidth"));
            int height = Integer.parseInt(this.getProperty("FrameHeight"));
            ((Component)frame).setLocation(locatX, locatY);
            ((Component)frame).setSize(width, height);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFrameProperties(Frame frame) {
        int locatX = frame.getLocation().x;
        int locatY = frame.getLocation().y;
        int width = frame.getSize().width;
        int height = frame.getSize().height;
        ((Hashtable)this).put("FrameLocationX", String.valueOf(locatX));
        ((Hashtable)this).put("FrameLocationY", String.valueOf(locatY));
        ((Hashtable)this).put("FrameWidth", String.valueOf(width));
        ((Hashtable)this).put("FrameHeight", String.valueOf(height));
    }

    public String getLookAndFeel() {
        return this.getProperty("LookAndFeel");
    }

    public void setLookAndFeel(String landf) {
        ((Hashtable)this).put("LookAndFeel", landf);
    }

    public void saveProperties() {
        try {
            this.lfFactory.store(this);
            FileOutputStream propStream = new FileOutputStream(this.fileName);
            this.store(propStream, this.optionsName);
            propStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getReconnectCount() {
        try {
            return Integer.parseInt(this.getProperty("ReconnectCount"));
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public void setReconnectCount(int count) {
        ((Hashtable)this).put("ReconnectCount", String.valueOf(count));
    }

    public int getMaxReconnectCount() {
        try {
            return Integer.parseInt(this.getProperty("MaxReconnectCount"));
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public void setMaxReconnectCount(int count) {
        ((Hashtable)this).put("MaxReconnectCount", String.valueOf(MAX_RECONNECT));
    }

    public String getUserName(int i) {
        String res = this.getProperty("Name" + String.valueOf(i));
        if (res == null) {
            res = "";
        }
        return res;
    }

    public String getHostName(int i) {
        String res = this.getProperty("Host" + String.valueOf(i));
        if (res == null) {
            res = "";
        }
        return res;
    }

    public int getPortNumber(int i) {
        try {
            return Integer.parseInt(this.getProperty("Port" + String.valueOf(i)));
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public int getLayer(int i) {
        String res = this.getProperty("TransportLayerQueue" + String.valueOf(i));
        if (res == null) {
            return 0;
        }
        if (res.equals("httptunneling")) {
            return 1;
        }
        if (res.equals("ssl")) {
            return 2;
        }
        return 0;
    }

    public String getHTTPHost(int i) {
        String res = this.getProperty("HTTP_Host" + String.valueOf(i));
        if (res == null) {
            res = "";
        }
        return res;
    }

    public String getHTTPPort(int i) {
        String res = this.getProperty("HTTP_Port" + String.valueOf(i));
        if (res == null) {
            res = "";
        }
        return res;
    }

    public void addReconnectInfo(String userName, String hostName, int port, Properties transports) {
        int index = this.getReconnectCount();
        int i = 0;
        while (i < this.getReconnectCount()) {
            if (this.getUserName(i).equals(userName) && this.getHostName(i).equals(hostName) && this.getPortNumber(i) == port) {
                index = i;
            }
            ++i;
        }
        int i2 = index;
        while (i2 > 0) {
            if (i2 < MAX_RECONNECT) {
                ((Hashtable)this).put("Name" + String.valueOf(i2), this.getUserName(i2 - 1));
                ((Hashtable)this).put("Host" + String.valueOf(i2), this.getHostName(i2 - 1));
                ((Hashtable)this).put("Port" + String.valueOf(i2), String.valueOf(this.getPortNumber(i2 - 1)));
                ((Hashtable)this).put("TransportLayerQueue" + String.valueOf(i2), String.valueOf(this.getLayer(i2 - 1)));
                ((Hashtable)this).put("HTTP_Host" + String.valueOf(i2), this.getHTTPHost(i2 - 1));
                ((Hashtable)this).put("HTTP_Port" + String.valueOf(i2), this.getHTTPPort(i2 - 1));
            }
            --i2;
        }
        ((Hashtable)this).put("Name0", userName);
        ((Hashtable)this).put("Host0", hostName);
        ((Hashtable)this).put("Port0", String.valueOf(port));
        ((Hashtable)this).put("TransportLayerQueue0", transports.getProperty("TransportLayerQueue"));
        ((Hashtable)this).put("HTTP_Host0", transports.getProperty("HTTP_Host"));
        ((Hashtable)this).put("HTTP_Port0", transports.getProperty("HTTP_Port"));
        ((Hashtable)this).put("SSL_CertFile0", transports.getProperty("SSL_CertFile"));
        ((Hashtable)this).put("SSL_KeyFile0", transports.getProperty("SSL_KeyFile"));
        if (index == this.getReconnectCount() && this.getReconnectCount() < MAX_RECONNECT) {
            ((Hashtable)this).put("ReconnectCount", String.valueOf(this.getReconnectCount() + 1));
        }
    }

    public LookAndFeelFactory getLookAndFeelFactory() {
        return this.lfFactory;
    }

    public void setLookAndFeelFactory(LookAndFeelFactory factory) {
        this.lfFactory = factory;
        this.saveProperties();
    }

    private void initDefaultProperties() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int locatX = screenSize.width / 2 - INITIAL_WIDTH / 2;
        int locatY = screenSize.height / 2 - INITIAL_HEIGHT / 2;
        ((Hashtable)this).put("Name0", "Administrator");
        ((Hashtable)this).put("Host0", "localhost");
        ((Hashtable)this).put("Port0", "3011");
        ((Hashtable)this).put("FrameLocationX", String.valueOf(locatX));
        ((Hashtable)this).put("FrameLocationY", String.valueOf(locatY));
        ((Hashtable)this).put("FrameWidth", String.valueOf(INITIAL_WIDTH));
        ((Hashtable)this).put("FrameHeight", String.valueOf(INITIAL_HEIGHT));
        ((Hashtable)this).put("LookAndFeel", "com.inqmy.lf.InQMyLookAndFeel");
        ((Hashtable)this).put("ReconnectCount", "1");
        ((Hashtable)this).put("MaxReconnectCount", "4");
        ((Hashtable)this).put("TransportLayerQueue", "None");
        this.saveProperties();
    }
}

