/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.connect;

import com.sap.engine.gui.connect.BasicOptions;
import com.sap.engine.gui.connect.BasicSettings;
import com.sap.engine.gui.lf.LookAndFeelFactory;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class BasicMenuBar
extends JMenuBar {
    public static final String MN_CONNECT_CMD = "MN_CONNECT_CMD";
    public static final String MN_RECONNECT_CMD = "MN_RECONNECT_CMD";
    public static final String MN_EXIT_CMD = "MN_EXIT_CMD";
    public static final String HL_HELP_CMD = "HL_HELP_CMD";
    public static final String HL_ABOUT_CMD = "HL_ABOUT_CMD";
    public static final String MN_COUNT_CMD = "MN_COUNT_CMD";
    public static final String LF_EXTERN_CMD = "LF_EXTERN_CMD";
    public static final String LF = "LF_";
    protected ActionListener action;
    public static int maxReconnectCount = BasicOptions.MAX_RECONNECT;
    JMenu mainMenu = new JMenu();
    JMenu reconnectMenu = new JMenu();
    JMenu look_feel_Menu = new JMenu();
    JMenu helpMenu = new JMenu();
    JMenuItem connectMenuItem = new JMenuItem();
    JMenuItem[] reconnectItems = new JMenuItem[maxReconnectCount];
    JMenuItem exitMenuItem = new JMenuItem();
    JMenuItem aboutMenuItem = new JMenuItem();
    JMenuItem hlpMenuItem = new JMenuItem();
    JMenuItem externalMenuItem = new JMenuItem();
    JSeparator theSeparator = new JSeparator();
    ButtonGroup group = new ButtonGroup();
    JRadioButtonMenuItem currentLF;
    JMenu jumpMenu;

    public BasicMenuBar(ActionListener action) {
        this.action = action;
        this.initView();
        this.initActions();
    }

    protected void initView() {
        this.theSeparator.setVisible(false);
        this.mainMenu.setText(BasicSettings.getResourceString("main", "Main"));
        this.mainMenu.setMnemonic('M');
        this.connectMenuItem.setText(BasicSettings.getResourceString("connect", "Connect"));
        this.connectMenuItem.setMnemonic('C');
        this.look_feel_Menu.setText(BasicSettings.getResourceString("look_feel", "Look&Feel"));
        this.look_feel_Menu.setMnemonic('L');
        this.externalMenuItem.setText(BasicSettings.getResourceString("external_look_feel", "External Look and Feel"));
        this.externalMenuItem.setMnemonic('E');
        this.reconnectMenu.setText(BasicSettings.getResourceString("reconnect", "Reconnect"));
        this.reconnectMenu.setMnemonic('R');
        this.exitMenuItem.setText(BasicSettings.getResourceString("exit", "Exit"));
        this.exitMenuItem.setMnemonic('x');
        this.helpMenu.setText(BasicSettings.getResourceString("help", "Help"));
        this.helpMenu.setMnemonic('H');
        this.aboutMenuItem.setText(BasicSettings.getResourceString("about", "About"));
        this.aboutMenuItem.setMnemonic('A');
        this.hlpMenuItem.setText(BasicSettings.getResourceString("help", "Help"));
        this.hlpMenuItem.setMnemonic('l');
        this.mainMenu.add(this.connectMenuItem);
        this.mainMenu.add(this.reconnectMenu);
        this.mainMenu.addSeparator();
        this.mainMenu.add(this.look_feel_Menu);
        this.mainMenu.addSeparator();
        this.mainMenu.add(this.exitMenuItem);
        this.helpMenu.add(this.hlpMenuItem);
        this.helpMenu.addSeparator();
        this.helpMenu.add(this.aboutMenuItem);
        this.add(this.mainMenu);
        this.add(this.theSeparator);
        this.add(this.helpMenu);
    }

    protected void initActions() {
        this.connectMenuItem.setActionCommand(MN_CONNECT_CMD);
        this.connectMenuItem.addActionListener(this.action);
        this.exitMenuItem.setActionCommand(MN_EXIT_CMD);
        this.exitMenuItem.addActionListener(this.action);
        this.externalMenuItem.setActionCommand(LF_EXTERN_CMD);
        this.externalMenuItem.addActionListener(this.action);
        this.aboutMenuItem.setActionCommand(HL_ABOUT_CMD);
        this.aboutMenuItem.addActionListener(this.action);
        this.hlpMenuItem.setActionCommand(HL_HELP_CMD);
        this.hlpMenuItem.addActionListener(this.action);
    }

    public boolean addVector(Vector target) {
        this.remove(this.theSeparator);
        this.remove(this.helpMenu);
        int i = 0;
        while (i < target.size()) {
            if (target.elementAt(i) != null) {
                this.add((JMenu)target.elementAt(i));
            }
            ++i;
        }
        this.add(this.theSeparator);
        this.add(this.helpMenu);
        return !target.isEmpty();
    }

    public void addMenu(JMenu target) {
        this.removeMenu(this.jumpMenu);
        this.jumpMenu = target;
        if (target != null) {
            this.remove(this.theSeparator);
            this.remove(this.helpMenu);
            this.add(target);
            this.add(this.theSeparator);
            this.add(this.helpMenu);
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public void removeMenu(JMenu target) {
        if (target != null) {
            this.remove(target);
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public void switchConnect(boolean isConnect) {
        if (isConnect) {
            this.connectMenuItem.setText(BasicSettings.getResourceString("disconnect", "Disconnect"));
            this.reconnectMenu.setEnabled(false);
        } else {
            this.connectMenuItem.setText(BasicSettings.getResourceString("connect", "Connect"));
            this.reconnectMenu.setEnabled(true);
        }
        this.repaint();
        this.validate();
    }

    public void setReconnectMenu(BasicOptions options) {
        if (this.reconnectMenu.getMenuComponentCount() > 0) {
            this.reconnectMenu.removeAll();
        }
        int i = 0;
        while (i < options.getReconnectCount()) {
            JMenuItem temp = new JMenuItem();
            temp.setText(options.getHostName(i) + " " + options.getUserName(i) + " : " + options.getPortNumber(i));
            temp.setActionCommand(MN_RECONNECT_CMD + String.valueOf(i));
            temp.addActionListener(this.action);
            this.reconnectMenu.add(temp);
            ++i;
        }
        this.reconnectMenu.setEnabled(options.getReconnectCount() > 0);
        JMenuItem conections = new JMenuItem(BasicSettings.getResourceString("ReconnectCount", "Reconnect Count"));
        conections.setActionCommand(MN_COUNT_CMD);
        conections.addActionListener(this.action);
        this.reconnectMenu.add(conections);
    }

    public void setLFRadio(JRadioButtonMenuItem radio) {
        this.currentLF = radio;
    }

    public void resetLFRadio() {
        if (this.currentLF != null) {
            this.currentLF.setSelected(true);
        }
    }

    public void setConnectProgress(boolean progress) {
        this.connectMenuItem.setEnabled(!progress);
        this.reconnectMenu.setEnabled(!progress);
    }

    public void setLookAndFeelMenu(BasicOptions options) {
        LookAndFeelFactory lfFactory = options.getLookAndFeelFactory();
        this.look_feel_Menu.removeAll();
        this.clearRadioGroup();
        Vector lf = lfFactory.getLookAndFeelNames();
        int defLF = lfFactory.getSystemLFCount();
        AbstractButton temp1 = null;
        String lfName = options.getLookAndFeel();
        String currentName = UIManager.getLookAndFeel().getName();
        int i = 0;
        while (i < lf.size()) {
            if (i == defLF) {
                this.look_feel_Menu.addSeparator();
            }
            String name = (String)lf.elementAt(i);
            JRadioButtonMenuItem temp = new JRadioButtonMenuItem();
            temp.setText(name);
            temp.addActionListener(this.action);
            temp.setActionCommand(LF + name);
            this.group.add(temp);
            this.look_feel_Menu.add(temp);
            if (lfName.equals(name)) {
                this.currentLF = temp;
            }
            if (currentName.equals(name)) {
                temp1 = temp;
            }
            ++i;
        }
        this.look_feel_Menu.addSeparator();
        this.look_feel_Menu.add(this.externalMenuItem);
        if (this.currentLF == null) {
            options.setLookAndFeel(temp1.getText());
            this.currentLF = temp1;
        }
        this.currentLF.setSelected(true);
    }

    private void clearRadioGroup() {
        Enumeration<AbstractButton> enumeration = this.group.getElements();
        while (enumeration.hasMoreElements()) {
            this.group.remove(enumeration.nextElement());
        }
    }
}

